/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class C3P0ConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, clr);
        }
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.mchange.v2.c3p0.DataSources", (String)"c3p0.jar");
        String dbURL = storeMgr.getConnectionURL();
        try {
            int size;
            Properties dbProps = C3P0ConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            DataSource unpooled = DataSources.unpooledDataSource((String)dbURL, (Properties)dbProps);
            Properties c3p0Props = new Properties();
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
                c3p0Props.setProperty("maxStatementsPerConnection", "" + size);
                c3p0Props.setProperty("maxStatements", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                c3p0Props.setProperty("maxPoolSize", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
                c3p0Props.setProperty("minPoolSize", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                c3p0Props.setProperty("initialPoolSize", "" + size);
            }
            PooledDataSource ds = (PooledDataSource)DataSources.pooledDataSource((DataSource)unpooled, (Properties)c3p0Props);
            return new C3P0ConnectionPool(ds);
        }
        catch (SQLException sqle) {
            throw new DatastorePoolException("c3p0", dbDriver, dbURL, sqle);
        }
    }

    public class C3P0ConnectionPool
    implements ConnectionPool {
        final PooledDataSource dataSource;

        public C3P0ConnectionPool(PooledDataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public void close() {
            try {
                this.dataSource.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

