/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class BigIntRDBMSMapping
extends AbstractDatastoreMapping {
    public BigIntRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                this.column.setCheckConstraints(this.storeMgr.getDatastoreAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable()));
            }
        }
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return -5;
    }

    @Override
    public void setInt(PreparedStatement ps, int param, int value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"int", "" + value}), (Throwable)e);
        }
    }

    @Override
    public int getInt(ResultSet rs, int param) {
        int value;
        try {
            value = (int)rs.getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"int", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(PreparedStatement ps, int param, long value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"long", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public long getLong(ResultSet rs, int param) {
        long value;
        try {
            value = rs.getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(Localiser.msg((String)"055003", (Object[])new Object[]{this.column}));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"long", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(PreparedStatement ps, int exprIndex, String value) {
        this.setLong(ps, exprIndex, Long.parseLong(value));
    }

    @Override
    public String getString(ResultSet resultSet, int exprIndex) {
        return Long.toString(this.getLong(resultSet, exprIndex));
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.useDefaultWhenNull()) {
                    ps.setLong(param, Long.parseLong(this.column.getDefaultValue().toString().trim()));
                } else {
                    ps.setNull(param, this.getJDBCType());
                }
            } else if (value instanceof Character) {
                ps.setInt(param, ((Character)value).charValue());
            } else if (value instanceof String) {
                ps.setLong(param, Long.parseLong((String)value));
            } else if (value instanceof Date) {
                ps.setLong(param, ((Date)value).getTime());
            } else {
                ps.setLong(param, ((Number)value).longValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"Long", "" + value, this.column, e.getMessage()}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Comparable<Long> value;
        block6: {
            try {
                String str = rs.getString(param);
                if (rs.wasNull()) {
                    value = null;
                    break block6;
                }
                try {
                    value = Long.valueOf(str);
                }
                catch (NumberFormatException nfe) {
                    value = new Double(str).longValue();
                }
                if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                    value = new Date((long)value);
                }
            }
            catch (SQLException e) {
                String msg = Localiser.msg((String)"055002", (Object[])new Object[]{"Long", "" + param, this.column, e.getMessage()});
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return value;
    }
}

