/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class DateRDBMSMapping
extends AbstractDatastoreMapping {
    public DateRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    @Override
    public int getJDBCType() {
        return 91;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block6: {
            try {
                if (value == null) {
                    ps.setNull(param, this.getJDBCType());
                    break block6;
                }
                if (value instanceof Calendar) {
                    ps.setDate(param, new java.sql.Date(((Calendar)value).getTime().getTime()));
                    break block6;
                }
                if (value instanceof java.sql.Date) {
                    ps.setDate(param, (java.sql.Date)value);
                    break block6;
                }
                if (value instanceof Date) {
                    ps.setDate(param, new java.sql.Date(((Date)value).getTime()));
                    break block6;
                }
                throw new NucleusDataStoreException("Cannot set DATE RDBMS type with value of type " + value.getClass().getName());
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"java.sql.Date", "" + value}), (Throwable)e);
            }
        }
    }

    protected java.sql.Date getDate(ResultSet rs, int param) {
        try {
            return rs.getDate(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"java.sql.Date", "" + param}), (Throwable)e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        java.sql.Date value = this.getDate(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new Date(value.getTime());
        }
        return value;
    }
}

