/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.sql.method.StringLength3Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring3Method;
import org.datanucleus.util.Localiser;

public class SAPDBAdapter
extends BaseDatastoreAdapter {
    public SAPDBAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("BooleanExpression");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("OrderByUsingSelectColumnIndex");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionNull");
        this.supportedOptions.remove("FkUpdateActionRestrict");
    }

    @Override
    public String getVendorID() {
        return "sapdb";
    }

    @Override
    public String getSelectWithLockOption() {
        return "EXCLUSIVE LOCK";
    }

    @Override
    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return "ALTER TABLE " + pk.getTable().toString() + " ADD " + pk;
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        Index idx = new Index(ck);
        idx.setName(ck.getName());
        return this.getCreateIndexStatement(idx, factory);
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return "ALTER TABLE " + fk.getTable().toString() + " ADD " + fk;
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT ");
        stmt.append(sequenceName);
        stmt.append(".nextval FROM dual");
        return stmt.toString();
    }

    @Override
    public Class getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className != null && "java.lang.String".equals(className)) {
            if ("length".equals(methodName)) {
                return StringLength3Method.class;
            }
            if ("substring".equals(methodName)) {
                return StringSubstring3Method.class;
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }
}

