/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.ClassNotPersistableException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.QueryResultMetaData;
import org.datanucleus.store.Extent;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultMetaDataROF;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class SQLQuery
extends Query {
    private static final long serialVersionUID = -6820729188666657398L;
    protected final transient String inputSQL;
    protected transient String compiledSQL = null;
    protected QueryResultMetaData resultMetaData = null;
    protected transient boolean isCompiled = false;
    protected transient StatementMappingIndex[] stmtMappings;

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec, SQLQuery query) {
        this(storeMgr, ec, query.inputSQL);
    }

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (String)null);
    }

    public SQLQuery(StoreManager storeMgr, ExecutionContext ec, String queryString) {
        super(storeMgr, ec);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.explicitVariables = null;
        this.explicitParameters = null;
        this.ordering = null;
        if (queryString == null) {
            throw new NucleusUserException(Localiser.msg((String)"059001"));
        }
        this.inputSQL = queryString.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
        String firstToken = this.inputSQL.trim().substring(0, 6).toUpperCase();
        if (firstToken.equals("SELECT")) {
            this.type = Query.QueryType.SELECT;
        } else if (firstToken.equals("DELETE")) {
            this.type = Query.QueryType.BULK_DELETE;
            this.unique = true;
        } else if (firstToken.equals("UPDATE") || firstToken.equals("INSERT") || firstToken.startsWith("MERGE")) {
            this.type = Query.QueryType.BULK_UPDATE;
            this.unique = true;
        } else {
            this.type = Query.QueryType.OTHER;
            this.unique = true;
        }
        if (ec.getApiAdapter().getName().equalsIgnoreCase("JDO")) {
            boolean allowAllSyntax = ec.getNucleusContext().getConfiguration().getBooleanProperty("datanucleus.query.sql.allowAll");
            if (ec.getProperty("datanucleus.query.sql.allowAll") != null) {
                allowAllSyntax = ec.getBooleanProperty("datanucleus.query.sql.allowAll");
            }
            if (!allowAllSyntax && !firstToken.equals("SELECT")) {
                throw new NucleusUserException(Localiser.msg((String)"059002", (Object[])new Object[]{this.inputSQL}));
            }
        }
    }

    public String getLanguage() {
        return "SQL";
    }

    public void setCandidates(Extent pcs) {
        throw new NucleusUserException(Localiser.msg((String)"059004"));
    }

    public void setCandidates(Collection pcs) {
        throw new NucleusUserException(Localiser.msg((String)"059005"));
    }

    public void setResult(String result) {
        throw new NucleusUserException(Localiser.msg((String)"059006"));
    }

    public void setResultMetaData(QueryResultMetaData qrmd) {
        this.resultMetaData = qrmd;
        super.setResultClass(null);
    }

    public void setResultClass(Class result_cls) {
        super.setResultClass(result_cls);
        this.resultMetaData = null;
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new NucleusUserException(Localiser.msg((String)"059007"));
    }

    public void setSubclasses(boolean subclasses) {
        throw new NucleusUserException(Localiser.msg((String)"059004"));
    }

    public void setFilter(String filter) {
        throw new NucleusUserException(Localiser.msg((String)"059008"));
    }

    public void declareExplicitVariables(String variables) {
        throw new NucleusUserException(Localiser.msg((String)"059009"));
    }

    public void declareExplicitParameters(String parameters) {
        throw new NucleusUserException(Localiser.msg((String)"059016"));
    }

    public void declareImports(String imports) {
        throw new NucleusUserException(Localiser.msg((String)"059026"));
    }

    public void setGrouping(String grouping) {
        throw new NucleusUserException(Localiser.msg((String)"059010"));
    }

    public void setOrdering(String ordering) {
        throw new NucleusUserException(Localiser.msg((String)"059011"));
    }

    protected long performDeletePersistentAll(Map parameters) {
        throw new NucleusUserException(Localiser.msg((String)"059000"));
    }

    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }

    public boolean processesRangeInDatastoreQuery() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.inputSQL.equals(((SQLQuery)((Object)obj)).inputSQL);
    }

    public int hashCode() {
        return super.hashCode() ^ this.inputSQL.hashCode();
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.compiledSQL = null;
        this.isCompiled = false;
        this.stmtMappings = null;
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    public void compileInternal(Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        this.compiledSQL = this.inputSQL;
        if (this.candidateClass != null && this.getType() == Query.QueryType.SELECT) {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
            if (cmd == null) {
                throw new ClassNotPersistableException(this.candidateClass.getName());
            }
            if (cmd.getPersistableSuperclass() != null) {
                // empty if block
            }
            if (this.getResultClass() == null) {
                String[] selectedColumns;
                String selections = SQLQuery.stripComments(this.compiledSQL.trim()).substring(7);
                int fromStart = selections.indexOf("FROM");
                if (fromStart == -1) {
                    fromStart = selections.indexOf("from");
                }
                if ((selectedColumns = StringUtils.split((String)(selections = selections.substring(0, fromStart).trim()), (String)",")) == null || selectedColumns.length == 0) {
                    throw new NucleusUserException(Localiser.msg((String)"059003", (Object[])new Object[]{this.compiledSQL}));
                }
                if (selectedColumns.length != 1 || !selectedColumns[0].trim().equals("*")) {
                    int i;
                    DatastoreClass table = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
                    PersistableMapping idMapping = (PersistableMapping)table.getIdMapping();
                    String[] idColNames = new String[idMapping.getNumberOfDatastoreMappings()];
                    boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreMappings()];
                    for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreMappings(); ++i2) {
                        idColNames[i2] = idMapping.getDatastoreMapping(i2).getColumn().getIdentifier().toString();
                        idColMissing[i2] = true;
                    }
                    JavaTypeMapping discrimMapping = table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
                    String discriminatorColName = discrimMapping != null ? discrimMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
                    JavaTypeMapping versionMapping = table.getSurrogateMapping(SurrogateColumnType.VERSION, false);
                    String versionColName = versionMapping != null ? versionMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
                    boolean discrimMissing = discriminatorColName != null;
                    boolean versionMissing = versionColName != null;
                    DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
                    AbstractClassMetaData candidateCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                    for (i = 0; i < selectedColumns.length; ++i) {
                        String colName = selectedColumns[i].trim();
                        if (colName.indexOf(" AS ") > 0) {
                            colName = colName.substring(colName.indexOf(" AS ") + 4).trim();
                        } else if (colName.indexOf(" as ") > 0) {
                            colName = colName.substring(colName.indexOf(" as ") + 4).trim();
                        }
                        if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                            if (SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) {
                                idColMissing[0] = false;
                            }
                        } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                            for (int j = 0; j < idColNames.length; ++j) {
                                if (!SQLQuery.columnNamesAreTheSame(dba, idColNames[j], colName)) continue;
                                idColMissing[j] = false;
                            }
                        }
                        if (discrimMissing && SQLQuery.columnNamesAreTheSame(dba, discriminatorColName, colName)) {
                            discrimMissing = false;
                            continue;
                        }
                        if (!versionMissing || !SQLQuery.columnNamesAreTheSame(dba, versionColName, colName)) continue;
                        versionMissing = false;
                    }
                    if (discrimMissing) {
                        throw new NucleusUserException(Localiser.msg((String)"059014", (Object[])new Object[]{this.compiledSQL, this.candidateClass.getName(), discriminatorColName}));
                    }
                    if (versionMissing) {
                        throw new NucleusUserException(Localiser.msg((String)"059015", (Object[])new Object[]{this.compiledSQL, this.candidateClass.getName(), versionColName}));
                    }
                    for (i = 0; i < idColMissing.length; ++i) {
                        if (!idColMissing[i]) continue;
                        throw new NucleusUserException(Localiser.msg((String)"059013", (Object[])new Object[]{this.compiledSQL, this.candidateClass.getName(), idColNames[i]}));
                    }
                }
            }
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"059012", (Object[])new Object[]{this.compiledSQL}));
        }
        this.isCompiled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected Object performExecute(Map parameters) {
        if (parameters.size() != (this.parameterNames != null ? this.parameterNames.length : 0)) {
            throw new NucleusUserException(Localiser.msg((String)"059019", (Object[])new Object[]{"" + this.parameterNames.length, "" + parameters.size()}));
        }
        if (this.type == Query.QueryType.BULK_DELETE || this.type == Query.QueryType.BULK_UPDATE) {
            try {
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    Long l;
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.compiledSQL, false);
                    try {
                        for (int i = 0; i < parameters.size(); ++i) {
                            ps.setObject(i + 1, parameters.get(i + 1));
                        }
                        int[] rcs = sqlControl.executeStatementUpdate(this.ec, mconn, this.compiledSQL, ps, true);
                        l = rcs[0];
                    }
                    catch (Throwable throwable) {
                        sqlControl.closeStatement(mconn, ps);
                        throw throwable;
                    }
                    sqlControl.closeStatement(mconn, ps);
                    return l;
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"059025", (Object[])new Object[]{this.compiledSQL}), (Throwable)e);
            }
        }
        if (this.type == Query.QueryType.SELECT) {
            AbstractRDBMSQueryResult qr = null;
            try {
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.ec);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.compiledSQL, this);
                    try {
                        for (int i = 0; i < parameters.size(); ++i) {
                            ps.setObject(i + 1, parameters.get(i + 1));
                        }
                        RDBMSQueryUtils.prepareStatementForExecution(ps, this, true);
                        ResultSet rs = sqlControl.executeStatementQuery(this.ec, mconn, this.compiledSQL, ps);
                        try {
                            ResultObjectFactory rof = null;
                            rof = this.resultMetaData != null ? new ResultMetaDataROF(storeMgr, this.resultMetaData) : (this.resultClass != null || this.candidateClass == null ? RDBMSQueryUtils.getResultObjectFactoryForNoCandidateClass(storeMgr, rs, this.resultClass) : this.getResultObjectFactoryForCandidateClass(rs));
                            String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(this);
                            qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult(this, rof, rs, null) : new ForwardQueryResult(this, rof, rs, null);
                            ((AbstractRDBMSQueryResult)qr).initialise();
                            AbstractRDBMSQueryResult qr1 = qr;
                            ManagedConnection mconn1 = mconn;
                            mconn.addListener(new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                final /* synthetic */ QueryResult val$qr1;
                                final /* synthetic */ ManagedConnection val$mconn1;
                                {
                                    this.val$qr1 = queryResult;
                                    this.val$mconn1 = managedConnection;
                                }

                                public void transactionFlushed() {
                                }

                                public void transactionPreClose() {
                                    this.val$qr1.disconnect();
                                }

                                public void managedConnectionPreClose() {
                                    if (!SQLQuery.this.ec.getTransaction().isActive()) {
                                        this.val$qr1.disconnect();
                                    }
                                }

                                public void managedConnectionPostClose() {
                                }

                                public void resourcePostClose() {
                                    this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                }
                            });
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    catch (QueryInterruptedException qie) {
                        ps.cancel();
                        throw qie;
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(Localiser.msg((String)"059025", (Object[])new Object[]{this.compiledSQL}), (Throwable)e);
            }
            return qr;
        }
        try {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(this.ec);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.compiledSQL, this);
                try {
                    for (int i = 0; i < parameters.size(); ++i) {
                        ps.setObject(i + 1, parameters.get(i + 1));
                    }
                    RDBMSQueryUtils.prepareStatementForExecution(ps, this, false);
                    sqlControl.executeStatement(this.ec, mconn, this.compiledSQL, ps);
                }
                catch (QueryInterruptedException qie) {
                    ps.cancel();
                    throw qie;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"059025", (Object[])new Object[]{this.compiledSQL}), (Throwable)e);
        }
        return true;
    }

    public Object executeWithArray(Object[] parameters) {
        HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameterMap.put(i + 1, parameters[i]);
            }
        }
        Map executionMap = this.prepareForExecution(parameterMap);
        return super.executeQuery(executionMap);
    }

    public Object executeWithMap(Map executeParameters) {
        Map executionMap = this.prepareForExecution(executeParameters);
        return super.executeQuery(executionMap);
    }

    protected Map prepareForExecution(Map executeParameters) {
        HashMap params = new HashMap();
        if (this.implicitParameters != null) {
            params.putAll(this.implicitParameters);
        }
        if (executeParameters != null) {
            params.putAll(executeParameters);
        }
        this.compileInternal(executeParameters);
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Object> expectedParams = new ArrayList<Object>();
        boolean complete = false;
        int charPos = 0;
        char[] statement = this.compiledSQL.toCharArray();
        StringBuilder paramName = null;
        int paramPos = 0;
        boolean colonParam = true;
        StringBuilder runtimeJdbcText = new StringBuilder();
        while (!complete) {
            char c = statement[charPos];
            boolean endOfParam = false;
            if (c == '?') {
                colonParam = false;
                ++paramPos;
                paramName = new StringBuilder();
            } else if (c == ':') {
                if (charPos > 0) {
                    char c2 = statement[charPos - 1];
                    if (!Character.isLetterOrDigit(c2)) {
                        colonParam = true;
                        ++paramPos;
                        paramName = new StringBuilder();
                    }
                } else {
                    colonParam = true;
                    ++paramPos;
                    paramName = new StringBuilder();
                }
            } else if (paramName != null) {
                if (Character.isLetterOrDigit(c)) {
                    paramName.append(c);
                } else {
                    endOfParam = true;
                }
            }
            if (paramName != null) {
                if (endOfParam) {
                    runtimeJdbcText.append('?');
                    runtimeJdbcText.append(c);
                }
            } else {
                runtimeJdbcText.append(c);
            }
            boolean bl = complete = ++charPos == this.compiledSQL.length();
            if (complete && paramName != null && !endOfParam) {
                runtimeJdbcText.append('?');
            }
            if (paramName == null || !complete && !endOfParam) continue;
            if (paramName.length() > 0) {
                if (colonParam) {
                    expectedParams.add(paramName.toString());
                } else {
                    try {
                        Integer n = Integer.valueOf(paramName.toString());
                        expectedParams.add(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NucleusUserException("SQL query " + this.inputSQL + " contains an invalid parameter specification " + paramName.toString());
                    }
                }
            } else if (!colonParam) {
                expectedParams.add(paramPos);
            }
            paramName = null;
        }
        this.compiledSQL = runtimeJdbcText.toString();
        if (expectedParams.size() > 0 && params.isEmpty()) {
            throw new NucleusUserException(Localiser.msg((String)"059028", (Object[])new Object[]{this.inputSQL, "" + expectedParams.size()}));
        }
        HashMap executeMap = new HashMap();
        paramPos = 1;
        for (Object e : expectedParams) {
            if (!params.containsKey(e)) {
                throw new NucleusUserException(Localiser.msg((String)"059031", (Object[])new Object[]{"" + e, this.inputSQL}));
            }
            executeMap.put(paramPos, params.get(e));
            paramNames.add("" + paramPos);
            ++paramPos;
        }
        this.parameterNames = paramNames.toArray(new String[paramNames.size()]);
        return executeMap;
    }

    protected void assertSupportsCancel() {
    }

    protected boolean supportsTimeout() {
        return true;
    }

    protected ResultObjectFactory getResultObjectFactoryForCandidateClass(ResultSet rs) throws SQLException {
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
        AbstractClassMetaData candidateCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        int fieldCount = candidateCmd.getNoOfManagedMembers() + candidateCmd.getNoOfInheritedManagedMembers();
        HashMap<String, Integer> columnFieldNumberMap = new HashMap<String, Integer>();
        this.stmtMappings = new StatementMappingIndex[fieldCount];
        DatastoreClass tbl = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
            AbstractMemberMetaData mmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String fieldName = mmd.getName();
            Class fieldType = mmd.getType();
            JavaTypeMapping m = null;
            if (mmd.getPersistenceModifier() != FieldPersistenceModifier.NONE && (m = tbl != null ? tbl.getMemberMapping(mmd) : storeMgr.getMappingManager().getMappingWithDatastoreMapping(fieldType, false, false, clr)).includeInFetchStatement()) {
                String columnName = null;
                if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                    for (int colNum = 0; colNum < mmd.getColumnMetaData().length; ++colNum) {
                        columnName = mmd.getColumnMetaData()[colNum].getName();
                        columnFieldNumberMap.put(columnName, fieldNumber);
                    }
                } else {
                    columnName = storeMgr.getIdentifierFactory().newColumnIdentifier(fieldName, this.ec.getNucleusContext().getTypeManager().isDefaultEmbeddedType(fieldType), FieldRole.ROLE_NONE, false).getName();
                    columnFieldNumberMap.put(columnName, fieldNumber);
                }
            }
            this.stmtMappings[fieldNumber] = new StatementMappingIndex(m);
        }
        if (columnFieldNumberMap.size() == 0) {
            throw new NucleusUserException(Localiser.msg((String)"059030", (Object[])new Object[]{this.candidateClass.getName()})).setFatal();
        }
        DatastoreClass table = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        if (table == null) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(candidateCmd, clr);
            if (cmds != null && cmds.length == 1) {
                table = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
            } else {
                throw new NucleusUserException("SQL query specified with class " + this.candidateClass.getName() + " but this doesn't have its own table, or is mapped to multiple tables. Unsupported");
            }
        }
        PersistableMapping idMapping = (PersistableMapping)table.getIdMapping();
        String[] idColNames = new String[idMapping.getNumberOfDatastoreMappings()];
        for (int i = 0; i < idMapping.getNumberOfDatastoreMappings(); ++i) {
            idColNames[i] = idMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString();
        }
        JavaTypeMapping discrimMapping = table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, false);
        String discrimColName = discrimMapping != null ? discrimMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
        JavaTypeMapping versionMapping = table.getSurrogateMapping(SurrogateColumnType.VERSION, false);
        String versionColName = versionMapping != null ? versionMapping.getDatastoreMapping(0).getColumn().getIdentifier().toString() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        HashSet remainingColumnNames = new HashSet(columnFieldNumberMap.size());
        int colCount = rsmd.getColumnCount();
        int[] datastoreIndex = null;
        int[] versionIndex = null;
        int[] discrimIndex = null;
        int[] matchedFieldNumbers = new int[colCount];
        int fieldNumberPosition = 0;
        for (int colNum = 1; colNum <= colCount; ++colNum) {
            String colName = rsmd.getColumnName(colNum);
            int fieldNumber = -1;
            Integer fieldNum = (Integer)columnFieldNumberMap.get(colName);
            if (fieldNum == null && (fieldNum = (Integer)columnFieldNumberMap.get(colName.toLowerCase())) == null) {
                fieldNum = (Integer)columnFieldNumberMap.get(colName.toUpperCase());
            }
            if (fieldNum != null) {
                fieldNumber = fieldNum;
            }
            if (fieldNumber >= 0) {
                int[] exprIndices = null;
                if (this.stmtMappings[fieldNumber].getColumnPositions() != null) {
                    exprIndices = new int[this.stmtMappings[fieldNumber].getColumnPositions().length + 1];
                    for (int i = 0; i < this.stmtMappings[fieldNumber].getColumnPositions().length; ++i) {
                        exprIndices[i] = this.stmtMappings[fieldNumber].getColumnPositions()[i];
                    }
                    exprIndices[exprIndices.length - 1] = colNum;
                } else {
                    exprIndices = new int[]{colNum};
                }
                this.stmtMappings[fieldNumber].setColumnPositions(exprIndices);
                remainingColumnNames.remove(colName);
                matchedFieldNumbers[fieldNumberPosition++] = fieldNumber;
            }
            if (discrimColName != null && colName.equals(discrimColName)) {
                discrimIndex = new int[]{colNum};
            }
            if (versionColName != null && colName.equals(versionColName)) {
                versionIndex = new int[]{colNum};
            }
            if (candidateCmd.getIdentityType() != IdentityType.DATASTORE || !SQLQuery.columnNamesAreTheSame(dba, idColNames[0], colName)) continue;
            datastoreIndex = new int[]{colNum};
        }
        int[] fieldNumbers = new int[fieldNumberPosition];
        for (int i = 0; i < fieldNumberPosition; ++i) {
            fieldNumbers[i] = matchedFieldNumbers[i];
        }
        StatementClassMapping mappingDefinition = new StatementClassMapping();
        for (int i = 0; i < fieldNumbers.length; ++i) {
            mappingDefinition.addMappingForMember(fieldNumbers[i], this.stmtMappings[fieldNumbers[i]]);
        }
        if (datastoreIndex != null) {
            StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(table.getSurrogateMapping(SurrogateColumnType.DATASTORE_ID, false));
            datastoreMappingIdx.setColumnPositions(datastoreIndex);
            mappingDefinition.addMappingForMember(SurrogateColumnType.DATASTORE_ID.getFieldNumber(), datastoreMappingIdx);
        }
        if (discrimIndex != null) {
            StatementMappingIndex discrimMappingIdx = new StatementMappingIndex(table.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, true));
            discrimMappingIdx.setColumnPositions(discrimIndex);
            mappingDefinition.addMappingForMember(SurrogateColumnType.DISCRIMINATOR.getFieldNumber(), discrimMappingIdx);
        }
        if (versionIndex != null) {
            StatementMappingIndex versionMappingIdx = new StatementMappingIndex(table.getSurrogateMapping(SurrogateColumnType.VERSION, true));
            versionMappingIdx.setColumnPositions(versionIndex);
            mappingDefinition.addMappingForMember(SurrogateColumnType.VERSION.getFieldNumber(), versionMappingIdx);
        }
        return new PersistentClassROF(storeMgr, candidateCmd, mappingDefinition, this.ignoreCache, this.getFetchPlan(), this.getCandidateClass());
    }

    public static boolean columnNamesAreTheSame(DatastoreAdapter dba, String name1, String name2) {
        return name1.equalsIgnoreCase(name2) || name1.equalsIgnoreCase(dba.getIdentifierQuoteString() + name2 + dba.getIdentifierQuoteString());
    }

    private static String stripComments(String sql) {
        return sql.replaceAll("(?:/\\*(?:[^*]|(?:\\*+[^*/]))*\\*+/)|(?://.*)", "");
    }
}

