/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MapContainsValueMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        AbstractMemberMetaData mmd;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"containsValue", "MapExpression", 1}));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression valExpr = args.get(0);
        if (valExpr.isParameter() && (mmd = mapExpr.getJavaTypeMapping().getMemberMetaData()) != null && mmd.getMap() != null) {
            Class valCls = this.stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getMap().getValueType());
            this.stmt.getQueryGenerator().bindParameter(valExpr.getParameterName(), valCls);
        }
        if (mapExpr instanceof MapLiteral) {
            MapLiteral lit = (MapLiteral)mapExpr;
            Map map = (Map)lit.getValue();
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            if (map == null || map.size() == 0) {
                return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
            }
            boolean useInExpression = false;
            List<SQLExpression> mapValExprs = lit.getValueLiteral().getValueExpressions();
            if (mapValExprs != null && !mapValExprs.isEmpty()) {
                SQLExpression mapKeyExpr2;
                boolean incompatible = true;
                Class elemtype = this.clr.classForName(valExpr.getJavaTypeMapping().getType());
                for (SQLExpression mapKeyExpr2 : mapValExprs) {
                    Class mapKeyType = this.clr.classForName(mapKeyExpr2.getJavaTypeMapping().getType());
                    if (!this.valueTypeCompatible(elemtype, mapKeyType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
                }
                mapKeyExpr2 = mapValExprs.get(0);
                if (mapKeyExpr2 instanceof StringExpression || mapKeyExpr2 instanceof NumericExpression || mapKeyExpr2 instanceof TemporalExpression || mapKeyExpr2 instanceof CharacterExpression || mapKeyExpr2 instanceof ByteExpression || mapKeyExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = mapValExprs != null ? mapValExprs.toArray(new SQLExpression[mapValExprs.size()]) : null;
                return new InExpression(valExpr, exprs);
            }
            MapLiteral.MapValueLiteral mapValueLiteral = lit.getValueLiteral();
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = mapValueLiteral.getValueExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(valExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(valExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            boolean useSubquery = this.getNeedsSubquery();
            SQLJoin.JoinType joinType = SQLJoin.JoinType.INNER_JOIN;
            if (valExpr instanceof UnboundExpression) {
                String varName = ((UnboundExpression)valExpr).getVariableName();
                String extensionName = "datanucleus.query.jdoql." + varName + ".join";
                String extensionValue = (String)this.stmt.getQueryGenerator().getValueForExtension(extensionName);
                if (extensionValue != null) {
                    if (extensionValue.equalsIgnoreCase("SUBQUERY")) {
                        useSubquery = true;
                    } else if (extensionValue.equalsIgnoreCase("INNERJOIN")) {
                        useSubquery = false;
                    } else if (extensionValue.equalsIgnoreCase("LEFTOUTERJOIN")) {
                        joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
                    }
                }
            }
            if (useSubquery) {
                return this.containsAsSubquery(mapExpr, valExpr);
            }
            return this.containsAsJoin(mapExpr, valExpr, joinType);
        }
        return this.containsAsSubquery(mapExpr, valExpr);
    }

    protected boolean getNeedsSubquery() {
        Boolean hasNOT;
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsJoin(MapExpression mapExpr, SQLExpression valExpr, SQLJoin.JoinType joinType) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        String valAlias = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("map.containsValue(" + valExpr + ") binding unbound variable " + varName + " using INNER JOIN"));
        } else if (!this.stmt.getQueryGenerator().hasExplicitJoins() && this.stmt.getJoinTypeForTable(valExpr.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN) {
            valAlias = this.stmt.removeCrossJoin(valExpr.getSQLTable());
            valIsUnbound = true;
            NucleusLogger.QUERY.debug((Object)("map.containsValue(" + valExpr + ") was previously bound as CROSS JOIN but changing to INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr);
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            MapTable mapTbl = (MapTable)storeMgr.getTable(mmd);
            SQLTable joinSqlTbl = this.stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), mapTbl, null, mapTbl.getOwnerMapping(), null, null);
            if (valCmd != null) {
                if (valIsUnbound) {
                    DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
                    SQLTable valSqlTbl = this.stmt.join(joinType, joinSqlTbl, mapTbl.getValueMapping(), valTbl, valAlias, valTbl.getIdMapping(), null, null);
                    valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valSqlTbl.getTable().getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getValueMapping());
                    this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getValueMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, mapTbl.getValueMapping());
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLTable valSqlTbl = this.stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), valTbl, valAlias, ownerMapping, null, null);
            if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(keyCmd.getFullClassName(), this.clr);
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            SQLTable keySqlTbl = this.stmt.join(joinType, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), keyTbl, null, ownerMapping, null, null);
            if (valCmd != null) {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(valCmd.getFullClassName(), this.clr);
                SQLTable valSqlTbl = this.stmt.join(joinType, keySqlTbl, keyTbl.getMemberMapping(keyValMmd), valTbl, valAlias, valTbl.getIdMapping(), null, null);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTbl.getIdMapping());
                    this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                this.stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                SQLExpression valIdExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTbl.getMemberMapping(keyValMmd));
                this.stmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(MapExpression mapExpr, SQLExpression valExpr) {
        boolean valIsUnbound = valExpr instanceof UnboundExpression;
        String varName = null;
        if (valIsUnbound) {
            varName = ((UnboundExpression)valExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)("map.containsValue binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(this.clr);
        MapTable joinTbl = (MapTable)storeMgr.getTable(mmd);
        SelectStatement subStmt = null;
        if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            if (valCmd == null) {
                subStmt = new SelectStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getValueMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
                subStmt = new SelectStatement(this.stmt, storeMgr, valTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), valTbl.getIdMapping(), joinTbl, null, joinTbl.getValueMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? valTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            subStmt = new SelectStatement(this.stmt, storeMgr, valTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (valIsUnbound) {
                valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
            } else {
                JavaTypeMapping valMapping = valTbl.getIdMapping();
                SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                subStmt.whereAnd(valIdExpr.eq(valExpr), true);
            }
        } else if (mmd.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(this.clr);
            DatastoreClass keyTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? keyTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTbl.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(mmd.getValueMetaData().getMappedBy());
            if (valCmd == null) {
                subStmt = new SelectStatement(this.stmt, storeMgr, keyTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyTbl.getMemberMapping(keyValMmd));
                    this.stmt.getQueryGenerator().bindVariable(varName, null, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    JavaTypeMapping valMapping = keyTbl.getMemberMapping(keyValMmd);
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            } else {
                DatastoreClass valTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
                subStmt = new SelectStatement(this.stmt, storeMgr, valTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable keySqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), valTbl.getIdMapping(), keyTbl, null, keyTbl.getMemberMapping(keyValMmd), null, null);
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, keySqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                if (valIsUnbound) {
                    valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    this.stmt.getQueryGenerator().bindVariable(varName, valCmd, valExpr.getSQLTable(), valExpr.getJavaTypeMapping());
                } else {
                    SQLExpression valIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valTbl.getIdMapping());
                    subStmt.whereAnd(valIdExpr.eq(valExpr), true);
                }
            }
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }

    protected boolean valueTypeCompatible(Class valType, Class mapValType) {
        if (!valType.isPrimitive() && mapValType.isPrimitive() && !mapValType.isAssignableFrom(valType) && !valType.isAssignableFrom(mapValType)) {
            return false;
        }
        if (valType.isPrimitive()) {
            if (valType == Boolean.TYPE && mapValType == Boolean.class) {
                return true;
            }
            if (valType == Byte.TYPE && mapValType == Byte.class) {
                return true;
            }
            if (valType == Character.TYPE && mapValType == Character.class) {
                return true;
            }
            if (valType == Double.TYPE && mapValType == Double.class) {
                return true;
            }
            if (valType == Float.TYPE && mapValType == Float.class) {
                return true;
            }
            if (valType == Integer.TYPE && mapValType == Integer.class) {
                return true;
            }
            if (valType == Long.TYPE && mapValType == Long.class) {
                return true;
            }
            return valType == Short.TYPE && mapValType == Short.class;
        }
        return true;
    }
}

