/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.AbstractSelectStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.table.SurrogateColumnType;

public class DiscriminatorStatementGenerator
extends AbstractSelectStatementGenerator {
    Class[] candidates = null;

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        super(storeMgr, clr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName);
        this.setOption("restrictDiscriminator");
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class[] candidateTypes, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName) {
        this(storeMgr, clr, candidateTypes[0], includeSubclasses, candidateTableAlias, candidateTableGroupName);
        this.candidates = candidateTypes;
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, Table joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        super(storeMgr, clr, candidateType, includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
        this.setOption("restrictDiscriminator");
    }

    public DiscriminatorStatementGenerator(RDBMSStoreManager storeMgr, ClassLoaderResolver clr, Class[] candidateTypes, boolean includeSubclasses, DatastoreIdentifier candidateTableAlias, String candidateTableGroupName, Table joinTable, DatastoreIdentifier joinTableAlias, JavaTypeMapping joinElementMapping) {
        this(storeMgr, clr, candidateTypes[0], includeSubclasses, candidateTableAlias, candidateTableGroupName, joinTable, joinTableAlias, joinElementMapping);
        this.candidates = candidateTypes;
    }

    @Override
    public void setParentStatement(SQLStatement stmt) {
        this.parentStmt = stmt;
    }

    @Override
    public SelectStatement getStatement(ExecutionContext ec) {
        JavaTypeMapping softDeleteMapping;
        JavaTypeMapping multitenancyMapping;
        SelectStatement stmt = null;
        SQLTable discrimSqlTbl = null;
        if (this.joinTable == null) {
            stmt = new SelectStatement(this.parentStmt, this.storeMgr, this.candidateTable, this.candidateTableAlias, this.candidateTableGroupName);
            stmt.setClassLoaderResolver(this.clr);
            discrimSqlTbl = stmt.getPrimaryTable();
        } else {
            stmt = new SelectStatement(this.parentStmt, this.storeMgr, this.joinTable, this.joinTableAlias, this.candidateTableGroupName);
            stmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping candidateIdMapping = this.candidateTable.getIdMapping();
            discrimSqlTbl = this.hasOption("allowNulls") ? stmt.leftOuterJoin(null, this.joinElementMapping, this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName()) : stmt.innerJoin(null, this.joinElementMapping, this.candidateTable, null, candidateIdMapping, null, stmt.getPrimaryTable().getGroupName());
        }
        JavaTypeMapping discMapping = this.candidateTable.getSurrogateMapping(SurrogateColumnType.DISCRIMINATOR, true);
        if (discMapping != null) {
            discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, discrimSqlTbl, discMapping);
        }
        DiscriminatorMetaData dismd = discrimSqlTbl.getTable().getDiscriminatorMetaData();
        boolean hasDiscriminator = discMapping != null && dismd != null && dismd.getStrategy() != DiscriminatorStrategy.NONE;
        boolean restrictDiscriminator = this.hasOption("restrictDiscriminator");
        if (hasDiscriminator && restrictDiscriminator) {
            boolean multipleCandidates = false;
            BooleanExpression discExpr = null;
            if (this.candidates != null) {
                if (this.candidates.length > 1) {
                    multipleCandidates = true;
                }
                for (int i = 0; i < this.candidates.length; ++i) {
                    if (Modifier.isAbstract(this.candidates[i].getModifiers())) continue;
                    BooleanExpression discExprCandidate = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, this.candidates[i].getName(), dismd, discMapping, discrimSqlTbl, this.clr);
                    discExpr = discExpr != null ? discExpr.ior(discExprCandidate) : discExprCandidate;
                    if (!this.includeSubclasses) continue;
                    Collection subclassNames = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, this.clr);
                    Iterator subclassIter = subclassNames.iterator();
                    if (!multipleCandidates) {
                        boolean bl = multipleCandidates = subclassNames.size() > 0;
                    }
                    while (subclassIter.hasNext()) {
                        String subclassName = (String)subclassIter.next();
                        BooleanExpression discExprSub = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, subclassName, dismd, discMapping, discrimSqlTbl, this.clr);
                        discExpr = discExpr.ior(discExprSub);
                    }
                }
            } else {
                if (!Modifier.isAbstract(this.candidateType.getModifiers())) {
                    discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, this.candidateType.getName(), dismd, discMapping, discrimSqlTbl, this.clr);
                }
                if (this.includeSubclasses) {
                    Collection subclassNames = this.storeMgr.getSubClassesForClass(this.candidateType.getName(), true, this.clr);
                    Iterator subclassIter = subclassNames.iterator();
                    boolean bl = multipleCandidates = subclassNames.size() > 0;
                    while (subclassIter.hasNext()) {
                        String subclassName = (String)subclassIter.next();
                        Class subclass = this.clr.classForName(subclassName);
                        if (Modifier.isAbstract(subclass.getModifiers())) continue;
                        BooleanExpression discExprCandidate = SQLStatementHelper.getExpressionForDiscriminatorForClass(stmt, subclassName, dismd, discMapping, discrimSqlTbl, this.clr);
                        if (discExpr == null) {
                            discExpr = discExprCandidate;
                            continue;
                        }
                        discExpr = discExpr.ior(discExprCandidate);
                    }
                }
                if (discExpr == null) {
                    SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
                    JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
                    discExpr = exprFactory.newLiteral(stmt, m, true).eq(exprFactory.newLiteral(stmt, m, false));
                }
            }
            if (this.hasOption("allowNulls")) {
                SQLExpression expr = stmt.getSQLExpressionFactory().newExpression(stmt, discrimSqlTbl, discMapping);
                NullLiteral val = new NullLiteral(stmt, null, null, null);
                BooleanExpression nullDiscExpr = expr.eq(val);
                discExpr = discExpr.ior(nullDiscExpr);
                if (!multipleCandidates) {
                    multipleCandidates = true;
                }
            }
            if (multipleCandidates) {
                discExpr.encloseInParentheses();
            }
            stmt.whereAnd(discExpr, true);
        }
        if ((multitenancyMapping = this.candidateTable.getSurrogateMapping(SurrogateColumnType.MULTITENANCY, false)) != null) {
            AbstractClassMetaData cmd = this.candidateTable.getClassMetaData();
            SQLTable tenantSqlTbl = stmt.getTable(multitenancyMapping.getTable(), discrimSqlTbl.getGroupName());
            SQLExpression tenantExpr = stmt.getSQLExpressionFactory().newExpression(stmt, tenantSqlTbl, multitenancyMapping);
            SQLExpression tenantVal = stmt.getSQLExpressionFactory().newLiteral(stmt, multitenancyMapping, ec.getNucleusContext().getMultiTenancyId(ec, cmd));
            stmt.whereAnd(tenantExpr.eq(tenantVal), true);
        }
        if ((softDeleteMapping = this.candidateTable.getSurrogateMapping(SurrogateColumnType.SOFTDELETE, false)) != null && !this.hasOption("includeSoftDeletes")) {
            SQLTable softDeleteSqlTbl = stmt.getTable(softDeleteMapping.getTable(), discrimSqlTbl.getGroupName());
            SQLExpression softDeleteExpr = stmt.getSQLExpressionFactory().newExpression(stmt, softDeleteSqlTbl, softDeleteMapping);
            SQLExpression softDeleteVal = stmt.getSQLExpressionFactory().newLiteral(stmt, softDeleteMapping, Boolean.FALSE);
            stmt.whereAnd(softDeleteExpr.eq(softDeleteVal), true);
        }
        return stmt;
    }
}

