/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.ContainerAdapter;
import org.datanucleus.store.types.ElementContainerHandler;

public class SingleCollectionMapping
extends JavaTypeMapping
implements MappingCallbacks {
    private JavaTypeMapping wrappedMapping;
    private Class wrappedTypeClass;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        CollectionMetaData collectionMetaData = mmd.getCollection();
        String wrappedTypeName = collectionMetaData.getElementType();
        this.wrappedTypeClass = clr.classForName(wrappedTypeName);
        WrappedMemberMetaData wmmd = new WrappedMemberMetaData(mmd, this.wrappedTypeClass, clr);
        this.wrappedMapping = table.getStoreManager().getMappingManager().getMapping(table, wmmd, clr, FieldRole.ROLE_FIELD);
        super.initialize(mmd, table, clr);
    }

    @Override
    public void setMemberMetaData(AbstractMemberMetaData mmd) {
        super.setMemberMetaData(mmd);
        this.wrappedMapping.setMemberMetaData(new WrappedMemberMetaData(mmd, this.wrappedTypeClass, this.getStoreManager().getNucleusContext().getClassLoaderResolver(null)));
    }

    public JavaTypeMapping getWrappedMapping() {
        return this.wrappedMapping;
    }

    @Override
    public boolean includeInFetchStatement() {
        return this.wrappedMapping.includeInFetchStatement();
    }

    @Override
    public boolean hasSimpleDatastoreRepresentation() {
        return this.wrappedMapping == null ? false : this.wrappedMapping.hasSimpleDatastoreRepresentation();
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] pos, Object container) {
        Object value = null;
        if (container != null) {
            ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(this.mmd.getType());
            ContainerAdapter containerAdapter = containerHandler.getAdapter(container);
            Iterator iterator = containerAdapter.iterator();
            value = iterator.hasNext() ? iterator.next() : null;
        }
        this.wrappedMapping.setObject(ec, ps, pos, value);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        Object object = this.wrappedMapping.getObject(ec, rs, exprIndex);
        ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(this.mmd.getType());
        return containerHandler.newContainer(this.mmd, new Object[]{object});
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex, ObjectProvider ownerOP, int ownerFieldNumber) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public int getNumberOfDatastoreMappings() {
        return this.wrappedMapping.getNumberOfDatastoreMappings();
    }

    @Override
    public DatastoreMapping[] getDatastoreMappings() {
        return this.wrappedMapping.getDatastoreMappings();
    }

    @Override
    public DatastoreMapping getDatastoreMapping(int index) {
        return this.wrappedMapping.getDatastoreMapping(index);
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        return this.wrappedMapping.getJavaTypeForDatastoreMapping(index);
    }

    @Override
    public void insertPostProcessing(ObjectProvider op) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).insertPostProcessing(op);
        }
    }

    @Override
    public void postInsert(ObjectProvider op) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postInsert(op);
        }
    }

    @Override
    public void postFetch(ObjectProvider op) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postFetch(op);
        }
    }

    @Override
    public void postUpdate(ObjectProvider op) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postUpdate(op);
        }
    }

    @Override
    public void preDelete(ObjectProvider op) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).preDelete(op);
        }
    }

    @Override
    public Class getJavaType() {
        return this.wrappedMapping.getJavaType();
    }

    private class WrappedMemberMetaData
    extends AbstractMemberMetaData {
        private static final long serialVersionUID = 8346519560709746659L;
        private AbstractMemberMetaData singleCollectionMetadata;

        public WrappedMemberMetaData(AbstractMemberMetaData fmd, Class type, ClassLoaderResolver clr) {
            super(fmd.getParent(), fmd);
            this.singleCollectionMetadata = fmd;
            this.type = type;
            this.columnMetaData = fmd.getElementMetaData() != null ? fmd.getElementMetaData().getColumnMetaData() : fmd.getColumnMetaData();
            this.relationType = fmd.getRelationType(clr);
            this.relatedMemberMetaData = fmd.getRelatedMemberMetaData(clr);
            ElementMetaData fmdElementMetaData = fmd.getElementMetaData();
            if (fmdElementMetaData != null && fmdElementMetaData.getEmbeddedMetaData() != null) {
                this.setEmbeddedMetaData(fmdElementMetaData.getEmbeddedMetaData());
            }
        }

        public int getAbsoluteFieldNumber() {
            return this.singleCollectionMetadata.getAbsoluteFieldNumber();
        }

        public boolean isDependent() {
            return super.isDependent() || this.getCollection().isDependentElement();
        }

        public String toString() {
            return "Wrapped[" + this.getName() + "]\n" + super.toString();
        }
    }
}

