/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayExpression;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.InExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.ArrayTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.util.NucleusLogger;

public class ArrayContainsMethod
extends AbstractSQLMethod {
    @Override
    public SQLExpression getExpression(SQLExpression expr, List<SQLExpression> args) {
        Class<?> elemCls;
        AbstractMemberMetaData mmd;
        if (args == null || args.size() != 1) {
            throw new NucleusException("Incorrect arguments for Array.contains(SQLExpression)");
        }
        ArrayExpression arrExpr = (ArrayExpression)expr;
        SQLExpression elemExpr = args.get(0);
        if (elemExpr.isParameter() && (mmd = arrExpr.getJavaTypeMapping().getMemberMetaData()) != null) {
            this.stmt.getQueryGenerator().bindParameter(elemExpr.getParameterName(), mmd.getType().getComponentType());
        }
        if (expr instanceof ArrayLiteral) {
            if (elemExpr instanceof UnboundExpression) {
                elemCls = this.clr.classForName(arrExpr.getJavaTypeMapping().getType()).getComponentType();
                elemExpr = this.stmt.getQueryGenerator().bindVariable((UnboundExpression)elemExpr, elemCls);
            }
            ArrayLiteral lit = (ArrayLiteral)expr;
            Object array = lit.getValue();
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            if (array == null || Array.getLength(array) == 0) {
                return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
            }
            boolean useInExpression = false;
            List<SQLExpression> collElementExprs = lit.getElementExpressions();
            if (collElementExprs != null && !collElementExprs.isEmpty()) {
                SQLExpression collElementExpr2;
                boolean incompatible = true;
                Class elemtype = this.clr.classForName(elemExpr.getJavaTypeMapping().getType());
                for (SQLExpression collElementExpr2 : collElementExprs) {
                    Class collElemType = this.clr.classForName(collElementExpr2.getJavaTypeMapping().getType());
                    if (!this.elementTypeCompatible(elemtype, collElemType)) continue;
                    incompatible = false;
                    break;
                }
                if (incompatible) {
                    return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
                }
                collElementExpr2 = collElementExprs.get(0);
                if (collElementExpr2 instanceof StringExpression || collElementExpr2 instanceof NumericExpression || collElementExpr2 instanceof TemporalExpression || collElementExpr2 instanceof CharacterExpression || collElementExpr2 instanceof ByteExpression || collElementExpr2 instanceof EnumExpression) {
                    useInExpression = true;
                }
            }
            if (useInExpression) {
                SQLExpression[] exprs = collElementExprs != null ? collElementExprs.toArray(new SQLExpression[collElementExprs.size()]) : null;
                return new InExpression(elemExpr, exprs);
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = lit.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                SQLExpression arrElemExpr = elementExprs.get(i);
                bExpr = bExpr == null ? arrElemExpr.eq(elemExpr) : ((BooleanExpression)bExpr).ior(arrElemExpr.eq(elemExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        if (arrExpr.getElementExpressions() != null) {
            if (elemExpr instanceof UnboundExpression) {
                elemCls = this.clr.classForName(arrExpr.getJavaTypeMapping().getType()).getComponentType();
                elemExpr = this.stmt.getQueryGenerator().bindVariable((UnboundExpression)elemExpr, elemCls);
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = arrExpr.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                SQLExpression arrElemExpr = elementExprs.get(i);
                bExpr = bExpr == null ? arrElemExpr.eq(elemExpr) : ((BooleanExpression)bExpr).ior(arrElemExpr.eq(elemExpr));
            }
            if (bExpr != null) {
                bExpr.encloseInParentheses();
            }
            return bExpr;
        }
        return this.containsAsSubquery(arrExpr, elemExpr);
    }

    protected SQLExpression containsAsSubquery(ArrayExpression arrExpr, SQLExpression elemExpr) {
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> Array.contains binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = arrExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager());
        ArrayTable joinTbl = (ArrayTable)storeMgr.getTable(mmd);
        SelectStatement subStmt = null;
        if (joinTbl != null) {
            if (elemCmd == null) {
                subStmt = new SelectStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, arrExpr.getSQLTable(), arrExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getArray().getElementType(), this.clr);
                subStmt = new SelectStatement(this.stmt, storeMgr, elemTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, arrExpr.getSQLTable(), arrExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            }
        } else {
            throw new NucleusException("Dont support evaluation of ARRAY.contains when no join table is used");
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }

    protected boolean elementTypeCompatible(Class elementType, Class collectionElementType) {
        if (!elementType.isPrimitive() && collectionElementType.isPrimitive() && !collectionElementType.isAssignableFrom(elementType) && !elementType.isAssignableFrom(collectionElementType)) {
            return false;
        }
        if (elementType.isPrimitive()) {
            if (elementType == Boolean.TYPE && collectionElementType == Boolean.class) {
                return true;
            }
            if (elementType == Byte.TYPE && collectionElementType == Byte.class) {
                return true;
            }
            if (elementType == Character.TYPE && collectionElementType == Character.class) {
                return true;
            }
            if (elementType == Double.TYPE && collectionElementType == Double.class) {
                return true;
            }
            if (elementType == Float.TYPE && collectionElementType == Float.class) {
                return true;
            }
            if (elementType == Integer.TYPE && collectionElementType == Integer.class) {
                return true;
            }
            if (elementType == Long.TYPE && collectionElementType == Long.class) {
                return true;
            }
            return elementType == Short.TYPE && collectionElementType == Short.class;
        }
        return true;
    }
}

