/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.scostore.ArrayStore;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractArrayStore<E>
extends ElementContainerStore
implements ArrayStore<E> {
    protected AbstractArrayStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public List<E> getArray(ObjectProvider op) {
        Iterator<E> iter = this.iterator(op);
        ArrayList<E> elements = new ArrayList<E>();
        while (iter.hasNext()) {
            E obj = iter.next();
            elements.add(obj);
        }
        return elements;
    }

    @Override
    public void clear(ObjectProvider op) {
        HashSet<E> dependentElements = null;
        if (this.ownerMemberMetaData.getArray().isDependentElement()) {
            dependentElements = new HashSet<E>();
            Iterator<E> iter = this.iterator(op);
            while (iter.hasNext()) {
                dependentElements.add(iter.next());
            }
        }
        this.clearInternal(op);
        if (dependentElements != null && dependentElements.size() > 0) {
            op.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(ObjectProvider op, Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return true;
        }
        ExecutionContext ec = op.getExecutionContext();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object obj = Array.get(array, i);
            this.validateElementForWriting(ec, obj, null);
        }
        boolean modified = false;
        ArrayList<MappedDatastoreException> exceptions = new ArrayList<MappedDatastoreException>();
        boolean batched = this.allowsBatching() && length > 1;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                this.processBatchedWrites(mconn);
                Object element = null;
                for (int i = 0; i < length; ++i) {
                    element = Array.get(array, i);
                    try {
                        int[] rc = this.internalAdd(op, element, mconn, batched, i, i == length - 1);
                        if (rc == null) continue;
                        for (int j = 0; j < rc.length; ++j) {
                            if (rc[j] <= 0) continue;
                            modified = true;
                        }
                        continue;
                    }
                    catch (MappedDatastoreException mde) {
                        exceptions.add(mde);
                        NucleusLogger.DATASTORE.error((Object)"Exception thrown in set of element", (Throwable)mde);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            exceptions.add(e);
            NucleusLogger.DATASTORE.error((Object)"Exception thrown in set of element", (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            String msg = Localiser.msg((String)"056009", (Object[])new Object[]{((Exception)exceptions.get(0)).getMessage()});
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]), op.getObject());
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ObjectProvider op, E element, int position) {
        ExecutionContext ec = op.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        boolean modified = false;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                int[] returnCode = this.internalAdd(op, element, mconn, false, position, true);
                if (returnCode[0] > 0) {
                    modified = true;
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056009", (Object[])new Object[]{e.getMessage()}), e.getCause());
        }
        return modified;
    }

    @Override
    public abstract Iterator<E> iterator(ObjectProvider var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInternal(ObjectProvider ownerOP) {
        String clearStmt = this.getClearStmt();
        try {
            ExecutionContext ec = ownerOP.getExecutionContext();
            ManagedConnection mconn = this.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerOP, ec, ps, jdbcPosition, this);
                    if (this.relationDiscriminatorMapping != null) {
                        BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"056013", (Object[])new Object[]{clearStmt}), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] internalAdd(ObjectProvider op, E element, ManagedConnection conn, boolean batched, int orderId, boolean executeNow) throws MappedDatastoreException {
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmtForJoinTable();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, false);
            boolean notYetFlushedError = false;
            try {
                int jdbcPosition = 1;
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, orderId, jdbcPosition, this.orderMapping);
                if (this.relationDiscriminatorMapping != null) {
                    jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                }
                int[] nArray = sqlControl.executeStatementUpdate(ec, conn, addStmt, ps, executeNow);
                return nArray;
            }
            catch (NotYetFlushedException nfe) {
                notYetFlushedError = true;
                throw nfe;
            }
            finally {
                if (notYetFlushedError) {
                    sqlControl.abortStatementForConnection(conn, ps);
                } else {
                    sqlControl.closeStatement(conn, ps);
                }
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(addStmt, e);
        }
    }

    public void processBatchedWrites(ManagedConnection mconn) throws MappedDatastoreException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            sqlControl.processStatementsForConnection(mconn);
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", e);
        }
    }
}

