/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.datanucleus.ExecutionContext;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.mapping.datastore.OracleBlobRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.CollectionMapping;
import org.datanucleus.store.types.SCOUtils;

public class OracleCollectionMapping
extends CollectionMapping {
    @Override
    public void postInsert(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            ExecutionContext ec = ownerOP.getExecutionContext();
            Collection value = (Collection)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            SCOUtils.validateObjectsForWriting((ExecutionContext)ec, (Object)value);
            byte[] bytes = new byte[]{};
            if (value != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    bytes = baos.toByteArray();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            OracleBlobRDBMSMapping.updateBlobColumn(ownerOP, this.getTable(), this.getDatastoreMapping(0), bytes);
        } else {
            super.postInsert(ownerOP);
        }
    }

    @Override
    public void postUpdate(ObjectProvider ownerOP) {
        if (this.containerIsStoredInSingleColumn()) {
            ExecutionContext ec = ownerOP.getExecutionContext();
            Collection value = (Collection)ownerOP.provideField(this.mmd.getAbsoluteFieldNumber());
            SCOUtils.validateObjectsForWriting((ExecutionContext)ec, (Object)value);
            this.postInsert(ownerOP);
        } else {
            super.postUpdate(ownerOP);
        }
    }
}

