/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;

public class ListStoreIterator
implements ListIterator {
    private final ObjectProvider op;
    private final ListIterator delegate;
    private Object lastElement = null;
    private int currentIndex = -1;
    private final AbstractListStore abstractListStore;

    ListStoreIterator(ObjectProvider op, ResultSet resultSet, ResultObjectFactory rof, AbstractListStore als) throws MappedDatastoreException {
        this.op = op;
        this.abstractListStore = als;
        ExecutionContext ec = op.getExecutionContext();
        ArrayList<Object> results = new ArrayList<Object>();
        if (resultSet != null) {
            Table containerTable = als.getContainerTable();
            boolean elementsAreSerialised = als.isElementsAreSerialised();
            boolean elementsAreEmbedded = als.isElementsAreEmbedded();
            JavaTypeMapping elementMapping = als.getElementMapping();
            while (this.next(resultSet)) {
                Object nextElement;
                int i;
                int[] param;
                if (elementsAreEmbedded || elementsAreSerialised) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    if (elementMapping instanceof SerialisedPCMapping || elementMapping instanceof SerialisedReferenceMapping || elementMapping instanceof EmbeddedElementPCMapping) {
                        int ownerFieldNumber = -1;
                        if (containerTable != null) {
                            ownerFieldNumber = this.getOwnerMemberMetaData(this.abstractListStore.containerTable).getAbsoluteFieldNumber();
                        }
                        nextElement = elementMapping.getObject(ec, resultSet, param, op, ownerFieldNumber);
                    } else {
                        nextElement = elementMapping.getObject(ec, resultSet, param);
                    }
                } else if (elementMapping instanceof ReferenceMapping) {
                    param = new int[elementMapping.getNumberOfDatastoreMappings()];
                    for (i = 0; i < param.length; ++i) {
                        param[i] = i + 1;
                    }
                    nextElement = elementMapping.getObject(ec, resultSet, param);
                } else {
                    nextElement = rof.getObject(ec, resultSet);
                }
                results.add(nextElement);
            }
        }
        this.delegate = results.listIterator();
    }

    public void add(Object o) {
        this.currentIndex = this.delegate.nextIndex();
        this.abstractListStore.add(this.op, o, this.currentIndex, -1);
        this.delegate.add(o);
        this.lastElement = null;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public boolean hasPrevious() {
        return this.delegate.hasPrevious();
    }

    @Override
    public Object next() {
        this.currentIndex = this.delegate.nextIndex();
        this.lastElement = this.delegate.next();
        return this.lastElement;
    }

    @Override
    public int nextIndex() {
        return this.delegate.nextIndex();
    }

    public Object previous() {
        this.currentIndex = this.delegate.previousIndex();
        this.lastElement = this.delegate.previous();
        return this.lastElement;
    }

    @Override
    public int previousIndex() {
        return this.delegate.previousIndex();
    }

    @Override
    public synchronized void remove() {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to remove");
        }
        this.abstractListStore.remove(this.op, this.currentIndex, -1);
        this.delegate.remove();
        this.lastElement = null;
        this.currentIndex = -1;
    }

    public synchronized void set(Object o) {
        if (this.lastElement == null) {
            throw new IllegalStateException("No entry to replace");
        }
        this.abstractListStore.set(this.op, this.currentIndex, o, true);
        this.delegate.set(o);
        this.lastElement = o;
    }

    protected AbstractMemberMetaData getOwnerMemberMetaData(Table containerTable) {
        return ((JoinTable)containerTable).getOwnerMemberMetaData();
    }

    protected boolean next(Object resultSet) throws MappedDatastoreException {
        try {
            return ((ResultSet)resultSet).next();
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(e.getMessage(), e);
        }
    }
}

