/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.converters.TypeConverterHelper;

public class UUIDMapping
extends SingleFieldMapping {
    TypeConverter converter;

    @Override
    public void initialize(RDBMSStoreManager storeMgr, String type) {
        ColumnMetaData colmd;
        ColumnMetaData[] colmds;
        boolean useConverter = true;
        if (this.mmd != null && (colmds = this.mmd.getColumnMetaData()) != null && colmds.length == 1 && (colmd = colmds[0]).getSqlType() != null) {
            useConverter = false;
        }
        if (useConverter) {
            ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
            Class fieldType = clr.classForName(type);
            this.converter = storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(fieldType);
            if (this.converter == null) {
                throw new NucleusUserException("Unable to find TypeConverter for converting " + fieldType + " to String");
            }
        }
        super.initialize(storeMgr, type);
    }

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        ColumnMetaData colmd;
        ColumnMetaData[] colmds;
        boolean useConverter = true;
        if (mmd != null && (colmds = mmd.getColumnMetaData()) != null && colmds.length == 1 && (colmd = colmds[0]).getSqlType() != null) {
            useConverter = false;
        }
        if (useConverter) {
            this.converter = mmd.getTypeConverterName() != null ? table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName()) : table.getStoreManager().getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
        }
        super.initialize(mmd, table, clr);
    }

    @Override
    public Class getJavaType() {
        return UUID.class;
    }

    @Override
    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.converter == null) {
            return UUID.class.getName();
        }
        return TypeConverterHelper.getDatastoreTypeForTypeConverter((TypeConverter)this.converter, (Class)this.getJavaType()).getName();
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        if (exprIndex == null) {
            return;
        }
        if (this.converter == null) {
            super.setObject(ec, ps, exprIndex, value);
        } else {
            this.getDatastoreMapping(0).setObject(ps, exprIndex[0], this.converter.toDatastoreType(value));
        }
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (exprIndex == null) {
            return null;
        }
        if (this.converter == null) {
            return super.getObject(ec, resultSet, exprIndex);
        }
        Object datastoreValue = this.getDatastoreMapping(0).getObject(resultSet, exprIndex[0]);
        return datastoreValue != null ? this.converter.toMemberType(datastoreValue) : null;
    }
}

