/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.identifier;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.AbstractIdentifierFactory;
import org.datanucleus.store.rdbms.identifier.ColumnIdentifier;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.schema.naming.NamingCase;

public class DNIdentifierFactory
extends AbstractIdentifierFactory {
    protected String tablePrefix = null;
    protected String tableSuffix = null;

    public DNIdentifierFactory(DatastoreAdapter dba, ClassLoaderResolver clr, Map props) {
        super(dba, clr, props);
        if (props.containsKey("WordSeparator")) {
            this.wordSeparator = (String)props.get("WordSeparator");
        }
        this.tablePrefix = (String)props.get("TablePrefix");
        this.tableSuffix = (String)props.get("TableSuffix");
    }

    @Override
    public DatastoreIdentifier newTableIdentifier(AbstractMemberMetaData fmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        AbstractMemberMetaData[] relatedMmds = null;
        if (fmd.getColumnMetaData().length > 0 && fmd.getColumnMetaData()[0].getName() != null) {
            identifierName = fmd.getColumnMetaData()[0].getName();
        } else if (fmd.hasContainer()) {
            String[] parts;
            String specifiedName;
            if (fmd.getTable() != null) {
                specifiedName = fmd.getTable();
                parts = this.getIdentifierNamePartsFromName(specifiedName);
                if (parts != null) {
                    catalogName = parts[0];
                    schemaName = parts[1];
                    identifierName = parts[2];
                }
                if (catalogName == null) {
                    catalogName = fmd.getCatalog();
                }
                if (schemaName == null) {
                    schemaName = fmd.getSchema();
                }
            } else {
                relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                if (relatedMmds != null && relatedMmds[0].getTable() != null) {
                    specifiedName = relatedMmds[0].getTable();
                    parts = this.getIdentifierNamePartsFromName(specifiedName);
                    if (parts != null) {
                        catalogName = parts[0];
                        schemaName = parts[1];
                        identifierName = parts[2];
                    }
                    if (catalogName == null) {
                        catalogName = fmd.getCatalog();
                    }
                    if (schemaName == null) {
                        schemaName = fmd.getSchema();
                    }
                }
            }
        }
        if (schemaName == null && catalogName == null) {
            if (fmd.getParent() instanceof AbstractClassMetaData) {
                AbstractClassMetaData ownerCmd = (AbstractClassMetaData)fmd.getParent();
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = ownerCmd.getCatalog();
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = ownerCmd.getSchema();
                }
            }
            if (schemaName == null && catalogName == null) {
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String fieldNameBasis = fmd.getFullFieldName();
            if (relatedMmds != null && relatedMmds[0].getMappedBy() != null) {
                fieldNameBasis = relatedMmds[0].getFullFieldName();
            }
            ArrayList<String> name_parts = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(fieldNameBasis, ".");
            while (tokens.hasMoreTokens()) {
                name_parts.add(tokens.nextToken());
            }
            ListIterator li = name_parts.listIterator(name_parts.size());
            String unique_name = (String)li.previous();
            String full_name = (li.hasPrevious() ? li.previous() + this.getWordSeparator() : "") + unique_name;
            identifierName = "";
            if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
                identifierName = this.tablePrefix;
            }
            identifierName = identifierName + full_name;
            if (this.tableSuffix != null && this.tableSuffix.length() > 0) {
                identifierName = identifierName + this.tableSuffix;
            }
        }
        DatastoreIdentifier identifier = this.newTableIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newTableIdentifier(AbstractClassMetaData cmd) {
        String identifierName = null;
        String schemaName = null;
        String catalogName = null;
        String specifiedName = cmd.getTable();
        String[] parts = this.getIdentifierNamePartsFromName(specifiedName);
        if (parts != null) {
            catalogName = parts[0];
            schemaName = parts[1];
            identifierName = parts[2];
        }
        if (schemaName == null && catalogName == null) {
            if (this.dba.supportsOption("CatalogInTableDefinition")) {
                catalogName = cmd.getCatalog();
            }
            if (this.dba.supportsOption("SchemaInTableDefinition")) {
                schemaName = cmd.getSchema();
            }
            if (schemaName == null && catalogName == null) {
                if (this.dba.supportsOption("CatalogInTableDefinition")) {
                    catalogName = this.defaultCatalogName;
                }
                if (this.dba.supportsOption("SchemaInTableDefinition")) {
                    schemaName = this.defaultSchemaName;
                }
            }
        }
        if (identifierName == null) {
            String unique_name = cmd.getFullClassName().substring(cmd.getFullClassName().lastIndexOf(46) + 1);
            identifierName = "";
            if (this.tablePrefix != null && this.tablePrefix.length() > 0) {
                identifierName = this.tablePrefix;
            }
            identifierName = identifierName + unique_name;
            if (this.tableSuffix != null && this.tableSuffix.length() > 0) {
                identifierName = identifierName + this.tableSuffix;
            }
        }
        DatastoreIdentifier identifier = this.newTableIdentifier(identifierName);
        if (schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if (catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newReferenceFieldIdentifier(AbstractMemberMetaData refMetaData, AbstractClassMetaData implMetaData, DatastoreIdentifier implIdentifier, boolean embedded, FieldRole fieldRole) {
        DatastoreIdentifier identifier = null;
        String key = "[" + refMetaData.getFullFieldName() + "][" + implMetaData.getFullClassName() + "][" + implIdentifier.getIdentifierName() + "]";
        identifier = (DatastoreIdentifier)this.references.get(key);
        if (identifier == null) {
            String referenceName = refMetaData.getName();
            String implementationName = implMetaData.getFullClassName();
            int dot = implementationName.lastIndexOf(46);
            if (dot > -1) {
                implementationName = implementationName.substring(dot + 1);
            }
            String name = referenceName + "." + implementationName + "." + implIdentifier.getIdentifierName();
            String suffix = this.getColumnIdentifierSuffix(fieldRole, embedded);
            String datastoreID = this.generateIdentifierNameForJavaName(name);
            String baseID = this.truncate(datastoreID, this.dba.getDatastoreIdentifierMaxLength(IdentifierType.COLUMN) - suffix.length());
            identifier = new ColumnIdentifier(this, baseID + suffix);
            this.references.put(key, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newJoinTableFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, FieldRole fieldRole) {
        if (destinationId != null) {
            RelationType relType = ownerFmd.getRelationType(this.clr);
            if (relType == RelationType.MANY_TO_MANY_BI && ownerFmd.hasCollection() && ownerFmd.getMappedBy() != null) {
                if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT) {
                    fieldRole = FieldRole.ROLE_OWNER;
                } else if (fieldRole == FieldRole.ROLE_OWNER) {
                    fieldRole = FieldRole.ROLE_COLLECTION_ELEMENT;
                }
            }
            return this.newColumnIdentifier(destinationId.getIdentifierName(), embedded, fieldRole, false);
        }
        String baseName = null;
        if (fieldRole == FieldRole.ROLE_COLLECTION_ELEMENT) {
            String elementType = ownerFmd.getCollection().getElementType();
            baseName = elementType.substring(elementType.lastIndexOf(46) + 1);
        } else if (fieldRole == FieldRole.ROLE_ARRAY_ELEMENT) {
            String elementType = ownerFmd.getArray().getElementType();
            baseName = elementType.substring(elementType.lastIndexOf(46) + 1);
        } else if (fieldRole == FieldRole.ROLE_MAP_KEY) {
            String keyType = ownerFmd.getMap().getKeyType();
            baseName = keyType.substring(keyType.lastIndexOf(46) + 1);
        } else if (fieldRole == FieldRole.ROLE_MAP_VALUE) {
            String valueType = ownerFmd.getMap().getValueType();
            baseName = valueType.substring(valueType.lastIndexOf(46) + 1);
        } else {
            baseName = "UNKNOWN";
        }
        return this.newColumnIdentifier(baseName, embedded, fieldRole, false);
    }

    @Override
    public DatastoreIdentifier newForeignKeyFieldIdentifier(AbstractMemberMetaData ownerFmd, AbstractMemberMetaData relatedFmd, DatastoreIdentifier destinationId, boolean embedded, FieldRole fieldRole) {
        if (relatedFmd != null) {
            if (fieldRole == FieldRole.ROLE_OWNER) {
                return this.newColumnIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole, false);
            }
            if (fieldRole == FieldRole.ROLE_INDEX) {
                return this.newColumnIdentifier(relatedFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole, false);
            }
            throw new NucleusException("Column role " + fieldRole + " not supported by this method").setFatal();
        }
        if (fieldRole == FieldRole.ROLE_OWNER) {
            return this.newColumnIdentifier(ownerFmd.getName() + "." + destinationId.getIdentifierName(), embedded, fieldRole, false);
        }
        if (fieldRole == FieldRole.ROLE_INDEX) {
            return this.newColumnIdentifier(ownerFmd.getName() + "." + "INTEGER", embedded, fieldRole, false);
        }
        throw new NucleusException("Column role " + fieldRole + " not supported by this method").setFatal();
    }

    @Override
    public DatastoreIdentifier newDiscriminatorFieldIdentifier() {
        String name = "DISCRIMINATOR";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newVersionFieldIdentifier() {
        String name = "OPT_VERSION";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newAdapterIndexFieldIdentifier() {
        String name = "ADPT_PK_IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public DatastoreIdentifier newIndexFieldIdentifier(AbstractMemberMetaData mmd) {
        String name = "INTEGER_IDX";
        DatastoreIdentifier identifier = (DatastoreIdentifier)this.columns.get(name);
        if (identifier == null) {
            identifier = new ColumnIdentifier(this, name);
            this.columns.put(name, identifier);
        }
        return identifier;
    }

    @Override
    public String generateIdentifierNameForJavaName(String javaName) {
        if (javaName == null) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        int prev = 0;
        for (int i = 0; i < javaName.length(); ++i) {
            char c = javaName.charAt(i);
            if (c >= 'A' && c <= 'Z' && this.namingCase != NamingCase.MIXED_CASE && this.namingCase != NamingCase.MIXED_CASE_QUOTED) {
                if (prev >= 97 && prev <= 122) {
                    s.append(this.wordSeparator);
                }
                s.append(c);
            } else if (c >= 'A' && c <= 'Z' && (this.namingCase == NamingCase.MIXED_CASE || this.namingCase == NamingCase.MIXED_CASE_QUOTED)) {
                s.append(c);
            } else if (c >= 'a' && c <= 'z' && (this.namingCase == NamingCase.MIXED_CASE || this.namingCase == NamingCase.MIXED_CASE_QUOTED)) {
                s.append(c);
            } else if (c >= 'a' && c <= 'z' && this.namingCase != NamingCase.MIXED_CASE && this.namingCase != NamingCase.MIXED_CASE_QUOTED) {
                s.append((char)(c - 32));
            } else if (c >= '0' && c <= '9' || c == '_') {
                s.append(c);
            } else if (c == '.') {
                s.append(this.wordSeparator);
            } else {
                String cval = "000" + Integer.toHexString(c);
                s.append(cval.substring(cval.length() - (c > '\u00ff' ? 4 : 2)));
            }
            prev = c;
        }
        while (s.length() > 0 && s.charAt(0) == '_') {
            s.deleteCharAt(0);
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("Illegal Java identifier: " + javaName);
        }
        return s.toString();
    }

    @Override
    protected String getColumnIdentifierSuffix(FieldRole role, boolean embedded) {
        String suffix = role == FieldRole.ROLE_OWNER ? (!embedded ? "_OID" : "_OWN") : (role == FieldRole.ROLE_FIELD || role == FieldRole.ROLE_COLLECTION_ELEMENT || role == FieldRole.ROLE_ARRAY_ELEMENT ? (!embedded ? "_EID" : "_ELE") : (role == FieldRole.ROLE_MAP_KEY ? (!embedded ? "_KID" : "_KEY") : (role == FieldRole.ROLE_MAP_VALUE ? (!embedded ? "_VID" : "_VAL") : (role == FieldRole.ROLE_INDEX ? (!embedded ? "_XID" : "_IDX") : (!embedded ? "_ID" : "")))));
        return suffix;
    }
}

