/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ExecutionContext;
import org.datanucleus.FetchPlanForClass;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.CandidateIdsQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.QueryTimeoutException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.AbstractContainerMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.BulkFetchHelper;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.QueryToSQLMapper;
import org.datanucleus.store.rdbms.query.RDBMSQueryCompilation;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query.StatementNewObjectMapping;
import org.datanucleus.store.rdbms.query.StatementResultMapping;
import org.datanucleus.store.rdbms.scostore.IteratorStatement;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    public static final String EXTENSION_MULTIVALUED_FETCH = "datanucleus.multivaluedFetch";
    protected transient RDBMSQueryCompilation datastoreCompilation = null;
    boolean statementReturnsEmpty = false;

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            Boolean bool = Boolean.valueOf((String)val);
            return bool == null || bool != false;
        }
        return super.evaluateInMemory();
    }

    protected String getQueryCacheKey() {
        if (this.getSerializeRead() != null && this.getSerializeRead().booleanValue()) {
            return super.getQueryCacheKey() + " FOR UPDATE";
        }
        return super.getQueryCacheKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        if (this.candidateClass == null) {
            throw new NucleusUserException(LOCALISER.msg("021009", (Object)this.candidateClassName));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        if (parameterValues != null) {
            Set paramNames = parameterValues.entrySet();
            for (Map.Entry entry : paramNames) {
                Object paramName = entry.getKey();
                if (!(paramName instanceof String)) continue;
                Symbol sym = this.compilation.getSymbolTable().getSymbol((String)paramName);
                Object value = entry.getValue();
                if (value != null || sym == null || sym.getValueType() == null || !sym.getValueType().isPrimitive()) continue;
                throw new NucleusUserException(LOCALISER.msg("021117", paramName, (Object)sym.getValueType().getName()));
            }
        }
        QueryManager qm = this.getQueryManager();
        String datastoreKey = storeMgr.getQueryCacheKey();
        String queryCacheKey = this.getQueryCacheKey();
        if (this.useCaching() && queryCacheKey != null) {
            boolean nullParameter = false;
            if (parameterValues != null) {
                for (Object val : parameterValues.values()) {
                    if (val != null) continue;
                    nullParameter = true;
                    break;
                }
            }
            if (!nullParameter) {
                this.datastoreCompilation = (RDBMSQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), queryCacheKey);
                if (this.datastoreCompilation != null) {
                    this.setResultDistinct(this.compilation.getResultDistinct());
                    return;
                }
            }
        }
        AbstractClassMetaData acmd = this.getCandidateClassMetaData();
        if (this.type == 1) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryUpdate(parameterValues, acmd);
        } else if (this.type == 2) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryDelete(parameterValues, acmd);
        } else {
            RDBMSQueryCompilation rDBMSQueryCompilation = this.datastoreCompilation = new RDBMSQueryCompilation();
            synchronized (rDBMSQueryCompilation) {
                if (inMemory) {
                    this.compileQueryToRetrieveCandidates(parameterValues, acmd);
                } else {
                    this.compileQueryFull(parameterValues, acmd);
                    if (this.result != null) {
                        StatementResultMapping resultMapping = this.datastoreCompilation.getResultDefinition();
                        for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                            StatementMappingIndex idx;
                            AbstractMemberMetaData mmd;
                            Object stmtMap = resultMapping.getMappingForResultExpression(i);
                            if (!(stmtMap instanceof StatementMappingIndex) || (mmd = (idx = (StatementMappingIndex)stmtMap).getMapping().getMemberMetaData()) == null || !mmd.hasCollection() && !mmd.hasMap() && !mmd.hasArray() || !(idx.getMapping() instanceof AbstractContainerMapping)) continue;
                            throw new NucleusUserException(LOCALISER.msg("021213"));
                        }
                        if (this.resultClass != null) {
                            AccessController.doPrivileged(new PrivilegedAction(){

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public Object run() {
                                    StatementResultMapping resultMapping = JDOQLQuery.this.datastoreCompilation.getResultDefinition();
                                    if (QueryUtils.resultClassIsSimple((String)JDOQLQuery.this.resultClass.getName())) {
                                        Class resultClassPrimitive;
                                        if (resultMapping.getNumberOfResultExpressions() > 1) {
                                            throw new NucleusUserException(LOCALISER.msg("021201", (Object)JDOQLQuery.this.resultClass.getName()));
                                        }
                                        Object stmtMap = resultMapping.getMappingForResultExpression(0);
                                        if (!(stmtMap instanceof StatementMappingIndex)) throw new NucleusUserException("Don't support result clause of " + JDOQLQuery.this.result + " with resultClass of " + JDOQLQuery.this.resultClass.getName());
                                        StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                                        Class exprType = idx.getMapping().getJavaType();
                                        boolean typeConsistent = false;
                                        if (exprType == JDOQLQuery.this.resultClass) {
                                            return null;
                                        }
                                        if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType((Class)JDOQLQuery.this.resultClass)) == exprType) {
                                            return null;
                                        }
                                        if (typeConsistent) return null;
                                        throw new NucleusUserException(LOCALISER.msg("021202", (Object)JDOQLQuery.this.resultClass.getName(), (Object)exprType));
                                    }
                                    if (!QueryUtils.resultClassIsUserType((String)JDOQLQuery.this.resultClass.getName())) return null;
                                    Class[] ctrTypes = new Class[resultMapping.getNumberOfResultExpressions()];
                                    for (int i = 0; i < ctrTypes.length; ++i) {
                                        Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                        if (stmtMap instanceof StatementMappingIndex) {
                                            ctrTypes[i] = ((StatementMappingIndex)stmtMap).getMapping().getJavaType();
                                            continue;
                                        }
                                        if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                                    }
                                    Constructor ctr = ClassUtils.getConstructorWithArguments((Class)JDOQLQuery.this.resultClass, (Class[])ctrTypes);
                                    if (ctr == null && !ClassUtils.hasDefaultConstructor((Class)JDOQLQuery.this.resultClass)) {
                                        throw new NucleusUserException(LOCALISER.msg("021205", (Object)JDOQLQuery.this.resultClass.getName()));
                                    }
                                    if (ctr != null) return null;
                                    int i = 0;
                                    while (i < resultMapping.getNumberOfResultExpressions()) {
                                        Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                        if (stmtMap instanceof StatementMappingIndex) {
                                            StatementMappingIndex mapIdx = (StatementMappingIndex)stmtMap;
                                            AbstractMemberMetaData mmd = mapIdx.getMapping().getMemberMetaData();
                                            String fieldName = mapIdx.getColumnAlias();
                                            Class fieldType = mapIdx.getMapping().getJavaType();
                                            if (fieldName == null && mmd != null) {
                                                fieldName = mmd.getName();
                                            }
                                            if (fieldName != null) {
                                                Method putMethod;
                                                Method setMethod;
                                                Class<?> resultFieldType = null;
                                                boolean publicField = true;
                                                try {
                                                    Field fld = JDOQLQuery.this.resultClass.getDeclaredField(fieldName);
                                                    resultFieldType = fld.getType();
                                                    if (!ClassUtils.typesAreCompatible((Class)fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, (Class)fieldType)) {
                                                        throw new NucleusUserException(LOCALISER.msg("021211", (Object)fieldName, (Object)fieldType.getName(), (Object)resultFieldType.getName()));
                                                    }
                                                    if (!Modifier.isPublic(fld.getModifiers())) {
                                                        publicField = false;
                                                    }
                                                }
                                                catch (NoSuchFieldException nsfe) {
                                                    publicField = false;
                                                }
                                                if (!publicField && (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass((Class)JDOQLQuery.this.resultClass, (String)fieldName, resultFieldType)) == null && (putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)JDOQLQuery.this.resultClass)) == null) {
                                                    throw new NucleusUserException(LOCALISER.msg("021212", (Object)JDOQLQuery.this.resultClass.getName(), (Object)fieldName));
                                                }
                                            }
                                        } else if (stmtMap instanceof StatementNewObjectMapping) {
                                            // empty if block
                                        }
                                        ++i;
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021085", (Object)this, (Object)this.datastoreCompilation.getSQL()));
                }
                boolean hasParams = false;
                if (this.explicitParameters != null) {
                    hasParams = true;
                } else if (parameterValues != null && parameterValues.size() > 0) {
                    hasParams = true;
                }
                if (!this.statementReturnsEmpty && queryCacheKey != null) {
                    if (!this.datastoreCompilation.isPrecompilable() || this.datastoreCompilation.getSQL().indexOf(63) < 0 && hasParams) {
                        NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021075"));
                    } else {
                        qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), queryCacheKey, (Object)this.datastoreCompilation);
                    }
                }
            }
        }
    }

    public String getSQL() {
        if (this.datastoreCompilation != null) {
            return this.datastoreCompilation.getSQL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        List cachedResults;
        if (this.statementReturnsEmpty) {
            return Collections.EMPTY_LIST;
        }
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null) {
            if (this.candidateCollection.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            if (inMemory) {
                ArrayList candidates = new ArrayList(this.candidateCollection);
                JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.clr);
                return resultMapper.execute(true, true, true, true, true);
            }
        } else if (this.type == 0 && (cachedResults = this.getQueryManager().getDatastoreQueryResult((Query)this, parameters)) != null) {
            return new CandidateIdsQueryResult((Query)this, cachedResults);
        }
        Object results = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        ManagedConnection mconn = storeMgr.getConnection(this.ec);
        try {
            long startTime;
            block40: {
                startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)this.getLanguage(), (Object)this.getSingleStringQuery(), null));
                }
                AbstractClassMetaData acmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
                SQLController sqlControl = storeMgr.getSQLController();
                PreparedStatement ps = null;
                try {
                    if (this.type == 0) {
                        ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.datastoreCompilation.getSQL(), (Query)this);
                        SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), this.datastoreCompilation.getParameterNameByPosition(), parameters);
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, true);
                        this.registerTask(ps);
                        ResultSet rs = null;
                        try {
                            rs = sqlControl.executeStatementQuery(this.ec, mconn, this.toString(), ps);
                        }
                        finally {
                            this.deregisterTask();
                        }
                        AbstractRDBMSQueryResult qr = null;
                        try {
                            if (inMemory) {
                                ResultObjectFactory rof = storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ignoreCache, this.getFetchPlan(), this.candidateClass);
                                ArrayList<Object> candidates = new ArrayList<Object>();
                                while (rs.next()) {
                                    candidates.add(rof.getObject(this.ec, rs));
                                }
                                JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, this.clr);
                                results = resultMapper.execute(true, true, true, true, true);
                            } else {
                                ResultObjectFactory rof = null;
                                rof = this.result != null ? new ResultClassROF(storeMgr, this.resultClass, this.datastoreCompilation.getResultDefinition()) : (this.resultClass != null && this.resultClass != this.candidateClass ? new ResultClassROF(storeMgr, this.resultClass, this.datastoreCompilation.getResultDefinitionForClass()) : storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ignoreCache, this.getFetchPlan(), this.candidateClass));
                                String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                                qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection);
                                Map<String, IteratorStatement> scoIterStmts = this.datastoreCompilation.getSCOIteratorStatements();
                                if (scoIterStmts != null) {
                                    for (Map.Entry<String, IteratorStatement> stmtIterEntry : scoIterStmts.entrySet()) {
                                        IteratorStatement iterStmt = stmtIterEntry.getValue();
                                        String iterStmtSQL = iterStmt.getSQLStatement().getSelectStatement().toSQL();
                                        NucleusLogger.DATASTORE_RETRIEVE.debug((Object)(">> JDOQL Bulk-Fetch of " + iterStmt.getBackingStore().getOwnerMemberMetaData().getFullFieldName()));
                                        try {
                                            PreparedStatement psSco = sqlControl.getStatementForQuery(mconn, iterStmtSQL);
                                            if (this.datastoreCompilation.getStatementParameters() != null) {
                                                BulkFetchHelper helper = new BulkFetchHelper((Query)this);
                                                helper.applyParametersToStatement(psSco, this.datastoreCompilation, iterStmt.getSQLStatement(), parameters);
                                            }
                                            ResultSet rsSCO = sqlControl.executeStatementQuery(this.ec, mconn, iterStmtSQL, psSco);
                                            qr.registerMemberBulkResultSet(iterStmt, rsSCO);
                                        }
                                        catch (SQLException e) {
                                            throw new NucleusDataStoreException(LOCALISER.msg("056006", (Object)iterStmtSQL), (Throwable)e);
                                        }
                                    }
                                }
                                qr.initialise();
                                AbstractRDBMSQueryResult qr1 = qr;
                                ManagedConnection mconn1 = mconn;
                                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                    final /* synthetic */ QueryResult val$qr1;
                                    final /* synthetic */ ManagedConnection val$mconn1;
                                    {
                                        this.val$qr1 = queryResult;
                                        this.val$mconn1 = managedConnection;
                                    }

                                    public void transactionFlushed() {
                                    }

                                    public void transactionPreClose() {
                                        this.val$qr1.disconnect();
                                    }

                                    public void managedConnectionPreClose() {
                                        if (!JDOQLQuery.this.ec.getTransaction().isActive()) {
                                            this.val$qr1.disconnect();
                                        }
                                    }

                                    public void managedConnectionPostClose() {
                                    }

                                    public void resourcePostClose() {
                                        this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                    }
                                };
                                mconn.addListener(listener);
                                qr.addConnectionListener(listener);
                                results = qr;
                            }
                            break block40;
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    if (this.type == 1) {
                        ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                        SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), this.datastoreCompilation.getParameterNameByPosition(), parameters);
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                        int[] updateResults = sqlControl.executeStatementUpdate(this.ec, mconn, this.toString(), ps, true);
                        try {
                            this.ec.getNucleusContext().getLevel2Cache().evictAll(this.candidateClass, this.subclasses);
                        }
                        catch (UnsupportedOperationException uoe) {
                            // empty catch block
                        }
                        results = (long)updateResults[0];
                        break block40;
                    }
                    if (this.type != 1 && this.type != 2) break block40;
                    long bulkResult = 0L;
                    if (this.datastoreCompilation.getSQL() != null) {
                        ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                        SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), this.datastoreCompilation.getParameterNameByPosition(), parameters);
                        RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                        int[] execResults = sqlControl.executeStatementUpdate(this.ec, mconn, this.toString(), ps, true);
                        bulkResult = execResults[0];
                    } else {
                        List<String> sqls = this.datastoreCompilation.getSQLs();
                        List<Boolean> sqlUseInCountFlags = this.datastoreCompilation.getSQLUseInCountFlags();
                        Iterator<Boolean> sqlUseInCountIter = sqlUseInCountFlags.iterator();
                        for (String sql : sqls) {
                            Boolean useInCount = sqlUseInCountIter.next();
                            ps = sqlControl.getStatementForUpdate(mconn, sql, false);
                            SQLStatementHelper.applyParametersToStatement(ps, this.ec, this.datastoreCompilation.getStatementParameters(), this.datastoreCompilation.getParameterNameByPosition(), parameters);
                            RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                            int[] execResults = sqlControl.executeStatementUpdate(this.ec, mconn, this.toString(), ps, true);
                            if (!useInCount.booleanValue()) continue;
                            bulkResult += (long)execResults[0];
                        }
                    }
                    try {
                        this.ec.getNucleusContext().getLevel2Cache().evictAll(this.candidateClass, this.subclasses);
                    }
                    catch (UnsupportedOperationException uoe) {
                        // empty catch block
                    }
                    results = bulkResult;
                }
                catch (SQLException sqle) {
                    if (storeMgr.getDatastoreAdapter().isStatementCancel(sqle)) {
                        throw new QueryInterruptedException("Query has been interrupted", (Throwable)sqle);
                    }
                    if (storeMgr.getDatastoreAdapter().isStatementTimeout(sqle)) {
                        throw new QueryTimeoutException("Query has been timed out", (Throwable)sqle);
                    }
                    throw new NucleusException(LOCALISER.msg("021042", (Object)this.datastoreCompilation.getSQL()), (Throwable)sqle);
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Long l = results;
            return l;
        }
        finally {
            mconn.release();
        }
    }

    protected void assertSupportsCancel() {
    }

    protected boolean cancelTaskObject(Object obj) {
        Statement ps = (Statement)obj;
        try {
            ps.cancel();
            return true;
        }
        catch (SQLException sqle) {
            NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Error cancelling query", (Throwable)sqle);
            return false;
        }
    }

    protected boolean supportsTimeout() {
        return true;
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        if (this.result != null) {
            this.datastoreCompilation.setResultDefinition(new StatementResultMapping());
        } else {
            this.datastoreCompilation.setResultDefinitionForClass(new StatementClassMapping());
        }
        SQLStatement stmt = null;
        try {
            stmt = RDBMSQueryUtils.getStatementForCandidates((RDBMSStoreManager)this.getStoreManager(), null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ec, this.candidateClass, this.subclasses, this.result, null, null);
        }
        catch (NucleusException ne) {
            NucleusLogger.QUERY.warn((Object)("Query for candidates of " + this.candidateClass.getName() + (this.subclasses ? " and subclasses" : "") + " resulted in no possible candidates"), (Throwable)ne);
            this.statementReturnsEmpty = true;
            return;
        }
        HashSet<String> options = new HashSet<String>();
        options.add("BULK_UPDATE_VERSION");
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameters, this.datastoreCompilation.getResultDefinitionForClass(), this.datastoreCompilation.getResultDefinition(), candidateCmd, this.getFetchPlan(), this.ec, this.getParsedImports(), options, this.extensions);
        sqlMapper.compile();
        this.datastoreCompilation.setParameterNameByPosition(sqlMapper.getParameterNameByPosition());
        this.datastoreCompilation.setPrecompilable(sqlMapper.isPrecompilable());
        if (!this.getResultDistinct() && stmt.isDistinct()) {
            this.setResultDistinct(true);
            this.compilation.setResultDistinct();
        }
        if (this.candidateCollection != null) {
            BooleanExpression candidateExpr = null;
            Iterator iter = this.candidateCollection.iterator();
            JavaTypeMapping idMapping = stmt.getPrimaryTable().getTable().getIdMapping();
            while (iter.hasNext()) {
                Object candidate = iter.next();
                SQLExpression idExpr = stmt.getSQLExpressionFactory().newExpression(stmt, stmt.getPrimaryTable(), idMapping);
                SQLExpression idVal = stmt.getSQLExpressionFactory().newLiteral(stmt, idMapping, candidate);
                if (candidateExpr == null) {
                    candidateExpr = idExpr.eq(idVal);
                    continue;
                }
                candidateExpr = candidateExpr.ior(idExpr.eq(idVal));
            }
            stmt.whereAnd(candidateExpr, true);
        }
        if (this.range != null) {
            long lower = this.fromInclNo;
            long upper = this.toExclNo;
            if (this.fromInclParam != null) {
                if (parameters.containsKey(this.fromInclParam)) {
                    lower = ((Number)parameters.get(this.fromInclParam)).longValue();
                } else {
                    int pos = parameters.size() - 2;
                    lower = ((Number)parameters.get(pos)).longValue();
                }
            }
            if (this.toExclParam != null) {
                if (parameters.containsKey(this.toExclParam)) {
                    upper = ((Number)parameters.get(this.toExclParam)).longValue();
                } else {
                    int pos = parameters.size() - 1;
                    upper = ((Number)parameters.get(pos)).longValue();
                }
            }
            stmt.setRange(lower, upper - lower);
        }
        boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
        stmt.addExtension("lock-for-update", useUpdateLock);
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
        if (this.result == null && (this.resultClass == null || this.resultClass == this.candidateClass)) {
            FetchPlanForClass fpc = this.getFetchPlan().getFetchPlanForClass(candidateCmd);
            int[] fpMembers = fpc.getMemberNumbers();
            for (int i = 0; i < fpMembers.length; ++i) {
                AbstractMemberMetaData fpMmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(fpMembers[i]);
                RelationType fpRelType = fpMmd.getRelationType(this.clr);
                if (!RelationType.isRelationMultiValued((RelationType)fpRelType)) continue;
                String multifetchType = this.getStringExtensionProperty(EXTENSION_MULTIVALUED_FETCH, null);
                if (multifetchType == null) {
                    NucleusLogger.QUERY.debug((Object)("You have selected field " + fpMmd.getFullFieldName() + " for fetching by this query. We will fetch it using bulk-fetch." + " To disable this set the query extension/hint '" + EXTENSION_MULTIVALUED_FETCH + "' as 'none' or remove the field from the query FetchPlan." + " If this bulk-fetch generates an invalid or unoptimised query, please report it with a way of reproducing it"));
                    multifetchType = "bulk-fetch";
                }
                if (multifetchType.equalsIgnoreCase("bulk-fetch")) {
                    if (fpMmd.hasCollection()) {
                        if (multifetchType != null && multifetchType.equalsIgnoreCase("none")) {
                            NucleusLogger.GENERAL.debug((Object)("Note that query has field " + fpMmd.getFullFieldName() + " marked in the FetchPlan, yet this is not fetched by this query"));
                            continue;
                        }
                        if (SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)fpMmd)) continue;
                        BulkFetchHelper helper = new BulkFetchHelper((Query)this);
                        IteratorStatement iterStmt = helper.getSQLStatementForContainerField(candidateCmd, parameters, fpMmd, this.datastoreCompilation);
                        if (iterStmt != null) {
                            this.datastoreCompilation.setSCOIteratorStatement(fpMmd.getFullFieldName(), iterStmt);
                            continue;
                        }
                        NucleusLogger.GENERAL.debug((Object)("Note that query has field " + fpMmd.getFullFieldName() + " marked in the FetchPlan, yet this is currently not fetched by this query"));
                        continue;
                    }
                    if (fpMmd.hasMap()) {
                        NucleusLogger.GENERAL.debug((Object)("Note that query has field " + fpMmd.getFullFieldName() + " marked in the FetchPlan, yet this is currently not fetched by this query (bulk-fetch not supported for maps yet)"));
                        continue;
                    }
                    NucleusLogger.GENERAL.debug((Object)("Note that query has field " + fpMmd.getFullFieldName() + " marked in the FetchPlan, yet this is currently not fetched by this query (bulk-fetch not supported for arrays yet)"));
                    continue;
                }
                NucleusLogger.GENERAL.debug((Object)("Note that query has field " + fpMmd.getFullFieldName() + " marked in the FetchPlan, yet this is not fetched by this query."));
            }
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }

    private void compileQueryToRetrieveCandidates(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        this.datastoreCompilation.setResultDefinitionForClass(resultsDef);
        SQLStatement stmt = null;
        try {
            stmt = RDBMSQueryUtils.getStatementForCandidates((RDBMSStoreManager)this.getStoreManager(), null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.ec, this.candidateClass, this.subclasses, this.result, null, null);
        }
        catch (NucleusException ne) {
            NucleusLogger.QUERY.warn((Object)("Query for candidates of " + this.candidateClass.getName() + (this.subclasses ? " and subclasses" : "") + " resulted in no possible candidates"), (Throwable)ne);
            this.statementReturnsEmpty = true;
            return;
        }
        if (stmt.allUnionsForSamePrimaryTable()) {
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd, this.getFetchPlan(), 1);
        } else {
            SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd);
        }
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    protected void compileQueryUpdate(Map parameterValues, AbstractClassMetaData candidateCmd) {
        Collection subclassNames;
        Expression[] updateExprs = this.compilation.getExprUpdate();
        if (updateExprs == null || updateExprs.length == 0) {
            return;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        DatastoreClass candidateTbl = storeMgr.getDatastoreClass(candidateCmd.getFullClassName(), this.clr);
        if (candidateTbl == null) {
            throw new NucleusDataStoreException("Bulk update of " + candidateCmd.getFullClassName() + " not supported since candidate has no table of its own");
        }
        InheritanceStrategy inhStr = candidateCmd.getBaseAbstractClassMetaData().getInheritanceMetaData().getStrategy();
        ArrayList<BulkTable> tables = new ArrayList<BulkTable>();
        tables.add(new BulkTable(candidateTbl, true));
        if (inhStr != InheritanceStrategy.COMPLETE_TABLE) {
            while (candidateTbl.getSuperDatastoreClass() != null) {
                candidateTbl = candidateTbl.getSuperDatastoreClass();
                tables.add(new BulkTable(candidateTbl, false));
            }
        }
        if ((subclassNames = storeMgr.getSubClassesForClass(candidateCmd.getFullClassName(), true, this.clr)) != null && !subclassNames.isEmpty()) {
            for (String subclassName : subclassNames) {
                DatastoreClass subclassTbl = storeMgr.getDatastoreClass(subclassName, this.clr);
                if (candidateTbl == subclassTbl) continue;
                tables.add(0, new BulkTable(subclassTbl, inhStr == InheritanceStrategy.COMPLETE_TABLE));
            }
        }
        ArrayList<String> sqls = new ArrayList<String>();
        ArrayList<Boolean> sqlCountFlags = new ArrayList<Boolean>();
        for (BulkTable bulkTable : tables) {
            DatastoreClass table = bulkTable.table;
            SQLStatement stmt = new SQLStatement(storeMgr, table, null, null);
            stmt.setClassLoaderResolver(this.clr);
            stmt.setCandidateClassName(candidateCmd.getFullClassName());
            if (table.getMultitenancyMapping() != null) {
                JavaTypeMapping tenantMapping = table.getMultitenancyMapping();
                SQLTable tenantSqlTbl = stmt.getPrimaryTable();
                SQLExpression tenantExpr = stmt.getSQLExpressionFactory().newExpression(stmt, tenantSqlTbl, tenantMapping);
                SQLExpression tenantVal = stmt.getSQLExpressionFactory().newLiteral(stmt, tenantMapping, storeMgr.getStringProperty("datanucleus.TenantID"));
                stmt.whereAnd(tenantExpr.eq(tenantVal), true);
            }
            HashSet<String> options = new HashSet<String>();
            options.add("CASE_INSENSITIVE");
            options.add("EXPLICIT_JOINS");
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, null, null, candidateCmd, this.getFetchPlan(), this.ec, null, options, this.extensions);
            sqlMapper.setDefaultJoinType(SQLJoin.JoinType.INNER_JOIN);
            sqlMapper.compile();
            if (!stmt.hasUpdates()) continue;
            sqls.add(stmt.getUpdateStatement().toString());
            sqlCountFlags.add(bulkTable.useInCount);
            this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
        }
        if (sqls.size() == 1) {
            this.datastoreCompilation.setSQL((String)sqls.get(0));
        } else {
            this.datastoreCompilation.setSQL(sqls, sqlCountFlags);
        }
    }

    protected void compileQueryDelete(Map parameterValues, AbstractClassMetaData candidateCmd) {
        Collection subclassNames;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        DatastoreClass candidateTbl = storeMgr.getDatastoreClass(candidateCmd.getFullClassName(), this.clr);
        if (candidateTbl == null) {
            throw new NucleusDataStoreException("Bulk delete of " + candidateCmd.getFullClassName() + " not supported since candidate has no table of its own");
        }
        InheritanceStrategy inhStr = candidateCmd.getBaseAbstractClassMetaData().getInheritanceMetaData().getStrategy();
        ArrayList<BulkTable> tables = new ArrayList<BulkTable>();
        tables.add(new BulkTable(candidateTbl, true));
        if (inhStr != InheritanceStrategy.COMPLETE_TABLE) {
            while (candidateTbl.getSuperDatastoreClass() != null) {
                candidateTbl = candidateTbl.getSuperDatastoreClass();
                tables.add(new BulkTable(candidateTbl, false));
            }
        }
        if ((subclassNames = storeMgr.getSubClassesForClass(candidateCmd.getFullClassName(), true, this.clr)) != null && !subclassNames.isEmpty()) {
            for (String subclassName : subclassNames) {
                DatastoreClass subclassTbl = storeMgr.getDatastoreClass(subclassName, this.clr);
                if (candidateTbl == subclassTbl) continue;
                tables.add(0, new BulkTable(subclassTbl, inhStr == InheritanceStrategy.COMPLETE_TABLE));
            }
        }
        ArrayList<String> sqls = new ArrayList<String>();
        ArrayList<Boolean> sqlCountFlags = new ArrayList<Boolean>();
        for (BulkTable bulkTable : tables) {
            DatastoreClass table = bulkTable.table;
            SQLStatement stmt = new SQLStatement(storeMgr, table, null, null);
            stmt.setClassLoaderResolver(this.clr);
            stmt.setCandidateClassName(candidateCmd.getFullClassName());
            if (table.getMultitenancyMapping() != null) {
                JavaTypeMapping tenantMapping = table.getMultitenancyMapping();
                SQLTable tenantSqlTbl = stmt.getPrimaryTable();
                SQLExpression tenantExpr = stmt.getSQLExpressionFactory().newExpression(stmt, tenantSqlTbl, tenantMapping);
                SQLExpression tenantVal = stmt.getSQLExpressionFactory().newLiteral(stmt, tenantMapping, storeMgr.getStringProperty("datanucleus.TenantID"));
                stmt.whereAnd(tenantExpr.eq(tenantVal), true);
            }
            HashSet<String> options = new HashSet<String>();
            options.add("BULK_DELETE_NO_RESULT");
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, null, null, candidateCmd, this.getFetchPlan(), this.ec, null, options, this.extensions);
            sqlMapper.setDefaultJoinType(SQLJoin.JoinType.INNER_JOIN);
            sqlMapper.compile();
            sqls.add(stmt.getDeleteStatement().toString());
            sqlCountFlags.add(bulkTable.useInCount);
            this.datastoreCompilation.setStatementParameters(stmt.getDeleteStatement().getParametersForStatement());
        }
        if (sqls.size() == 1) {
            this.datastoreCompilation.setSQL((String)sqls.get(0));
        } else {
            this.datastoreCompilation.setSQL(sqls, sqlCountFlags);
        }
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.fetchDirection");
        return supported;
    }

    public boolean processesRangeInDatastoreQuery() {
        if (this.range == null) {
            return true;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
        boolean using_limit_where_clause = dba.getRangeByLimitEndOfStatementClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0 || dba.getRangeByRowNumberColumn2().length() > 0;
        return using_limit_where_clause || using_rownum;
    }

    public void addExtension(String key, Object value) {
        if (key != null && key.equals("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.addExtension(key, value);
    }

    public void setExtensions(Map extensions) {
        if (extensions != null && extensions.containsKey("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.setExtensions(extensions);
    }

    public Object getNativeQuery() {
        if (this.datastoreCompilation != null) {
            return this.datastoreCompilation.getSQL();
        }
        return super.getNativeQuery();
    }

    private class BulkTable {
        DatastoreClass table;
        boolean useInCount;

        public BulkTable(DatastoreClass tbl, boolean useInCount) {
            this.table = tbl;
            this.useInCount = useInCount;
        }

        public String toString() {
            return this.table.toString();
        }
    }
}

