/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.StringUtils;

public class InterfaceMapping
extends ReferenceMapping {
    private String implementationClasses;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        Class fieldTypeCls;
        super.initialize(mmd, table, clr);
        if (mmd.getType().isInterface() && mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1 && (fieldTypeCls = clr.classForName(mmd.getFieldTypes()[0])).isInterface()) {
            this.type = mmd.getFieldTypes()[0];
        }
    }

    public void setImplementationClasses(String implementationClasses) {
        this.implementationClasses = implementationClasses;
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] pos) {
        if (ec.getMetaDataManager().isPersistentInterface(this.type)) {
            if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
                throw new NucleusUserException("DataNucleus does not support use of mapping-strategy=" + this.mappingStrategy + " with a \"persistable interface\"");
            }
            String[] implTypes = null;
            implTypes = this.implementationClasses != null ? StringUtils.split((String)this.implementationClasses, (String)",") : ec.getMetaDataManager().getClassesImplementingInterface(this.getType(), ec.getClassLoaderResolver());
            int n = 0;
            for (int i = 0; i < implTypes.length; ++i) {
                int j;
                JavaTypeMapping mapping;
                if (implTypes.length > this.javaTypeMappings.length) {
                    PersistableMapping m = (PersistableMapping)this.javaTypeMappings[0];
                    mapping = this.storeMgr.getMappingManager().getMapping(ec.getClassLoaderResolver().classForName(implTypes[i]));
                    for (j = 0; j < m.getDatastoreMappings().length; ++j) {
                        mapping.addDatastoreMapping(m.getDatastoreMappings()[j]);
                    }
                    for (j = 0; j < m.getJavaTypeMapping().length; ++j) {
                        ((PersistableMapping)mapping).addJavaTypeMapping(m.getJavaTypeMapping()[j]);
                    }
                    ((PersistableMapping)mapping).setReferenceMapping(m.getReferenceMapping());
                } else {
                    mapping = this.javaTypeMappings[i];
                }
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = mapping.getReferenceMapping() != null ? new int[mapping.getReferenceMapping().getNumberOfDatastoreMappings()] : new int[mapping.getNumberOfDatastoreMappings()];
                for (j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                Object value = null;
                try {
                    value = mapping.getObject(ec, rs, posMapping);
                }
                catch (NullValueException e) {
                }
                catch (NucleusObjectNotFoundException onfe) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof OID) {
                    String className = mapping.getReferenceMapping() != null ? mapping.getReferenceMapping().getDatastoreMapping(0).getColumn().getStoredJavaType() : mapping.getDatastoreMapping(0).getColumn().getStoredJavaType();
                    value = OIDFactory.getInstance((PersistenceNucleusContext)ec.getNucleusContext(), (String)className, (Object)((OID)value).getKeyValue());
                    return ec.findObject(value, false, true, null);
                }
                if (!ec.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
                return value;
            }
            return null;
        }
        return super.getObject(ec, rs, pos);
    }
}

