/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NoTableManagedException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.identifier.IdentifierType;
import org.datanucleus.store.rdbms.mapping.MappingManager;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMapping;
import org.datanucleus.store.rdbms.mapping.datastore.DatastoreMappingFactory;
import org.datanucleus.store.rdbms.mapping.java.ArrayMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.InterfaceMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ObjectMapping;
import org.datanucleus.store.rdbms.mapping.java.PersistableMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedKeyPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedValuePCMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterLongMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterMapping;
import org.datanucleus.store.rdbms.mapping.java.TypeConverterStringMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSMappingManager
implements MappingManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected final RDBMSStoreManager storeMgr;
    protected final ClassLoaderResolver clr;
    protected MultiMap datastoreMappingsByJavaType;
    protected MultiMap datastoreMappingsByJDBCType;
    protected MultiMap datastoreMappingsBySQLType;

    public RDBMSMappingManager(RDBMSStoreManager storeMgr) {
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
    }

    @Override
    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
        if (this.datastoreMappingsByJavaType != null) {
            return;
        }
        this.datastoreMappingsByJDBCType = new MultiMap();
        this.datastoreMappingsBySQLType = new MultiMap();
        this.datastoreMappingsByJavaType = new MultiMap();
        ConfigurationElement[] elems = mgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.rdbms_mapping", null, null);
        if (elems != null) {
            for (int i = 0; i < elems.length; ++i) {
                String javaName = elems[i].getAttribute("java-type").trim();
                String rdbmsMappingClassName = elems[i].getAttribute("rdbms-mapping-class");
                String jdbcType = elems[i].getAttribute("jdbc-type");
                String sqlType = elems[i].getAttribute("sql-type");
                String defaultJava = elems[i].getAttribute("default");
                String javaVersion = elems[i].getAttribute("java-version");
                String javaVersionRestricted = elems[i].getAttribute("java-version-restricted");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                boolean javaRestricted = false;
                if (javaVersionRestricted != null && javaVersionRestricted.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if (javaVersion == null || javaVersion.length() < 1) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan((String)javaVersion) || javaRestricted) && (!JavaUtils.isEqualsThan((String)javaVersion) || !javaRestricted)) continue;
                Class mappingType = null;
                if (StringUtils.isWhitespace((String)rdbmsMappingClassName)) continue;
                try {
                    mappingType = mgr.loadClass(elems[i].getExtension().getPlugin().getSymbolicName(), rdbmsMappingClassName);
                }
                catch (NucleusException ne) {
                    NucleusLogger.DATASTORE.error((Object)LOCALISER_RDBMS.msg("041013", (Object)rdbmsMappingClassName));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                ConfigurationElement[] childElm = elems[i].getChildren();
                for (int j = 0; j < childElm.length; ++j) {
                    if (childElm[j].getName().equals("includes")) {
                        includes.add(childElm[j].getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElm[j].getName().equals("excludes")) continue;
                    excludes.add(childElm[j].getAttribute("vendor-id"));
                }
                if (excludes.contains(vendorId) || !includes.isEmpty() && !includes.contains(vendorId)) continue;
                this.registerDatastoreMapping(javaName, mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    @Override
    public JavaTypeMapping getMappingWithDatastoreMapping(Class c, boolean serialised, boolean embedded, ClassLoaderResolver clr) {
        try {
            DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(c.getName(), clr);
            return datastoreClass.getIdMapping();
        }
        catch (NoTableManagedException ex) {
            Class mc = this.getMappingClass(c, serialised, embedded, null);
            mc = this.getOverrideMappingClass(mc, null, -1);
            JavaTypeMapping m = null;
            try {
                m = (JavaTypeMapping)mc.newInstance();
            }
            catch (Exception e) {
                throw new NucleusException(LOCALISER_RDBMS.msg("041009", (Object)mc.getName(), (Object)e), (Throwable)e).setFatal();
            }
            m.initialize(this.storeMgr, c.getName());
            if (m.hasSimpleDatastoreRepresentation()) {
                this.createDatastoreMapping(m, null, m.getJavaTypeForDatastoreMapping(0));
            }
            return m;
        }
    }

    @Override
    public JavaTypeMapping getMapping(Class c) {
        return this.getMapping(c, false, false, null);
    }

    @Override
    public JavaTypeMapping getMapping(Class c, boolean serialised, boolean embedded, String fieldName) {
        Class mc = this.getMappingClass(c, serialised, embedded, fieldName);
        mc = this.getOverrideMappingClass(mc, null, -1);
        JavaTypeMapping m = null;
        try {
            m = (JavaTypeMapping)mc.newInstance();
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER_RDBMS.msg("041009", (Object)mc.getName(), (Object)e), (Throwable)e).setFatal();
        }
        m.initialize(this.storeMgr, c.getName());
        return m;
    }

    @Override
    public JavaTypeMapping getMapping(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr, int fieldRole) {
        Class mc = null;
        AbstractMemberMetaData overrideMmd = null;
        TypeManager typeMgr = table.getStoreManager().getNucleusContext().getTypeManager();
        TypeConverter conv = null;
        if (!mmd.isTypeConversionDisabled()) {
            TypeConverter autoApplyConv = typeMgr.getAutoApplyTypeConverterFortype(mmd.getType());
            if (mmd.getTypeConverterName() != null) {
                conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
            } else if (autoApplyConv != null) {
                conv = autoApplyConv;
            }
        }
        if (conv != null) {
            mc = TypeManager.getDatastoreTypeForTypeConverter(conv, (Class)mmd.getType()) == String.class ? TypeConverterStringMapping.class : (TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)mmd.getType()) == Long.class ? TypeConverterLongMapping.class : TypeConverterMapping.class);
        } else if (fieldRole == 3 || fieldRole == 4) {
            mc = this.getElementMappingClass(table, mmd, clr);
        } else if (fieldRole == 5) {
            mc = this.getKeyMappingClass(table, mmd, clr);
        } else if (fieldRole == 6) {
            mc = this.getValueMappingClass(table, mmd, clr);
        } else {
            String userMappingClassName = mmd.getValueForExtension("mapping-class");
            if (userMappingClassName != null) {
                try {
                    mc = clr.classForName(userMappingClassName);
                }
                catch (NucleusException ne) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("041014", (Object)mmd.getFullFieldName(), (Object)userMappingClassName)).setFatal();
                }
            } else {
                Object acmd = null;
                acmd = mmd.getType().isInterface() ? this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForInterface(mmd.getType(), clr) : this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (mmd.isSerialized()) {
                    mc = this.getMappingClass(mmd.getType(), true, false, mmd.getFullFieldName());
                } else if (mmd.getEmbeddedMetaData() != null) {
                    mc = this.getMappingClass(mmd.getType(), false, true, mmd.getFullFieldName());
                } else if (acmd != null && acmd.isEmbeddedOnly()) {
                    mc = this.getMappingClass(mmd.getType(), false, true, mmd.getFullFieldName());
                } else if (mmd.isEmbedded()) {
                    mc = this.getMappingClass(mmd.getType(), true, false, mmd.getFullFieldName());
                } else {
                    mc = this.getMappingClass(mmd.getType(), false, false, mmd.getFullFieldName());
                    if (mmd.getParent() instanceof EmbeddedMetaData && mmd.getRelationType(clr) != RelationType.NONE) {
                        AbstractClassMetaData cmdForFmd = table.getStoreManager().getMetaDataManager().getMetaDataForClass(mmd.getClassName(), clr);
                        overrideMmd = cmdForFmd.getMetaDataForMember(mmd.getName());
                    }
                }
            }
        }
        mc = this.getOverrideMappingClass(mc, mmd, fieldRole);
        JavaTypeMapping m = null;
        try {
            m = (JavaTypeMapping)mc.newInstance();
            if (fieldRole >= 0) {
                m.setRoleForMember(fieldRole);
            }
        }
        catch (Exception e) {
            throw new NucleusException(LOCALISER_RDBMS.msg("041009", (Object)mc.getName(), (Object)e), (Throwable)e).setFatal();
        }
        if (conv == null) {
            m.initialize(mmd, table, clr);
            if (overrideMmd != null) {
                m.setMemberMetaData(overrideMmd);
            }
        } else {
            ((TypeConverterMapping)m).initialize(mmd, table, clr, conv);
        }
        return m;
    }

    protected Class getOverrideMappingClass(Class mappingClass, AbstractMemberMetaData mmd, int fieldRole) {
        return mappingClass;
    }

    protected Class getMappingClass(Class c, boolean serialised, boolean embedded, String fieldName) {
        Class superClass;
        Class mappingClass;
        ApiAdapter api = this.storeMgr.getApiAdapter();
        if (api.isPersistable(c)) {
            if (serialised) {
                return SerialisedPCMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return PersistableMapping.class;
        }
        if (c.isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                return EmbeddedPCMapping.class;
            }
            return InterfaceMapping.class;
        }
        if (c == Object.class) {
            if (serialised) {
                return SerialisedReferenceMapping.class;
            }
            if (embedded) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("041042", (Object)fieldName)).setFatal();
            }
            return ObjectMapping.class;
        }
        if (c.isArray()) {
            if (api.isPersistable(c.getComponentType())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType().isInterface() && !this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getComponentType().getName())) {
                return ArrayMapping.class;
            }
            if (c.getComponentType() == Object.class) {
                return ArrayMapping.class;
            }
        }
        if ((mappingClass = this.getDefaultJavaTypeMapping(c)) == null) {
            for (superClass = c.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                mappingClass = this.getDefaultJavaTypeMapping(superClass);
            }
        }
        if (mappingClass == null) {
            if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(c.getName())) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("041001", (Object)fieldName, (Object)c.getName()));
            }
            for (superClass = c; superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappingClass == null; superClass = superClass.getSuperclass()) {
                Class<?>[] interfaces = superClass.getInterfaces();
                for (int i = 0; i < interfaces.length && mappingClass == null; ++i) {
                    mappingClass = this.getDefaultJavaTypeMapping(interfaces[i]);
                }
            }
            if (mappingClass == null) {
                mappingClass = SerialisedMapping.class;
            }
        }
        return mappingClass;
    }

    protected Class getElementMappingClass(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        if (!mmd.hasCollection() && !mmd.hasArray()) {
            throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no collection/array!").setFatal();
        }
        if (mmd.getJoinMetaData() == null) {
            AbstractMemberMetaData[] refMmds = mmd.getRelatedMemberMetaData(clr);
            if (refMmds == null || refMmds.length == 0) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
            if (refMmds[0].getJoinMetaData() == null) {
                throw new NucleusException("Attempt to get element mapping for field " + mmd.getFullFieldName() + " that has no join table defined for the collection/array").setFatal();
            }
        }
        String userMappingClassName = null;
        if (mmd.getElementMetaData() != null) {
            userMappingClassName = mmd.getElementMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasCollection() && mmd.getCollection().isSerializedElement() || mmd.hasArray() && mmd.getArray().isSerializedElement();
        boolean embeddedPC = mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null;
        boolean elementPC = mmd.hasCollection() && mmd.getCollection().elementIsPersistent() || mmd.hasArray() && mmd.getArray().elementIsPersistent();
        boolean embedded = true;
        if (mmd.hasCollection()) {
            embedded = mmd.getCollection().isEmbeddedElement();
        } else if (mmd.hasArray()) {
            embedded = mmd.getArray().isEmbeddedElement();
        }
        Class<?> elementCls = null;
        if (mmd.hasCollection()) {
            elementCls = clr.classForName(mmd.getCollection().getElementType());
        } else if (mmd.hasArray()) {
            elementCls = mmd.getType().getComponentType();
        }
        boolean elementReference = ClassUtils.isReferenceType(elementCls);
        Class mc = null;
        mc = serialised ? (elementPC ? SerialisedElementPCMapping.class : (elementReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedElementPCMapping.class : (elementPC ? PersistableMapping.class : this.getMappingClass(elementCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(elementCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getKeyMappingClass(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get key mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (mmd.getKeyMetaData() != null) {
            userMappingClassName = mmd.getKeyMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedKey();
        boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedKey();
        boolean embeddedPC = mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null;
        boolean keyPC = mmd.hasMap() && mmd.getMap().keyIsPersistent();
        Class keyCls = clr.classForName(mmd.getMap().getKeyType());
        boolean keyReference = ClassUtils.isReferenceType((Class)keyCls);
        Class mc = null;
        mc = serialised ? (keyPC ? SerialisedKeyPCMapping.class : (keyReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedKeyPCMapping.class : (keyPC ? PersistableMapping.class : this.getMappingClass(keyCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(keyCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getValueMappingClass(Table table, AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        if (mmd.getMap() == null) {
            throw new NucleusException("Attempt to get value mapping for field " + mmd.getFullFieldName() + " that has no map!").setFatal();
        }
        String userMappingClassName = null;
        if (mmd.getValueMetaData() != null) {
            userMappingClassName = mmd.getValueMetaData().getValueForExtension("mapping-class");
        }
        if (userMappingClassName != null) {
            try {
                return clr.classForName(userMappingClassName);
            }
            catch (NucleusException jpe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("041014", (Object)userMappingClassName)).setFatal();
            }
        }
        boolean serialised = mmd.hasMap() && mmd.getMap().isSerializedValue();
        boolean embedded = mmd.hasMap() && mmd.getMap().isEmbeddedValue();
        boolean embeddedPC = mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null;
        boolean valuePC = mmd.hasMap() && mmd.getMap().valueIsPersistent();
        Class valueCls = clr.classForName(mmd.getMap().getValueType());
        boolean valueReference = ClassUtils.isReferenceType((Class)valueCls);
        Class mc = null;
        mc = serialised ? (valuePC ? SerialisedValuePCMapping.class : (valueReference ? SerialisedReferenceMapping.class : SerialisedMapping.class)) : (embedded ? (embeddedPC ? EmbeddedValuePCMapping.class : (valuePC ? PersistableMapping.class : this.getMappingClass(valueCls, serialised, embedded, mmd.getFullFieldName()))) : this.getMappingClass(valueCls, serialised, embedded, mmd.getFullFieldName()));
        return mc;
    }

    protected Class getDefaultJavaTypeMapping(Class javaType) {
        Class cls = this.storeMgr.getMappedTypeManager().getMappingType(javaType.getName());
        if (cls == null) {
            TypeConverter conv = this.storeMgr.getNucleusContext().getTypeManager().getDefaultTypeConverterForType(javaType);
            if (conv != null) {
                if (TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)javaType) == String.class) {
                    return TypeConverterStringMapping.class;
                }
                if (TypeManager.getDatastoreTypeForTypeConverter((TypeConverter)conv, (Class)javaType) == Long.class) {
                    return TypeConverterLongMapping.class;
                }
                return TypeConverterMapping.class;
            }
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER_RDBMS.msg("041000", (Object)javaType.getName()), (Throwable)new Exception());
            return null;
        }
        return cls;
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
        boolean mappingRequired = true;
        Collection coll = (Collection)this.datastoreMappingsByJavaType.get((Object)javaTypeName);
        if (coll != null && coll.size() > 0) {
            for (RDBMSTypeMapping typeMapping : coll) {
                if (typeMapping.jdbcType.equals(jdbcType) && typeMapping.sqlType.equals(sqlType)) {
                    mappingRequired = false;
                    if (typeMapping.isDefault() == dflt) continue;
                    typeMapping.setDefault(dflt);
                    continue;
                }
                if (!dflt) continue;
                typeMapping.setDefault(false);
            }
        }
        if (mappingRequired) {
            RDBMSTypeMapping mapping = new RDBMSTypeMapping(datastoreMappingType, dflt, javaTypeName, jdbcType, sqlType);
            this.datastoreMappingsByJDBCType.put((Object)jdbcType, (Object)mapping);
            this.datastoreMappingsBySQLType.put((Object)sqlType, (Object)mapping);
            this.datastoreMappingsByJavaType.put((Object)javaTypeName, (Object)mapping);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER_RDBMS.msg("054009", (Object)javaTypeName, (Object)jdbcType, (Object)sqlType, (Object)datastoreMappingType.getName(), (Object)("" + dflt)));
            }
        }
    }

    public void deregisterDatastoreMappingsForJDBCType(String jdbcTypeName) {
        Collection coll = (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcTypeName);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet mappings = new HashSet(coll);
        for (RDBMSTypeMapping mapping : mappings) {
            this.datastoreMappingsByJavaType.remove((Object)mapping.javaType, (Object)mapping);
            this.datastoreMappingsBySQLType.remove((Object)mapping.sqlType, (Object)mapping);
            this.datastoreMappingsByJDBCType.remove((Object)mapping.jdbcType, (Object)mapping);
            if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
            NucleusLogger.DATASTORE.debug((Object)LOCALISER_RDBMS.msg("054010", (Object)mapping.javaType, (Object)mapping.jdbcType, (Object)mapping.sqlType));
        }
    }

    protected Class getDatastoreMappingClass(String fieldName, String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr) {
        if (javaType == null) {
            return null;
        }
        javaType = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
        RDBMSTypeMapping datastoreMapping = null;
        if (sqlType != null) {
            if (this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase()) == null) {
                if (jdbcType == null) {
                    if (fieldName != null) {
                        throw new NucleusException(LOCALISER_RDBMS.msg("054001", (Object)javaType, (Object)sqlType, (Object)fieldName)).setFatal();
                    }
                    throw new NucleusException(LOCALISER_RDBMS.msg("054000", (Object)javaType, (Object)sqlType)).setFatal();
                }
                if (fieldName != null) {
                    NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("054012", (Object)javaType, (Object)sqlType, (Object)fieldName, (Object)jdbcType));
                } else {
                    NucleusLogger.DATASTORE_SCHEMA.info((Object)LOCALISER_RDBMS.msg("054011", (Object)javaType, (Object)sqlType, (Object)jdbcType));
                }
            } else {
                for (RDBMSTypeMapping sqlTypeMapping : (Collection)this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase())) {
                    if (!sqlTypeMapping.javaType.equals(javaType)) continue;
                    datastoreMapping = sqlTypeMapping;
                    break;
                }
            }
        }
        if (datastoreMapping == null && jdbcType != null) {
            if (this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("054003", (Object)javaType, (Object)jdbcType, (Object)fieldName)).setFatal();
                }
                throw new NucleusException(LOCALISER_RDBMS.msg("054002", (Object)javaType, (Object)jdbcType)).setFatal();
            }
            for (RDBMSTypeMapping jdbcTypeMapping : (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase())) {
                if (!jdbcTypeMapping.javaType.equals(javaType)) continue;
                datastoreMapping = jdbcTypeMapping;
                break;
            }
            if (datastoreMapping == null) {
                if (fieldName != null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("054003", (Object)javaType, (Object)jdbcType, (Object)fieldName)).setFatal();
                }
                throw new NucleusException(LOCALISER_RDBMS.msg("054002", (Object)javaType, (Object)jdbcType)).setFatal();
            }
        }
        if (datastoreMapping == null) {
            String type = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
            Collection mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)type);
            if (mappings == null) {
                Class javaTypeClass = clr.classForName(type);
                for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappings == null; superClass = superClass.getSuperclass()) {
                    mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)superClass.getName());
                }
            }
            if (mappings != null) {
                if (mappings.size() == 1) {
                    datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                } else {
                    for (RDBMSTypeMapping rdbmsMapping : mappings) {
                        if (!rdbmsMapping.isDefault()) continue;
                        datastoreMapping = rdbmsMapping;
                        break;
                    }
                    if (datastoreMapping == null && mappings.size() > 0) {
                        datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                    }
                }
            }
        }
        if (datastoreMapping == null) {
            if (fieldName != null) {
                throw new NucleusException(LOCALISER_RDBMS.msg("054005", (Object)javaType, (Object)jdbcType, (Object)sqlType, (Object)fieldName)).setFatal();
            }
            throw new NucleusException(LOCALISER_RDBMS.msg("054004", (Object)javaType, (Object)jdbcType, (Object)sqlType)).setFatal();
        }
        return datastoreMapping.getMappingType();
    }

    @Override
    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, AbstractMemberMetaData mmd, int index, Column column) {
        Class datastoreMappingClass = null;
        if (mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[index].hasExtension("datastore-mapping-class")) {
            datastoreMappingClass = this.clr.classForName(mmd.getColumnMetaData()[index].getValueForExtension("datastore-mapping-class"));
        }
        if (datastoreMappingClass == null) {
            String javaType = mapping.getJavaTypeForDatastoreMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (mapping.getRoleForMember() == 4 || mapping.getRoleForMember() == 3) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getCollection() != null && mmd.getCollection().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
                if (mmd.getArray() != null && mmd.getArray().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == 5) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedKey()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == 6) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedValue()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else {
                if (mmd.getColumnMetaData().length > 0) {
                    jdbcType = mmd.getColumnMetaData()[index].getJdbcType();
                    sqlType = mmd.getColumnMetaData()[index].getSqlType();
                }
                if (mmd.isSerialized()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            }
            datastoreMappingClass = this.getDatastoreMappingClass(mmd.getFullFieldName(), javaType, jdbcType, sqlType, this.clr);
        }
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    @Override
    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, Column column, String javaType) {
        Column col = column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcType();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class datastoreMappingClass = this.getDatastoreMappingClass(null, javaType, jdbcType, sqlType, this.clr);
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, this.storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData[] colmds;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        int roleForField = mapping.getRoleForMember();
        Table tbl = mapping.getTable();
        ColumnMetaData colmd = null;
        AbstractMemberMetaData columnContainer = fmd;
        if (roleForField == 3 || roleForField == 4) {
            columnContainer = fmd.getElementMetaData();
        } else if (roleForField == 5) {
            columnContainer = fmd.getKeyMetaData();
        } else if (roleForField == 6) {
            columnContainer = fmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = columnContainer.getColumnMetaData()[datastoreFieldIndex];
            colmds = columnContainer.getColumnMetaData();
        } else {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
                colmds = columnContainer.getColumnMetaData();
            } else {
                colmds = new ColumnMetaData[]{colmd};
            }
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            if (roleForField == 3) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 3);
            } else if (roleForField == 4) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 4);
            } else if (roleForField == 5) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 5);
            } else if (roleForField == 6) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 6);
            } else {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
                int i = 0;
                while (tbl.hasColumn(identifier)) {
                    identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                    ++i;
                }
            }
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmds[datastoreFieldIndex].getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1);
        }
        Column col = tbl.addColumn(javaType, identifier, mapping, colmd);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (fmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isStrategyDatastoreAttributed(fmd.getAbstractClassMetaData(), fmd.getAbsoluteFieldNumber()) && tbl instanceof DatastoreClass && (fmd.isPrimaryKey() && ((DatastoreClass)tbl).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    @Override
    public Column createColumn(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        Column col;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        Table tbl = mapping.getTable();
        if (colmd == null) {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
            int i = 0;
            while (tbl.hasColumn(identifier)) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifierName());
            col = tbl.addColumn(javaType, identifier, mapping, colmd);
        } else {
            col = tbl.addColumn(javaType, idFactory.newColumnIdentifier(colmd.getName(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1), mapping, colmd);
        }
        this.setColumnNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    @Override
    public Column createColumn(AbstractMemberMetaData mmd, Table table, JavaTypeMapping mapping, ColumnMetaData colmd, Column reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
            identifier = idFactory.newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, mmd, reference.getIdentifier(), this.storeMgr.getNucleusContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), 1);
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newColumnIdentifier(colmd.getName(), false, -1);
        }
        Column col = table.addColumn(mmd.getType().getName(), identifier, mapping, colmd);
        reference.copyConfigurationTo(col);
        if (mmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (mmd.getParent() instanceof AbstractClassMetaData && this.storeMgr.isStrategyDatastoreAttributed(mmd.getAbstractClassMetaData(), mmd.getAbsoluteFieldNumber()) && (mmd.isPrimaryKey() && ((DatastoreClass)table).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setColumnNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    private void setColumnNullability(AbstractMemberMetaData mmd, ColumnMetaData colmd, Column col) {
        if (colmd != null && colmd.getAllowsNull() == null) {
            if (mmd.isPrimaryKey()) {
                colmd.setAllowsNull(Boolean.valueOf(false));
            } else if (!mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(Boolean.valueOf(true));
            } else {
                colmd.setAllowsNull(Boolean.valueOf(false));
            }
            if (colmd.isAllowsNull()) {
                col.setNullable();
            }
        } else if (colmd != null && colmd.getAllowsNull() != null) {
            if (colmd.isAllowsNull()) {
                col.setNullable();
            }
        } else if (!mmd.isPrimaryKey() && !mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
            col.setNullable();
        }
    }

    protected class RDBMSTypeMapping {
        private String javaType;
        private String jdbcType;
        private String sqlType;
        private Class javaMappingType;
        private boolean isDefault;

        public RDBMSTypeMapping(Class mappingType, boolean isDefault, String javaType, String jdbcType, String sqlType) {
            this.javaMappingType = mappingType;
            this.isDefault = isDefault;
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Class getMappingType() {
            return this.javaMappingType;
        }

        public void setMappingType(Class type) {
            this.javaMappingType = type;
        }
    }
}

