/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NoSuchPersistentFieldException;
import org.datanucleus.store.rdbms.exceptions.PersistentSuperclassNotAllowedException;
import org.datanucleus.store.rdbms.exceptions.ViewDefinitionException;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.util.MacroString;

public class ClassView
extends ViewImpl
implements DatastoreClass {
    private final ClassMetaData cmd;
    private final MacroString viewDef;
    private String createStatementDDL;
    private JavaTypeMapping[] fieldMappings;

    public ClassView(DatastoreIdentifier tableName, RDBMSStoreManager storeMgr, ClassMetaData cmd) {
        super(tableName, storeMgr);
        this.cmd = cmd;
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("031005", (Object)cmd.getFullClassName(), (Object)cmd.getIdentityType()));
        }
        if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            // empty if block
        }
        if (cmd.getPersistenceCapableSuperclass() != null) {
            throw new PersistentSuperclassNotAllowedException(cmd.getFullClassName());
        }
        String viewImpStr = cmd.getValueForExtension("view-imports");
        String viewDefStr = null;
        if (this.dba.getVendorID() != null) {
            viewDefStr = cmd.getValueForExtension("view-definition-" + this.dba.getVendorID());
        }
        if (viewDefStr == null) {
            viewDefStr = cmd.getValueForExtension("view-definition");
        }
        if (viewDefStr == null) {
            throw new ViewDefinitionException(cmd.getFullClassName(), null);
        }
        this.viewDef = new MacroString(cmd.getFullClassName(), viewImpStr, viewDefStr);
    }

    @Override
    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        int fieldCount = this.cmd.getNoOfManagedMembers();
        this.fieldMappings = new JavaTypeMapping[fieldCount];
        for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
            AbstractMemberMetaData fmd = this.cmd.getMetaDataForManagedMemberAtPosition(fieldNumber);
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                this.fieldMappings[fieldNumber] = this.storeMgr.getMappingManager().getMapping(this, fmd, clr, 2);
                continue;
            }
            if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
            throw new NucleusException(LOCALISER.msg("031006", (Object)this.cmd.getFullClassName(), (Object)fmd.getName(), (Object)fmd.getPersistenceModifier())).setFatal();
        }
        this.state = 2;
    }

    @Override
    public void postInitialize(final ClassLoaderResolver clr) {
        this.assertIsInitialized();
        this.createStatementDDL = this.viewDef.substituteMacros(new MacroString.MacroHandler(){

            public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                ClassView.this.storeMgr.resolveIdentifierMacro(im, clr);
            }

            public void onParameterMacro(MacroString.ParameterMacro pm) {
                throw new NucleusUserException(AbstractTable.LOCALISER.msg("031009", (Object)ClassView.this.cmd.getFullClassName(), (Object)pm));
            }
        }, clr);
    }

    @Override
    public JavaTypeMapping getIdMapping() {
        for (int i = 0; i < this.fieldMappings.length; ++i) {
            if (this.fieldMappings[i] == null) continue;
            return this.fieldMappings[i];
        }
        return null;
    }

    @Override
    public DatastoreClass getBaseDatastoreClassWithMember(AbstractMemberMetaData mmd) {
        return null;
    }

    @Override
    public DatastoreClass getSuperDatastoreClass() {
        return null;
    }

    @Override
    public boolean isSuperDatastoreClass(DatastoreClass table) {
        return false;
    }

    public Collection getSecondaryDatastoreClasses() {
        return null;
    }

    @Override
    public JavaTypeMapping getDatastoreObjectIdMapping() {
        return null;
    }

    @Override
    public boolean managesClass(String className) {
        return false;
    }

    @Override
    public String[] getManagedClasses() {
        return null;
    }

    @Override
    public boolean managesMapping(JavaTypeMapping mapping) {
        return false;
    }

    public AbstractMemberMetaData getFieldMetaData(String fieldName) {
        return this.cmd.getMetaDataForMember(fieldName);
    }

    @Override
    public IdentityType getIdentityType() {
        return this.cmd.getIdentityType();
    }

    @Override
    public boolean isBaseDatastoreClass() {
        return true;
    }

    @Override
    public DatastoreClass getBaseDatastoreClass() {
        return this;
    }

    @Override
    public boolean isObjectIdDatastoreAttributed() {
        return false;
    }

    @Override
    public void provideDatastoreIdMappings(MappingConsumer consumer) {
    }

    @Override
    public void provideDiscriminatorMappings(MappingConsumer consumer) {
    }

    @Override
    public void provideMultitenancyMapping(MappingConsumer consumer) {
    }

    @Override
    public void provideMappingsForMembers(MappingConsumer consumer, AbstractMemberMetaData[] fieldNumbers, boolean includeSecondaryTables) {
    }

    @Override
    public void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
    }

    @Override
    public void providePrimaryKeyMappings(MappingConsumer consumer) {
    }

    @Override
    public void provideVersionMappings(MappingConsumer consumer) {
    }

    @Override
    public void provideExternalMappings(MappingConsumer consumer, int mappingType) {
    }

    @Override
    public void provideUnmappedColumns(MappingConsumer consumer) {
    }

    @Override
    public String getType() {
        return this.cmd.getFullClassName();
    }

    @Override
    public JavaTypeMapping getMemberMapping(AbstractMemberMetaData mmd) {
        this.assertIsInitialized();
        JavaTypeMapping m = this.fieldMappings[mmd.getAbsoluteFieldNumber()];
        if (m == null) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), mmd.getAbsoluteFieldNumber());
        }
        return m;
    }

    @Override
    public JavaTypeMapping getMemberMappingInDatastoreClass(AbstractMemberMetaData mmd) {
        return this.getMemberMapping(mmd);
    }

    @Override
    public JavaTypeMapping getMemberMapping(String fieldName) {
        this.assertIsInitialized();
        int rfn = this.cmd.getRelativePositionOfMember(fieldName);
        if (rfn < 0) {
            throw new NoSuchPersistentFieldException(this.cmd.getFullClassName(), fieldName);
        }
        return this.getMemberMapping(this.cmd.getMetaDataForManagedMemberAtPosition(rfn));
    }

    @Override
    protected List getSQLCreateStatements(Properties props) {
        this.assertIsInitialized();
        ArrayList<String> stmts = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.createStatementDDL, ";");
        while (tokens.hasMoreTokens()) {
            stmts.add(tokens.nextToken());
        }
        return stmts;
    }

    @Override
    public final DiscriminatorMetaData getDiscriminatorMetaData() {
        return null;
    }

    @Override
    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return null;
    }

    @Override
    public final VersionMetaData getVersionMetaData() {
        return null;
    }

    @Override
    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return null;
    }

    @Override
    public JavaTypeMapping getExternalMapping(AbstractMemberMetaData fmd, int mappingType) {
        throw new NucleusException("N/A").setFatal();
    }

    @Override
    public AbstractMemberMetaData getMetaDataForExternalMapping(JavaTypeMapping mapping, int mappingType) {
        throw new NucleusException("N/A").setFatal();
    }
}

