/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.datastore.CharRDBMSMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class XMLTypeRDBMSMapping
extends CharRDBMSMapping {
    protected XMLTypeRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public XMLTypeRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    protected void initialize() {
        this.initTypeInfo();
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(2007);
    }

    @Override
    public String getString(Object rs, int param) {
        String value = null;
        try {
            OPAQUE o = (OPAQUE)((ResultSet)rs).getObject(param);
            if (o != null) {
                value = XMLType.createXML((OPAQUE)o).getStringVal();
            }
            if (this.getDatastoreAdapter().supportsOption("NullEqualsEmptyString") && value != null && value.equals(this.getDatastoreAdapter().getSurrogateForEmptyStrings())) {
                value = "";
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType(), "SYS.XMLTYPE");
                }
            } else {
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }
}

