/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSJoinListStore
extends AbstractListStore {
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementClassMapping iteratorMappingDef = null;
    private StatementParameterMapping iteratorMappingParams = null;
    private String setStmt;

    public RDBMSJoinListStore(AbstractMemberMetaData mmd, CollectionTable collTable, ClassLoaderResolver clr) {
        super((RDBMSStoreManager)collTable.getStoreManager(), clr);
        this.containerTable = collTable;
        this.setOwner(mmd, clr);
        this.ownerMapping = collTable.getOwnerMapping();
        this.elementMapping = collTable.getElementMapping();
        this.orderMapping = collTable.getOrderMapping();
        if (this.ownerMemberMetaData.getOrderMetaData() != null && !this.ownerMemberMetaData.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056044", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)collTable.toString()));
        }
        this.relationDiscriminatorMapping = collTable.getRelationDiscriminatorMapping();
        this.relationDiscriminatorValue = collTable.getRelationDiscriminatorValue();
        this.elementType = mmd.getCollection().getElementType();
        this.elementsAreEmbedded = collTable.isEmbeddedElement();
        this.elementsAreSerialised = collTable.isSerialisedElement();
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(this.elementType);
            if (ClassUtils.isReferenceType((Class)element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 3, clr, this.storeMgr.getMetaDataManager());
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                this.elementInfo = this.emd != null ? (!this.elementsAreEmbedded ? this.getElementInformationForClass() : null) : null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean internalAdd(ObjectProvider op, int start, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int shift = c.size();
        ExecutionContext ec = op.getExecutionContext();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            ObjectProvider elementSM;
            Object element = iter.next();
            this.validateElementForWriting(ec, element, null);
            if (this.relationType != RelationType.ONE_TO_MANY_BI || (elementSM = ec.findObjectProvider(element)) == null) continue;
            AbstractMemberMetaData[] relatedMmds = this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr);
            Object elementOwner = elementSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
            if (elementOwner == null) {
                NucleusLogger.PERSISTENCE.info((Object)LOCALISER.msg("056037", (Object)op.getObjectAsPrintable(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject())));
                elementSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), op.getObject());
                continue;
            }
            if (elementOwner == op.getObject() || op.getReferencedPC() != null) continue;
            throw new NucleusUserException(LOCALISER.msg("056038", (Object)op.getObjectAsPrintable(), (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)elementSM.getObject()), (Object)StringUtils.toJVMIDString((Object)elementOwner)));
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(op) : size;
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager(this.storeMgr, op);
            dynamicSchemaFM.storeObjectField(this.getOwnerMemberMetaData().getAbsoluteFieldNumber(), c);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.invalidateAddStmt();
            }
        }
        String addStmt = this.getAddStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                if (!atEnd && start != currentListSize) {
                    boolean batched = currentListSize - start > 0;
                    for (int i = currentListSize - 1; i >= start; --i) {
                        this.internalShift(op, mconn, batched, i, shift, i == start);
                    }
                } else {
                    start = currentListSize;
                }
                int jdbcPosition = 1;
                boolean batched = c.size() > 1;
                for (Object element : c) {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, addStmt, batched);
                    try {
                        JavaTypeMapping orderMapping = this.getOrderMapping();
                        JavaTypeMapping elementMapping = this.getElementMapping();
                        JavaTypeMapping relationDiscriminatorMapping = this.getRelationDiscriminatorMapping();
                        jdbcPosition = 1;
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, elementMapping);
                        if (orderMapping != null) {
                            jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, start, jdbcPosition, orderMapping);
                        }
                        if (relationDiscriminatorMapping != null) {
                            jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                        }
                        ++start;
                        sqlControl.executeStatementUpdate(ec, mconn, addStmt, ps, !iter.hasNext());
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)addStmt), (Throwable)e);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)addStmt), (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(ObjectProvider op, int index, Object element, boolean allowDependentField) {
        ExecutionContext ec = op.getExecutionContext();
        this.validateElementForWriting(ec, element, null);
        Object oldElement = this.get(op, index);
        if (this.storeMgr.getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager(this.storeMgr, op);
            ArrayList<Object> coll = new ArrayList<Object>();
            coll.add(element);
            dynamicSchemaFM.storeObjectField(this.getOwnerMemberMetaData().getAbsoluteFieldNumber(), coll);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.setStmt = null;
            }
        }
        String setStmt = this.getSetStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    if (this.getOwnerMemberMetaData().getOrderMetaData() != null && !this.getOwnerMemberMetaData().getOrderMetaData().isIndexedList()) {
                        NucleusLogger.PERSISTENCE.warn((Object)"Calling List.addElement at a position for an ordered list is a stupid thing to do; the ordering is set my the ordering specification. Use an indexed list to do this correctly");
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, this.orderMapping);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(ec, mconn, setStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056015", (Object)setStmt), (Throwable)e);
        }
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        boolean dependent = collmd.isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent && !collmd.isEmbeddedElement() && allowDependentField && oldElement != null && !this.contains(op, oldElement)) {
            ec.deleteObjectInternal(oldElement);
        }
        return oldElement;
    }

    @Override
    public void update(ObjectProvider op, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(op);
            return;
        }
        if (this.ownerMemberMetaData.getCollection().isSerializedElement() || this.ownerMemberMetaData.getCollection().isEmbeddedElement()) {
            this.clear(op);
            this.addAll(op, coll, 0);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(op);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(op, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (existing.equals(coll)) {
            return;
        }
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean internalRemove(ObjectProvider ownerSM, Object element, int size) {
        boolean modified = false;
        if (this.indexedList) {
            ArrayList<Object> elements = new ArrayList<Object>();
            elements.add(element);
            int[] indices = this.getIndicesOf(ownerSM, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.internalRemoveAt(ownerSM, indices[i], size);
                modified = true;
            }
            return modified;
        } else {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                int[] rcs = this.internalRemove(ownerSM, mconn, false, element, true);
                if (rcs == null || rcs[0] <= 0) return modified;
                modified = true;
                return modified;
            }
            catch (MappedDatastoreException sqe) {
                String msg = LOCALISER.msg("056012", (Object)sqe.getMessage());
                NucleusLogger.DATASTORE.error((Object)msg, sqe.getCause());
                throw new NucleusDataStoreException(msg, (Throwable)sqe, ownerSM.getObject());
            }
            finally {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        int currentListSize = this.size(op);
        int[] indices = this.getIndicesOf(op, elements);
        boolean modified = false;
        SQLController sqlControl = this.storeMgr.getSQLController();
        ExecutionContext ec = op.getExecutionContext();
        String removeAllStmt = this.getRemoveAllStmt(elements);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeAllStmt, false);
                try {
                    int jdbcPosition = 1;
                    for (Object element : elements) {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                        jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                        if (this.relationDiscriminatorMapping == null) continue;
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    int[] number = sqlControl.executeStatementUpdate(ec, mconn, removeAllStmt, ps, true);
                    if (number[0] > 0) {
                        modified = true;
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        try {
            boolean batched = this.storeMgr.allowsBatching();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                for (int i = 0; i < currentListSize; ++i) {
                    int shift = 0;
                    boolean removed = false;
                    for (int j = 0; j < indices.length; ++j) {
                        if (indices[j] == i) {
                            removed = true;
                            break;
                        }
                        if (indices[j] >= i) continue;
                        ++shift;
                    }
                    if (removed || shift <= 0) continue;
                    this.internalShift(op, mconn, batched, i, -1 * shift, i == currentListSize - 1);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (MappedDatastoreException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)removeAllStmt), (Throwable)e);
        }
        boolean dependent = this.getOwnerMemberMetaData().getCollection().isDependentElement();
        if (this.getOwnerMemberMetaData().isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            op.getExecutionContext().deleteObjects(elements.toArray());
        }
        return modified;
    }

    @Override
    protected void internalRemoveAt(ObjectProvider op, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        this.internalRemoveAt(op, index, this.getRemoveAtStmt(), size);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ListIterator listIterator(ObjectProvider op, int startIdx, int endIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider op, int startIdx, int endIdx, StatementClassMapping resultMapping, StatementParameterMapping paramMapping) {
        SQLExpression[] orderExprs;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = op.getExecutionContext().getClassLoaderResolver();
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            sqlStmt = new SQLStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else if (this.elementMapping instanceof ReferenceMapping) {
            sqlStmt = new SQLStatement(this.storeMgr, this.containerTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementInfo[elementNo].getClassName());
                SQLStatement elementStmt = null;
                if (this.elementInfo[elementNo].getDiscriminatorStrategy() != null && this.elementInfo[elementNo].getDiscriminatorStrategy() != DiscriminatorStrategy.NONE) {
                    String elementType = this.ownerMemberMetaData.getCollection().getElementType();
                    if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                        String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                        Class[] cls = new Class[clsNames.length];
                        for (int j = 0; j < clsNames.length; ++j) {
                            cls[j] = clr.classForName(clsNames[j]);
                        }
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement();
                    } else {
                        DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                        if (this.allowNulls) {
                            stmtGen.setOption("allowNulls");
                        }
                        elementStmt = stmtGen.getStatement();
                    }
                    this.iterateUsingDiscriminator = true;
                } else {
                    UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
                    stmtGen.setOption("selectNucleusType");
                    resultMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
                    elementStmt = stmtGen.getStatement();
                }
                if (sqlStmt == null) {
                    sqlStmt = elementStmt;
                    continue;
                }
                sqlStmt.union(elementStmt);
            }
            SQLTable elementSqlTbl = sqlStmt.getTable((DatastoreContainerObject)this.elementInfo[0].getDatastoreClass(), sqlStmt.getPrimaryTable().getGroupName());
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, resultMapping, op.getExecutionContext().getFetchPlan(), elementSqlTbl, this.emd, 0);
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.indexedList) {
            SQLExpression indexVal;
            SQLExpression indexExpr;
            boolean needsOrdering = true;
            if (startIdx == -1 && endIdx == -1) {
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
            } else if (startIdx >= 0 && endIdx == startIdx) {
                needsOrdering = false;
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                sqlStmt.whereAnd(indexExpr.eq(indexVal), true);
            } else {
                if (startIdx >= 0) {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                } else {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                }
                if (endIdx >= 0) {
                    SQLExpression indexExpr2 = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    SQLExpression indexVal2 = exprFactory.newLiteral(sqlStmt, this.orderMapping, endIdx);
                    sqlStmt.whereAnd(indexExpr2.lt(indexVal2), true);
                }
            }
            if (needsOrdering) {
                SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
                orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
                sqlStmt.setOrdering(orderExprs, descendingOrder);
            }
        } else if (this.elementInfo != null && this.elementInfo.length > 0) {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            orderExprs = new SQLExpression[orderComponents.length];
            boolean[] orderDirs = new boolean[orderComponents.length];
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getMemberMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                orderDirs[i] = !orderComponents[i].isForward();
                SQLTable fieldSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), fieldMapping);
                orderExprs[i] = exprFactory.newExpression(sqlStmt, fieldSqlTbl, fieldMapping);
            }
            sqlStmt.setOrdering(orderExprs, orderDirs);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < paramPositions.length; ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < paramPositions.length; ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        paramMapping.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }

    protected String getSetStmt() {
        if (this.setStmt == null) {
            StringBuffer stmt = new StringBuffer("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (int i = 0; i < this.elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(this.elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            if (this.getOwnerMemberMetaData().getOrderMetaData() == null || this.getOwnerMemberMetaData().getOrderMetaData().isIndexedList()) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.orderMapping, null, false);
            }
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            this.setStmt = stmt.toString();
        }
        return this.setStmt;
    }

    protected String getRemoveAllStmt(Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        StringBuffer stmt = new StringBuffer("DELETE FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        boolean first = true;
        for (Object element : elements) {
            if (first) {
                stmt.append("(");
            } else {
                stmt.append(" OR (");
            }
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.isElementsAreSerialised(), null, false);
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, null, false);
            }
            stmt.append(")");
            first = false;
        }
        return stmt.toString();
    }
}

