/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;

public class ResultSetGetter
extends AbstractFieldManager {
    private final RDBMSStoreManager storeMgr;
    private final ObjectProvider op;
    private final AbstractClassMetaData cmd;
    private final ExecutionContext ec;
    private final Object resultSet;
    private final StatementClassMapping resultMappings;

    public ResultSetGetter(RDBMSStoreManager storeMgr, ObjectProvider op, Object results, StatementClassMapping resultMappings) {
        this.storeMgr = storeMgr;
        this.op = op;
        this.cmd = op.getClassMetaData();
        this.ec = op.getExecutionContext();
        this.resultSet = results;
        this.resultMappings = resultMappings;
    }

    public ResultSetGetter(RDBMSStoreManager storeMgr, ExecutionContext ec, Object results, StatementClassMapping resultMappings, AbstractClassMetaData cmd) {
        this.storeMgr = storeMgr;
        this.op = null;
        this.cmd = cmd;
        this.ec = ec;
        this.resultSet = results;
        this.resultMappings = resultMappings;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getBoolean(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public char fetchCharField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getChar(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public byte fetchByteField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getByte(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public short fetchShortField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getShort(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public int fetchIntField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getInt(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public long fetchLongField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getLong(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public float fetchFloatField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getFloat(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public double fetchDoubleField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getDouble(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public String fetchStringField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getString(this.ec, this.resultSet, mapIdx.getColumnPositions());
    }

    public Object fetchObjectField(int fieldNumber) {
        Object value;
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        JavaTypeMapping mapping = mapIdx.getMapping();
        if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping) {
            value = mapping.getObject(this.ec, this.resultSet, mapIdx.getColumnPositions(), this.op, fieldNumber);
        } else {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            if (relationType == RelationType.ONE_TO_ONE_BI || relationType == RelationType.ONE_TO_ONE_UNI || relationType == RelationType.MANY_TO_ONE_BI) {
                StatementClassMapping relationMappings = this.resultMappings.getMappingDefinitionForMemberPosition(fieldNumber);
                if (relationMappings != null) {
                    ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
                    AbstractClassMetaData relatedCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    ResultObjectFactory relationROF = this.storeMgr.newResultObjectFactory(relatedCmd, relationMappings, false, this.ec.getFetchPlan(), mmd.getType());
                    value = relationROF.getObject(this.ec, this.resultSet);
                } else {
                    value = mapping.getObject(this.ec, this.resultSet, mapIdx.getColumnPositions());
                }
            } else {
                value = mapping.getObject(this.ec, this.resultSet, mapIdx.getColumnPositions());
            }
        }
        if (this.op != null) {
            return this.op.wrapSCOField(fieldNumber, value, false, false, false);
        }
        return value;
    }
}

