/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class BigIntRDBMSMapping
extends RDBMSMapping {
    protected BigIntRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BigIntRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
        }
        this.initTypeInfo();
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(-5, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(-5);
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value)), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = (int)((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"long", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"long", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setString(Object preparedStatement, int exprIndex, String value) {
        super.setLong(preparedStatement, exprIndex, Long.parseLong(value));
    }

    public String getString(Object resultSet, int exprIndex) {
        return Long.toString(super.getLong(resultSet, exprIndex));
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                    ((PreparedStatement)ps).setLong(param, Long.valueOf(this.column.getDefaultValue().toString().trim()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value instanceof Character) {
                String s = value.toString();
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof String) {
                String s = (String)value;
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setLong(param, ((Date)value).getTime());
            } else {
                ((PreparedStatement)ps).setLong(param, ((Number)value).longValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Long", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Comparable<Long> value;
        block6: {
            try {
                String str = ((ResultSet)rs).getString(param);
                if (((ResultSet)rs).wasNull()) {
                    value = null;
                    break block6;
                }
                try {
                    value = Long.valueOf(str);
                }
                catch (NumberFormatException nfe) {
                    value = new Double(str).longValue();
                }
                if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                    value = new Date((long)value);
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER_RDBMS.msg("055002", (Object)"Long", (Object)("" + param), (Object)this.column, (Object)e.getMessage());
                throw new NucleusDataStoreException(msg, (Throwable)e);
            }
        }
        return value;
    }
}

