/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.Transaction;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;

public class RDBMSFKMapStore
extends AbstractMapStore {
    private String updateFkStmt;
    private String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;
    private final int ownerFieldNumber;
    protected final ClassLoaderResolver clr;
    protected int keyFieldNumber = -1;
    private int valueFieldNumber = -1;

    public RDBMSFKMapStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr);
        this.clr = clr;
        this.setOwner(mmd, clr);
        MapMetaData mapmd = (MapMetaData)mmd.getContainer();
        if (mapmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056002", (Object)mmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (mmd.getValueMetaData() != null && mmd.getValueMetaData().getMappedBy() == null) {
            throw new NucleusUserException(LOCALISER.msg("056071", (Object)mmd.getFullFieldName()));
        }
        this.keyType = mapmd.getKeyType();
        this.valueType = mapmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = this.getStoreManager().getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new NucleusUserException(LOCALISER.msg("056072", (Object)mmd.getFullFieldName(), (Object)this.valueType));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new NucleusUserException(LOCALISER.msg("056073", (Object)mmd.getFullFieldName(), (Object)this.keyType));
        }
        String ownerFieldName = mmd.getMappedBy();
        if (keyStoredInValue) {
            this.vmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056070", (Object)this.valueType, (Object)mmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIdMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (mmd.getMappedBy() != null) {
                AbstractMemberMetaData vofmd = this.vmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)mmd.getFullFieldName(), (Object)ownerFieldName, (Object)valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)mmd.getFullFieldName(), (Object)vofmd.getFullFieldName(), (Object)vofmd.getTypeName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.valueType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.valueType, (Object)vofmd.getTypeName(), (Object)mmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(mmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.valueType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((mmd.getKeyMetaData() == null || mmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056050", (Object)valueClass.getName()));
            }
            String key_field_name = mmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForMember(valueClass, clr, key_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056052", (Object)valueClass.getName(), (Object)key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056050", (Object)mmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.keyType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(LOCALISER.msg("056051", (Object)mmd.getFullFieldName(), (Object)this.keyType, (Object)vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = this.valueTable.getMemberMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056053", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.valueType, (Object)keyFieldName));
            }
            if (!this.keyMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map key field: " + mmd.getFullFieldName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
            if (mmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        } else {
            this.kmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056069", (Object)this.keyType, (Object)mmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIdMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (mmd.getMappedBy() != null) {
                AbstractMemberMetaData kofmd = this.kmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)mmd.getFullFieldName(), (Object)ownerFieldName, (Object)keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible((Class)kofmd.getType(), (String)mmd.getAbstractClassMetaData().getFullClassName(), (ClassLoaderResolver)clr)) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)mmd.getFullFieldName(), (Object)kofmd.getFullFieldName(), (Object)kofmd.getTypeName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getMemberMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.keyType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.keyType, (Object)kofmd.getTypeName(), (Object)mmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(mmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.keyType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((mmd.getValueMetaData() == null || mmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056057", (Object)keyClass.getName()));
            }
            String value_field_name = mmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForMember(keyClass, clr, value_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056059", (Object)keyClass.getName(), (Object)value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056057", (Object)mmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.valueType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(LOCALISER.msg("056058", (Object)mmd.getFullFieldName(), (Object)this.valueType, (Object)vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = this.valueTable.getMemberMapping(this.kmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056054", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.keyType, (Object)valueFieldName));
            }
            if (!this.valueMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map value field: " + mmd.getFullFieldName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
            if (mmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        }
        this.initialise();
    }

    @Override
    protected void initialise() {
        super.initialise();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private boolean updateValueFk(ObjectProvider sm, Object value, Object owner) {
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        return this.updateValueFkInternal(sm, value, owner);
    }

    private boolean updateKeyFk(ObjectProvider sm, Object key, Object owner) {
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        return this.updateKeyFkInternal(sm, key, owner);
    }

    @Override
    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("056063"));
        }
        super.validateValueType(clr, value);
    }

    public Object put(final ObjectProvider sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getExecutionContext().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getExecutionContext().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null && !oldValue.equals(newValue)) {
                    this.removeValue(sm, newKey, oldValue);
                }
                ExecutionContext ec = sm.getExecutionContext();
                final Object newOwner = sm.getObject();
                if (ec.getApiAdapter().isPersistent(newValue)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newValue)) {
                        throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValueInvalidWithDifferentPM"), ec.getApiAdapter().getIdForObject(newValue));
                    }
                    ObjectProvider vsm = ec.findObjectProvider(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        ec.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                    ec.getApiAdapter().isLoaded(vsm, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.replaceFieldMakeDirty(this.keyFieldNumber, newKey);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, oldKey, newKey);
                    }
                } else {
                    ec.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (RDBMSFKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(RDBMSFKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(RDBMSFKMapStore.this.keyFieldNumber, newKey);
                            JavaTypeMapping externalFKMapping = RDBMSFKMapStore.this.valueTable.getExternalMapping(RDBMSFKMapStore.this.ownerMemberMetaData, 5);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue((Object)externalFKMapping, sm.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            } else {
                ExecutionContext ec = sm.getExecutionContext();
                final Object newOwner = sm.getObject();
                if (ec.getApiAdapter().isPersistent(newKey)) {
                    if (ec != ec.getApiAdapter().getExecutionContext(newKey)) {
                        throw new NucleusUserException(LOCALISER.msg("056060"), ec.getApiAdapter().getIdForObject(newKey));
                    }
                    ObjectProvider vsm = ec.findObjectProvider(newKey);
                    if (this.ownerFieldNumber >= 0) {
                        ec.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, newOwner);
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, newOwner);
                        }
                    } else {
                        this.updateKeyFk(sm, newKey, newOwner);
                    }
                    ec.getApiAdapter().isLoaded(vsm, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.replaceFieldMakeDirty(this.valueFieldNumber, newValue);
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(vsm).relationChange(this.valueFieldNumber, oldValue, newValue);
                    }
                } else {
                    final Object newValueObj = newValue;
                    ec.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(ObjectProvider vsm) {
                            if (RDBMSFKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceFieldMakeDirty(RDBMSFKMapStore.this.ownerFieldNumber, newOwner);
                            }
                            vsm.replaceFieldMakeDirty(RDBMSFKMapStore.this.valueFieldNumber, newValueObj);
                            JavaTypeMapping externalFKMapping = RDBMSFKMapStore.this.valueTable.getExternalMapping(RDBMSFKMapStore.this.ownerMemberMetaData, 5);
                            if (externalFKMapping != null) {
                                vsm.setAssociatedValue((Object)externalFKMapping, sm.getObject());
                            }
                        }

                        public void fetchNonLoadedFields(ObjectProvider sm2) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, 0);
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(ObjectProvider sm, Object key) {
        Object oldValue = this.get(sm, key);
        ExecutionContext ec = sm.getExecutionContext();
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                boolean deletingValue = false;
                ObjectProvider vsm = ec.findObjectProvider(oldValue);
                if (this.ownerMemberMetaData.getMap().isDependentValue()) {
                    deletingValue = true;
                    ec.deleteObjectInternal(oldValue);
                } else if (this.ownerMapping.isNullable()) {
                    if (this.ownerFieldNumber >= 0) {
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                        vsm.flush();
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, null);
                        }
                    } else {
                        this.updateValueFkInternal(sm, oldValue, null);
                    }
                } else {
                    deletingValue = true;
                    ec.deleteObjectInternal(oldValue);
                }
                if (this.ownerMemberMetaData.getMap().isDependentKey()) {
                    if (!deletingValue && this.keyMapping.isNullable()) {
                        vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
                        vsm.flush();
                        if (ec.getManageRelations()) {
                            ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
                        }
                    }
                    sm.getExecutionContext().deleteObjectInternal(key);
                }
            }
        } else if (key != null) {
            boolean deletingKey = false;
            ObjectProvider ksm = ec.findObjectProvider(key);
            if (this.ownerMemberMetaData.getMap().isDependentKey()) {
                deletingKey = true;
                ec.deleteObjectInternal(key);
            } else if (this.ownerMapping.isNullable()) {
                if (this.ownerFieldNumber >= 0) {
                    Object oldOwner = ksm.provideField(this.ownerFieldNumber);
                    ksm.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                    ksm.flush();
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(ksm).relationChange(this.ownerFieldNumber, oldOwner, null);
                    }
                } else {
                    this.updateKeyFkInternal(sm, key, null);
                }
            } else {
                deletingKey = true;
                ec.deleteObjectInternal(key);
            }
            if (this.ownerMemberMetaData.getMap().isDependentValue()) {
                if (!deletingKey && this.valueMapping.isNullable()) {
                    ksm.replaceFieldMakeDirty(this.valueFieldNumber, null);
                    ksm.flush();
                    if (ec.getManageRelations()) {
                        ec.getRelationshipManager(ksm).relationChange(this.valueFieldNumber, oldValue, null);
                    }
                }
                sm.getExecutionContext().deleteObjectInternal(oldValue);
            }
        }
        return oldValue;
    }

    private void removeValue(ObjectProvider sm, Object key, Object oldValue) {
        ExecutionContext ec = sm.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
            if (ec.getManageRelations()) {
                ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
            }
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.replaceFieldMakeDirty(this.ownerFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.ownerFieldNumber, oldOwner, null);
                }
            } else {
                this.updateValueFk(sm, oldValue, null);
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public void clear(ObjectProvider sm) {
        Iterator iter = this.keySetStore().iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(ObjectProvider sm, Object key, Object oldValue) {
        ExecutionContext ec = sm.getExecutionContext();
        if (this.keyMapping.isNullable()) {
            ObjectProvider vsm = ec.findObjectProvider(oldValue);
            if (!ec.getApiAdapter().isDeleted(oldValue)) {
                vsm.replaceFieldMakeDirty(this.keyFieldNumber, null);
                if (ec.getManageRelations()) {
                    ec.getRelationshipManager(vsm).relationChange(this.keyFieldNumber, key, null);
                }
            }
        } else {
            ec.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore() {
        return new RDBMSMapKeySetStore((DatastoreContainerObject)this.valueTable, this, this.clr, this.ownerMapping, this.keyMapping, this.ownerMemberMetaData);
    }

    public synchronized SetStore valueSetStore() {
        return new RDBMSMapValueSetStore(this.valueTable, this, this.clr, this.ownerMapping, this.valueMapping, this.ownerMemberMetaData);
    }

    public synchronized SetStore entrySetStore() {
        return new RDBMSMapEntrySetStore((DatastoreContainerObject)this.valueTable, this, this.clr, this.ownerMapping, this.keyMapping, this.valueMapping, this.ownerMemberMetaData);
    }

    private String getUpdateFkStmt() {
        StringBuffer stmt = new StringBuffer("UPDATE ");
        stmt.append(this.getMapTable().toString());
        stmt.append(" SET ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.valueMapping, null, true);
        } else {
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, true);
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateValueFkInternal(ObjectProvider sm, Object value, Object owner) {
        boolean retval;
        ExecutionContext ec = sm.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateKeyFkInternal(ObjectProvider sm, Object key, Object owner) {
        boolean retval;
        ExecutionContext ec = sm.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    }
                    jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getValue(ObjectProvider ownerSM, Object key) throws NoSuchElementException {
        Transaction tx;
        if (!this.validateKeyForReading(ownerSM, key)) {
            return null;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (this.getStmtLocked == null) {
            RDBMSFKMapStore rDBMSFKMapStore = this;
            synchronized (rDBMSFKMapStore) {
                SQLStatement sqlStmt = this.getSQLStatementForGet(ownerSM);
                this.getStmtUnlocked = sqlStmt.getSelectStatement().toSQL();
                sqlStmt.addExtension("lock-for-update", true);
                this.getStmtLocked = sqlStmt.getSelectStatement().toSQL();
            }
        }
        String stmt = (tx = ec.getTransaction()).lockReadObjects() ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(ec, (Object)ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerSM.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(ec, (Object)ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreMappings()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerMemberMetaData().getAbsoluteFieldNumber();
                                value = this.valueMapping.getObject(ec, (Object)rs, param, ownerSM, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(ec, (Object)rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreMappings()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(ec, (Object)rs, param);
                        } else {
                            ResultObjectFactory rof = this.storeMgr.newResultObjectFactory(this.vmd, this.getMappingDef, false, null, this.clr.classForName(this.valueType));
                            value = rof.getObject(ec, (Object)rs);
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056014", (Object)stmt), (Throwable)e);
        }
        return value;
    }

    protected SQLStatement getSQLStatementForGet(ObjectProvider ownerSM) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        if (this.ownerMemberMetaData.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            this.getMappingDef = new StatementClassMapping();
            if (this.valueTable.getDiscriminatorMetaData() != null && this.valueTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
                if (ClassUtils.isReferenceType((Class)valueCls)) {
                    String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(this.valueType, clr);
                    Class[] cls = new Class[clsNames.length];
                    for (int i = 0; i < clsNames.length; ++i) {
                        cls[i] = clr.classForName(clsNames[i]);
                    }
                    sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null).getStatement();
                } else {
                    sqlStmt = new DiscriminatorStatementGenerator(this.storeMgr, clr, valueCls, true, null, null).getStatement();
                }
                this.iterateUsingDiscriminator = true;
            } else {
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                this.getMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
                sqlStmt = stmtGen.getStatement();
            }
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.vmd, 0);
        } else {
            sqlStmt = new SQLStatement(this.storeMgr, this.mapTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            if (this.vmd != null) {
                SQLTable valueSqlTbl = sqlStmt.leftOuterJoin(sqlStmt.getPrimaryTable(), this.valueMapping, (DatastoreContainerObject)this.valueTable, null, this.valueTable.getIdMapping(), null, null);
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getExecutionContext().getFetchPlan(), valueSqlTbl, this.vmd, 0);
            } else {
                sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
            }
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < ownerPositions.length; ++k) {
                    ownerPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(ownerPositions);
                int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < keyPositions.length; ++k) {
                    keyPositions[k] = inputParamNum++;
                }
                keyIdx.addParameterOccurrence(keyPositions);
            }
        } else {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }
}

