/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.Transaction;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class RDBMSJoinMapStore
extends AbstractMapStore {
    private String putStmt;
    private String updateStmt;
    private String removeStmt;
    private String clearStmt;
    private String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    protected final JavaTypeMapping adapterMapping;
    protected ClassLoaderResolver clr;

    public RDBMSJoinMapStore(MapTable mapTable, ClassLoaderResolver clr) {
        super((RDBMSStoreManager)mapTable.getStoreManager());
        this.clr = clr;
        this.mapTable = mapTable;
        this.setOwner(mapTable.getOwnerMemberMetaData(), clr);
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.adapterMapping = mapTable.getOrderMapping();
        this.keyType = mapTable.getKeyType();
        this.keysAreEmbedded = mapTable.isEmbeddedKey();
        this.keysAreSerialised = mapTable.isSerialisedKey();
        this.valueType = mapTable.getValueType();
        this.valuesAreEmbedded = mapTable.isEmbeddedValue();
        this.valuesAreSerialised = mapTable.isSerialisedValue();
        Class key_class = clr.classForName(this.keyType);
        this.kmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(key_class, clr);
        Class value_class = clr.classForName(this.valueType);
        if (ClassUtils.isReferenceType((Class)value_class)) {
            NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("056066", (Object)value_class.getName()));
            this.vmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(value_class, null, clr);
            if (this.vmd != null) {
                this.valueType = value_class.getName();
                this.valueTable = this.storeMgr.getDatastoreClass(this.vmd.getFullClassName(), clr);
            }
        } else {
            this.vmd = this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(value_class, clr);
            if (this.vmd != null) {
                this.valueType = this.vmd.getFullClassName();
                this.valueTable = this.valuesAreEmbedded ? null : this.storeMgr.getDatastoreClass(this.valueType, clr);
            }
        }
        this.initialise();
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(ObjectProvider sm, Map m) {
        Map.Entry entry;
        Iterator iter;
        ManagedConnection mconn;
        ExecutionContext ec;
        if (m == null || m.size() == 0) {
            return;
        }
        HashSet puts = new HashSet();
        HashSet updates = new HashSet();
        for (Map.Entry e : m.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            this.validateKeyForWriting(sm, key);
            this.validateValueForWriting(sm, value);
            try {
                Object oldValue = this.getValue(sm, key);
                if (oldValue == value) continue;
                updates.add(e);
            }
            catch (NoSuchElementException nsee) {
                puts.add(e);
            }
        }
        boolean batched = this.allowsBatching();
        if (puts.size() > 0) {
            try {
                ec = sm.getExecutionContext();
                mconn = this.storeMgr.getConnection(ec);
                try {
                    iter = puts.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalPut(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)e.getMessage()), (Throwable)e);
            }
        }
        if (updates.size() > 0) {
            try {
                ec = sm.getExecutionContext();
                mconn = this.storeMgr.getConnection(ec);
                try {
                    iter = updates.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalUpdate(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException mde) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)mde.getMessage()), (Throwable)mde);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(ObjectProvider sm, Object key, Object value) {
        MapMetaData mapmd;
        Object oldValue;
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        boolean exists = false;
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        if (oldValue != value) {
            try {
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    if (exists) {
                        this.internalUpdate(sm, mconn, false, key, value, true);
                    } else {
                        this.internalPut(sm, mconn, false, key, value, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)e.getMessage()), (Throwable)e);
            }
        }
        if ((mapmd = this.ownerMemberMetaData.getMap()).isDependentValue() && !mapmd.isEmbeddedValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getExecutionContext().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(ObjectProvider sm, Object key) {
        boolean exists;
        Object oldValue;
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        ExecutionContext ec = sm.getExecutionContext();
        if (exists) {
            this.removeInternal(sm, key);
        }
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        ApiAdapter api = ec.getApiAdapter();
        if (mapmd.isDependentKey() && !mapmd.isEmbeddedKey() && api.isPersistable(key)) {
            ec.deleteObjectInternal(key);
        }
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && api.isPersistable(oldValue) && !this.containsValue(sm, oldValue)) {
            ec.deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public void clear(ObjectProvider ownerSM) {
        HashSet<Object> dependentElements = null;
        if (this.ownerMemberMetaData.getMap().isDependentKey() || this.ownerMemberMetaData.getMap().isDependentValue()) {
            dependentElements = new HashSet<Object>();
            ApiAdapter api = ownerSM.getExecutionContext().getApiAdapter();
            Iterator iter = this.entrySetStore().iterator(ownerSM);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                MapMetaData mapmd = this.ownerMemberMetaData.getMap();
                if (api.isPersistable(entry.getKey()) && mapmd.isDependentKey() && !mapmd.isEmbeddedKey()) {
                    dependentElements.add(entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || !mapmd.isDependentValue() || mapmd.isEmbeddedValue()) continue;
                dependentElements.add(entry.getValue());
            }
        }
        this.clearInternal(ownerSM);
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getExecutionContext().deleteObjects(dependentElements.toArray());
        }
    }

    public synchronized SetStore keySetStore() {
        if (this.keySetStore == null) {
            this.keySetStore = this.newMapKeySetStore();
        }
        return this.keySetStore;
    }

    public synchronized SetStore valueSetStore() {
        if (this.valueSetStore == null) {
            this.valueSetStore = this.newMapValueSetStore();
        }
        return this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        if (this.entrySetStore == null) {
            this.entrySetStore = this.newMapEntrySetStore();
        }
        return this.entrySetStore;
    }

    public JavaTypeMapping getAdapterMapping() {
        return this.adapterMapping;
    }

    private String getPutStmt() {
        int i;
        StringBuffer stmt = new StringBuffer("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(this.adapterMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(",");
            stmt.append(this.keyMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((RDBMSMapping)this.valueMapping.getDatastoreMapping(i)).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreMappings(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.adapterMapping.getDatastoreMapping(i)).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.keyMapping.getDatastoreMapping(i)).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        StringBuffer stmt = new StringBuffer("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < this.valueMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.valueMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, false);
        return stmt.toString();
    }

    private String getRemoveStmt() {
        StringBuffer stmt = new StringBuffer("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.keyMapping, null, false);
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuffer stmt = new StringBuffer("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getValue(ObjectProvider ownerSM, Object key) throws NoSuchElementException {
        Transaction tx;
        if (!this.validateKeyForReading(ownerSM, key)) {
            return null;
        }
        ExecutionContext ec = ownerSM.getExecutionContext();
        if (this.getStmtLocked == null) {
            RDBMSJoinMapStore rDBMSJoinMapStore = this;
            synchronized (rDBMSJoinMapStore) {
                SQLStatement sqlStmt = this.getSQLStatementForGet(ownerSM);
                this.getStmtUnlocked = sqlStmt.getSelectStatement().toSQL();
                sqlStmt.addExtension("lock-for-update", true);
                this.getStmtLocked = sqlStmt.getSelectStatement().toSQL();
            }
        }
        String stmt = (tx = ec.getTransaction()).lockReadObjects() ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(ec, (Object)ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerSM.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(ec, (Object)ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreMappings()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerMemberMetaData().getAbsoluteFieldNumber();
                                value = this.valueMapping.getObject(ec, (Object)rs, param, ownerSM, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(ec, (Object)rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreMappings()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(ec, (Object)rs, param);
                        } else {
                            ResultObjectFactory rof = this.storeMgr.newResultObjectFactory(this.vmd, this.getMappingDef, false, null, this.clr.classForName(this.valueType));
                            value = rof.getObject(ec, (Object)rs);
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056014", (Object)stmt), (Throwable)e);
        }
        return value;
    }

    protected SQLStatement getSQLStatementForGet(ObjectProvider ownerSM) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            sqlStmt = new SQLStatement(this.storeMgr, this.mapTable, null, null);
            sqlStmt.setClassLoaderResolver(clr);
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
        } else {
            this.getMappingDef = new StatementClassMapping();
            UnionStatementGenerator stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null, this.mapTable, null, this.valueMapping);
            stmtGen.setOption("selectNucleusType");
            this.getMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
            sqlStmt = stmtGen.getStatement();
            SQLTable valueSqlTbl = sqlStmt.getTable((DatastoreContainerObject)this.valueTable, sqlStmt.getPrimaryTable().getGroupName());
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getExecutionContext().getFetchPlan(), valueSqlTbl, this.vmd, 0);
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < ownerPositions.length; ++k) {
                    ownerPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(ownerPositions);
                int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < keyPositions.length; ++k) {
                    keyPositions[k] = inputParamNum++;
                }
                keyIdx.addParameterOccurrence(keyPositions);
            }
        } else {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearInternal(ObjectProvider ownerSM) {
        try {
            ExecutionContext ec = ownerSM.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                    sqlControl.executeStatementUpdate(ec, mconn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)this.clearStmt), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInternal(ObjectProvider sm, Object key) {
        ExecutionContext ec = sm.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.removeStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(ec, mconn, this.removeStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)this.removeStmt), (Throwable)e);
        }
    }

    protected SetStore newMapKeySetStore() {
        return new RDBMSMapKeySetStore((MapTable)this.mapTable, this, this.clr);
    }

    protected SetStore newMapValueSetStore() {
        return new RDBMSMapValueSetStore((MapTable)this.mapTable, this, this.clr);
    }

    protected SetStore newMapEntrySetStore() {
        return new RDBMSMapEntrySetStore((MapTable)this.mapTable, this, this.clr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(ObjectProvider ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, false);
            try {
                int jdbcPosition = 1;
                jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, this);
                jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
                jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
                if (batched) {
                    ps.addBatch();
                } else {
                    sqlControl.executeStatementUpdate(ec, conn, this.updateStmt, ps, true);
                }
            }
            finally {
                sqlControl.closeStatement(conn, ps);
            }
        }
        catch (SQLException e) {
            throw new MappedDatastoreException(this.getUpdateStmt(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(ObjectProvider ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? BackingStoreHelper.populateValueInStatement(ec, ps, value, jdbcPosition, this.valueMapping) : BackingStoreHelper.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable, this);
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, this);
            if (this.adapterMapping != null) {
                long nextIDAdapter = this.getNextIDForAdapterColumn(ownerSM);
                this.adapterMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)this.adapterMapping), (Object)nextIDAdapter);
                jdbcPosition += this.adapterMapping.getNumberOfDatastoreMappings();
            }
            jdbcPosition = BackingStoreHelper.populateKeyInStatement(ec, ps, key, jdbcPosition, this.keyMapping);
            nArray = sqlControl.executeStatementUpdate(ec, conn, this.putStmt, ps, true);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException(this.getPutStmt(), (Throwable)e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(ObjectProvider sm) {
        int nextID;
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, this);
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)this.getMaxAdapterColumnIdStmt()), (Throwable)e);
        }
        return nextID;
    }

    private String getMaxAdapterColumnIdStmt() {
        StringBuffer stmt = new StringBuffer("SELECT MAX(" + this.adapterMapping.getDatastoreMapping(0).getDatastoreField().getIdentifier().toString() + ")");
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        return stmt.toString();
    }
}

