/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.StringTokenizer;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.DatastoreFieldDefinitionException;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.exceptions.IncompatibleDataTypeException;
import org.datanucleus.store.rdbms.exceptions.WrongPrecisionException;
import org.datanucleus.store.rdbms.exceptions.WrongScaleException;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ColumnImpl
implements Column {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private static final byte PK = 1;
    private static final byte NULLABLE = 2;
    private static final byte UNIQUE = 4;
    private static final byte DEFAULTABLE = 8;
    private static final byte IDENTITY = 16;
    protected DatastoreIdentifier identifier;
    protected ColumnMetaData columnMetaData;
    protected final DatastoreContainerObject table;
    protected DatastoreMapping datastoreMapping = null;
    protected final String storedJavaType;
    protected SQLTypeInfo typeInfo;
    protected String constraints;
    protected byte flags;
    protected Object defaultValue;
    protected String[] wrapperFunction;

    public ColumnImpl(DatastoreContainerObject table, String javaType, DatastoreIdentifier identifier, ColumnMetaData colmd) {
        this.table = table;
        this.storedJavaType = javaType;
        this.typeInfo = null;
        this.constraints = null;
        this.flags = 0;
        this.setIdentifier(identifier);
        this.columnMetaData = colmd == null ? new ColumnMetaData() : colmd;
        if (this.columnMetaData.getAllowsNull() != null && this.columnMetaData.isAllowsNull()) {
            this.setNullable();
        }
        if (this.columnMetaData.getUnique()) {
            this.setUnique();
        }
        this.wrapperFunction = new String[3];
        this.wrapperFunction[0] = "?";
        this.wrapperFunction[1] = "?";
        this.wrapperFunction[2] = "?";
    }

    @Override
    public boolean isUnlimitedLength() {
        if (this.columnMetaData.getJdbcType() != null && this.columnMetaData.getJdbcType().toLowerCase().indexOf("lob") > 0) {
            return true;
        }
        return this.columnMetaData.getSqlType() != null && this.columnMetaData.getSqlType().toLowerCase().indexOf("lob") > 0;
    }

    public DatastoreIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(DatastoreIdentifier identifier) {
        this.identifier = identifier;
    }

    public DatastoreContainerObject getDatastoreContainerObject() {
        return this.table;
    }

    public DatastoreMapping getDatastoreMapping() {
        return this.datastoreMapping;
    }

    public void setDatastoreMapping(DatastoreMapping mapping) {
        this.datastoreMapping = mapping;
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.datastoreMapping.getJavaTypeMapping();
    }

    public String getStoredJavaType() {
        return this.storedJavaType;
    }

    @Override
    public final SQLTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public int getJdbcType() {
        return this.typeInfo.getDataType();
    }

    public MappedStoreManager getStoreManager() {
        return this.table.getStoreManager();
    }

    private int getSQLPrecision() {
        int ulpv;
        int sqlPrecision = -1;
        if (this.columnMetaData.getLength() != null && this.columnMetaData.getLength() > 0) {
            sqlPrecision = this.columnMetaData.getLength();
        } else if (this.isUnlimitedLength() && (ulpv = ((RDBMSAdapter)this.getStoreManager().getDatastoreAdapter()).getUnlimitedLengthPrecisionValue(this.typeInfo)) > 0) {
            sqlPrecision = ulpv;
        }
        if (this.typeInfo.getTypeName().toLowerCase().startsWith("bit")) {
            return sqlPrecision * 8;
        }
        return sqlPrecision;
    }

    @Override
    public String getSQLDefinition() {
        StringBuffer def = new StringBuffer(this.identifier.toString());
        if (!StringUtils.isWhitespace((String)this.columnMetaData.getColumnDdl())) {
            def.append(" ").append(this.columnMetaData.getColumnDdl());
            return def.toString();
        }
        StringBuffer typeSpec = new StringBuffer(this.typeInfo.getTypeName());
        RDBMSAdapter adapter = (RDBMSAdapter)this.getStoreManager().getDatastoreAdapter();
        boolean specifyType = true;
        if (adapter.supportsOption("IdentityColumns") && this.isIdentity() && !adapter.supportsOption("AutoIncrementColumnTypeSpecification")) {
            specifyType = false;
        }
        if (specifyType) {
            if (this.typeInfo.getCreateParams() != null && this.typeInfo.getCreateParams().indexOf(40) >= 0 && this.typeInfo.getTypeName().indexOf(40) < 0) {
                StringTokenizer toks = new StringTokenizer(this.typeInfo.getCreateParams());
                while (toks.hasMoreTokens()) {
                    String tok = toks.nextToken();
                    if (tok.startsWith("[") && tok.endsWith("]")) continue;
                    typeSpec.append(" " + tok);
                }
            }
            StringBuffer precSpec = new StringBuffer();
            int sqlPrecision = this.getSQLPrecision();
            if (sqlPrecision > 0 && this.typeInfo.isAllowsPrecisionSpec()) {
                precSpec.append(sqlPrecision);
                if (this.columnMetaData.getScale() != null) {
                    precSpec.append("," + this.columnMetaData.getScale());
                }
            } else if (sqlPrecision > 0 && !this.typeInfo.isAllowsPrecisionSpec()) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)LOCALISER.msg("020183", (Object)this.toString()));
            }
            int lParenIdx = typeSpec.toString().indexOf(40);
            int rParenIdx = typeSpec.toString().indexOf(41, lParenIdx);
            if (lParenIdx > 0 && rParenIdx > 0) {
                if (precSpec.length() > 0) {
                    typeSpec.replace(lParenIdx + 1, rParenIdx, precSpec.toString());
                } else if (rParenIdx == lParenIdx + 1) {
                    throw new DatastoreFieldDefinitionException(LOCALISER.msg("020184", (Object)this.toString()));
                }
            } else if (precSpec.length() > 0) {
                typeSpec.append('(');
                typeSpec.append(precSpec.toString());
                typeSpec.append(')');
            }
            def.append(" " + typeSpec.toString());
        }
        if (adapter.supportsOption("ColumnOptions_DefaultBeforeNull") && adapter.supportsOption("ColumnOptions_DefaultKeyword") && this.columnMetaData.getDefaultValue() != null) {
            def.append(" ").append(this.getDefaultDefinition());
        }
        if (this.isIdentity() && this.isPrimaryKey() && adapter.supportsOption("AutoIncrementPkInCreateTableColumnDef")) {
            def.append(" PRIMARY KEY");
        }
        if (!adapter.supportsOption("IdentityColumns") || !this.isIdentity() || adapter.supportsOption("AutoIncrementNullSpecification")) {
            if (!this.isNullable()) {
                if (this.columnMetaData.getDefaultValue() == null || adapter.supportsOption("ColumnOptions_DefaultWithNotNull")) {
                    def.append(" NOT NULL");
                }
            } else if (this.typeInfo.getNullable() == 1 && adapter.supportsOption("ColumnOptions_NullsKeyword")) {
                def.append(" NULL");
            }
        }
        if (!adapter.supportsOption("ColumnOptions_DefaultBeforeNull") && adapter.supportsOption("ColumnOptions_DefaultKeyword") && this.columnMetaData.getDefaultValue() != null) {
            def.append(" ").append(this.getDefaultDefinition());
        }
        if (adapter.supportsOption("CheckInCreateStatements") && this.constraints != null) {
            def.append(" " + this.constraints.toString());
        }
        if (adapter.supportsOption("IdentityColumns") && this.isIdentity()) {
            def.append(" " + adapter.getAutoIncrementKeyword());
        }
        if (this.isUnique() && !adapter.supportsOption("UniqueInEndCreateStatements")) {
            def.append(" UNIQUE");
        }
        return def.toString();
    }

    private String getDefaultDefinition() {
        if (this.columnMetaData.getDefaultValue().equalsIgnoreCase("#NULL")) {
            return "DEFAULT NULL";
        }
        if (this.typeInfo.getTypeName().toUpperCase().indexOf("CHAR") >= 0 || this.typeInfo.getTypeName().toUpperCase().indexOf("LOB") >= 0) {
            return "DEFAULT '" + this.columnMetaData.getDefaultValue() + "'";
        }
        if (this.typeInfo.getTypeName().toUpperCase().indexOf("BIT") == 0 && (this.columnMetaData.getDefaultValue().equalsIgnoreCase("true") || this.columnMetaData.getDefaultValue().equalsIgnoreCase("false"))) {
            return "DEFAULT '" + this.columnMetaData.getDefaultValue() + "'";
        }
        return "DEFAULT " + this.columnMetaData.getDefaultValue();
    }

    @Override
    public void initializeColumnInfoFromDatastore(RDBMSColumnInfo ci) {
        String column_default = ci.getColumnDef();
        if (column_default != null) {
            this.setDefaultValue(column_default.replace("'", "").replace("\"", "").replace(")", "").replace("(", ""));
        }
        try {
            this.setIdentity(this.getStoreManager().getDatastoreAdapter().isIdentityFieldDataType(ci.getColumnDef()));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Override
    public void validate(RDBMSColumnInfo ci) {
        if (!this.typeInfo.isCompatibleWith(ci)) {
            throw new IncompatibleDataTypeException(this, this.typeInfo.getDataType(), ci.getDataType());
        }
        if (ci.getDataType() == 1111) {
            return;
        }
        if (this.table instanceof TableImpl) {
            String actualIsNullable;
            if (this.typeInfo.isAllowsPrecisionSpec()) {
                int actualPrecision = ci.getColumnSize();
                int actualScale = ci.getDecimalDigits();
                int sqlPrecision = this.getSQLPrecision();
                if (sqlPrecision > 0 && actualPrecision > 0 && sqlPrecision != actualPrecision) {
                    if (this.columnMetaData != null && this.columnMetaData.getParent() != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
                        throw new WrongPrecisionException(this.toString(), sqlPrecision, actualPrecision, ((AbstractMemberMetaData)this.columnMetaData.getParent()).getFullFieldName());
                    }
                    throw new WrongPrecisionException(this.toString(), sqlPrecision, actualPrecision);
                }
                if (this.columnMetaData.getScale() != null && actualScale >= 0 && this.columnMetaData.getScale() != actualScale) {
                    if (this.columnMetaData.getParent() != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
                        throw new WrongScaleException(this.toString(), this.columnMetaData.getScale(), actualScale, ((AbstractMemberMetaData)this.columnMetaData.getParent()).getFullFieldName());
                    }
                    throw new WrongScaleException(this.toString(), this.columnMetaData.getScale(), actualScale);
                }
            }
            if ((actualIsNullable = ci.getIsNullable()).length() > 0) {
                switch (Character.toUpperCase(actualIsNullable.charAt(0))) {
                    case 'Y': {
                        if (this.isNullable()) break;
                        NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("020025", (Object)this));
                        break;
                    }
                    case 'N': {
                        break;
                    }
                }
            }
            try {
                if (this.isIdentity() != this.getStoreManager().getDatastoreAdapter().isIdentityFieldDataType(ci.getColumnDef())) {
                    if (this.isIdentity()) {
                        throw new NucleusException("Expected an auto increment column (" + this.getIdentifier() + ") in the database, but it is not").setFatal();
                    }
                    throw new NucleusException("According to the user metadata, the column (" + this.getIdentifier() + ") is not auto incremented, but the database says it is.").setFatal();
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Override
    public final Column setTypeInfo(SQLTypeInfo typeInfo) {
        if (this.typeInfo == null) {
            this.typeInfo = typeInfo;
        }
        return this;
    }

    @Override
    public final Column setConstraints(String constraints) {
        this.constraints = constraints;
        return this;
    }

    public final void setAsPrimaryKey() {
        this.flags = (byte)(this.flags | 1);
        this.flags = (byte)(this.flags & 0xFFFFFFFD);
    }

    public final DatastoreField setNullable() {
        this.flags = (byte)(this.flags | 2);
        return this;
    }

    public final DatastoreField setDefaultable() {
        this.flags = (byte)(this.flags | 8);
        return this;
    }

    public final DatastoreField setUnique() {
        this.flags = (byte)(this.flags | 4);
        return this;
    }

    public DatastoreField setIdentity(boolean identity) {
        this.flags = identity ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
        return this;
    }

    public final boolean isPrimaryKey() {
        return (this.flags & 1) != 0;
    }

    public final boolean isNullable() {
        return (this.flags & 2) != 0;
    }

    public final boolean isDefaultable() {
        return (this.flags & 8) != 0;
    }

    public final boolean isUnique() {
        return (this.flags & 4) != 0;
    }

    public boolean isIdentity() {
        return (this.flags & 0x10) != 0;
    }

    public String applySelectFunction(String replacementValue) {
        if (replacementValue == null) {
            return this.wrapperFunction[0];
        }
        if (this.wrapperFunction[0] != null) {
            return this.wrapperFunction[0].replace("?", replacementValue);
        }
        return replacementValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public final ColumnMetaData getColumnMetaData() {
        return this.columnMetaData;
    }

    public AbstractMemberMetaData getMemberMetaData() {
        if (this.columnMetaData != null && this.columnMetaData.getParent() instanceof AbstractMemberMetaData) {
            return (AbstractMemberMetaData)this.columnMetaData.getParent();
        }
        return null;
    }

    public void setColumnMetaData(ColumnMetaData colmd) {
        if (colmd == null) {
            return;
        }
        if (colmd.getJdbcType() != null) {
            this.columnMetaData.setJdbcType(colmd.getJdbcType());
        }
        if (colmd.getSqlType() != null) {
            this.columnMetaData.setSqlType(colmd.getSqlType());
        }
        if (colmd.getName() != null) {
            this.columnMetaData.setName(colmd.getName());
        }
        if (colmd.getAllowsNull() != null) {
            this.columnMetaData.setAllowsNull(Boolean.valueOf(colmd.isAllowsNull()));
        }
        if (colmd.getLength() != null) {
            this.columnMetaData.setLength(colmd.getLength());
        }
        if (colmd.getScale() != null) {
            this.columnMetaData.setScale(colmd.getScale());
        }
        if (colmd.getAllowsNull() != null && colmd.isAllowsNull()) {
            this.setNullable();
        }
        if (colmd.getUnique()) {
            this.setUnique();
        }
    }

    @Override
    public String getConstraints() {
        return this.constraints;
    }

    @Override
    public final void checkPrimitive() throws DatastoreFieldDefinitionException {
    }

    @Override
    public final void checkInteger() throws DatastoreFieldDefinitionException {
    }

    @Override
    public final void checkDecimal() throws DatastoreFieldDefinitionException {
    }

    @Override
    public final void checkString() throws DatastoreFieldDefinitionException {
        if (this.columnMetaData.getJdbcType() == null) {
            this.columnMetaData.setJdbcType("VARCHAR");
        }
        if (this.columnMetaData.getLength() == null) {
            this.columnMetaData.setLength(Integer.valueOf(this.getStoreManager().getIntProperty("datanucleus.rdbms.stringDefaultLength")));
        }
    }

    public void copyConfigurationTo(DatastoreField field) {
        ColumnImpl col = (ColumnImpl)field;
        col.typeInfo = this.typeInfo;
        col.flags = (byte)(col.flags | this.flags);
        col.flags = (byte)(col.flags & 0xFFFFFFFE);
        col.flags = (byte)(col.flags & 0xFFFFFFFB);
        col.flags = (byte)(col.flags & 0xFFFFFFFD);
        col.flags = (byte)(col.flags & 0xFFFFFFEF);
        col.flags = (byte)(col.flags & 0xFFFFFFF7);
        col.defaultValue = this.defaultValue;
        col.wrapperFunction = this.wrapperFunction;
        if (this.columnMetaData.getJdbcType() != null) {
            col.columnMetaData.setJdbcType(this.columnMetaData.getJdbcType());
        }
        if (this.columnMetaData.getSqlType() != null) {
            col.columnMetaData.setSqlType(this.columnMetaData.getSqlType());
        }
        if (this.columnMetaData.getLength() != null) {
            col.getColumnMetaData().setLength(this.columnMetaData.getLength());
        }
        if (this.columnMetaData.getScale() != null) {
            col.getColumnMetaData().setScale(this.getColumnMetaData().getScale());
        }
    }

    @Override
    public void setWrapperFunction(String wrapperFunction, int wrapperMode) {
        if (wrapperFunction != null && wrapperMode == 0 && wrapperFunction.indexOf("?") < 0) {
            throw new NucleusUserException("Wrapping function must have one ? (question mark). e.g. SQRT(?)");
        }
        this.wrapperFunction[wrapperMode] = wrapperFunction;
    }

    @Override
    public String getWrapperFunction(int wrapperMode) {
        return this.wrapperFunction[wrapperMode];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColumnImpl)) {
            return false;
        }
        ColumnImpl col = (ColumnImpl)obj;
        return this.table.equals(col.table) && this.identifier.equals(col.identifier);
    }

    public int hashCode() {
        return this.table.hashCode() ^ this.identifier.hashCode();
    }

    public String toString() {
        return this.table.toString() + "." + this.identifier;
    }
}

