/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;

public class SQLTableAlphaNamer
implements SQLTableNamer {
    static String[] CHARS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    @Override
    public String getAliasForTable(SQLStatement stmt, DatastoreContainerObject table, String groupName) {
        SQLTableGroup tableGrp = stmt.tableGroups.get(groupName);
        String groupLetters = null;
        int numTablesInGroup = 0;
        if (tableGrp == null || tableGrp.getNumberOfTables() == 0) {
            int number = stmt.tableGroups.size();
            groupLetters = this.getLettersForNumber(number);
            boolean nameClashes = true;
            while (nameClashes) {
                if (stmt.primaryTable != null && stmt.primaryTable.alias.getIdentifierName().equals(groupLetters)) {
                    groupLetters = this.getLettersForNumber(++number);
                    continue;
                }
                if (stmt.tables == null) {
                    nameClashes = false;
                    continue;
                }
                if (stmt.tables.containsKey(groupLetters)) {
                    groupLetters = this.getLettersForNumber(++number);
                    continue;
                }
                if (stmt.tables.containsKey(groupLetters + "0")) {
                    groupLetters = this.getLettersForNumber(++number);
                    continue;
                }
                nameClashes = false;
            }
            numTablesInGroup = 0;
        } else {
            SQLTable refSqlTbl = tableGrp.getTables()[0];
            String baseTableAlias = refSqlTbl.getAlias().toString();
            String quote = stmt.getRDBMSManager().getDatastoreAdapter().getIdentifierQuoteString();
            int lettersStartPoint = 0;
            if (baseTableAlias.startsWith(quote)) {
                lettersStartPoint = quote.length();
            }
            int lettersLength = 1;
            if (baseTableAlias.length() > lettersStartPoint + 1 && Character.isLetter(baseTableAlias.charAt(lettersStartPoint + 1))) {
                lettersLength = 2;
            }
            groupLetters = baseTableAlias.substring(lettersStartPoint, lettersStartPoint + lettersLength);
            numTablesInGroup = tableGrp.getNumberOfTables();
            for (int i = 0; i < stmt.getNumberOfUnions(); ++i) {
                int num = stmt.unions.get(i).getTableGroup(tableGrp.getName()).getNumberOfTables();
                if (num <= numTablesInGroup) continue;
                numTablesInGroup = num;
            }
        }
        if (stmt.parent != null) {
            if (stmt.parent.parent != null) {
                if (stmt.parent.parent.parent != null) {
                    return groupLetters + numTablesInGroup + "_SUB_SUB_SUB";
                }
                return groupLetters + numTablesInGroup + "_SUB_SUB";
            }
            return groupLetters + numTablesInGroup + "_SUB";
        }
        return groupLetters + numTablesInGroup;
    }

    private String getLettersForNumber(int number) {
        String groupLetters = number >= CHARS.length ? CHARS[number / 26] + CHARS[number % 26] : CHARS[number];
        return groupLetters;
    }
}

