/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import com.mchange.v2.c3p0.DataSources;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastorePoolException;
import org.datanucleus.util.ClassUtils;

public class C3P0DataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(StoreManager storeMgr) {
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.mchange.v2.c3p0.DataSources", (String)"c3p0.jar");
        try {
            int size;
            Properties dbProps = C3P0DataSourceFactory.getPropertiesForDriver(storeMgr);
            DataSource unpooled = DataSources.unpooledDataSource((String)dbURL, (Properties)dbProps);
            Properties c3p0Props = new Properties();
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
                c3p0Props.setProperty("maxStatements", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                c3p0Props.setProperty("maxPoolSize", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
                c3p0Props.setProperty("minPoolSize", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                c3p0Props.setProperty("initialPoolSize", "" + size);
            }
            return DataSources.pooledDataSource((DataSource)unpooled, (Properties)c3p0Props);
        }
        catch (SQLException sqle) {
            throw new DatastorePoolException("c3p0", dbDriver, dbURL, sqle);
        }
    }
}

