/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;

public class SybaseAdapter
extends DatabaseAdapter {
    public SybaseAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("LockWithSelectForUpdate");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
    }

    public String getVendorID() {
        return "sybase";
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        SQLTypeInfo info = new SQLTypeInfo(rs);
        if (info.getTypeName().toLowerCase().startsWith("tinyint")) {
            return null;
        }
        if (info.getTypeName().toLowerCase().startsWith("longsysname")) {
            return null;
        }
        return info;
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT @@IDENTITY";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }
}

