/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreDataManager;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.store.rdbms.table.ViewImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class DeleteTablesSchemaTransaction
extends AbstractSchemaTransaction {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    StoreDataManager storeDataMgr = null;
    Writer writer;

    public DeleteTablesSchemaTransaction(RDBMSStoreManager rdbmsMgr, int isolationLevel, StoreDataManager dataMgr) {
        super(rdbmsMgr, isolationLevel);
        this.storeDataMgr = dataMgr;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ClassLoaderResolver clr) throws SQLException {
        RDBMSStoreManager rDBMSStoreManager = this.rdbmsMgr;
        synchronized (rDBMSStoreManager) {
            boolean success = true;
            try {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050045", (Object)this.rdbmsMgr.getCatalogName(), (Object)this.rdbmsMgr.getSchemaName()));
                HashMap<DatastoreIdentifier, DatastoreContainerObject> baseTablesByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                HashMap<DatastoreIdentifier, DatastoreContainerObject> viewsByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                for (RDBMSStoreData data : this.storeDataMgr.getManagedStoreData()) {
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("050046", (Object)data.getName()));
                    }
                    if (!data.hasTable()) continue;
                    if (data.mapsToView()) {
                        viewsByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                        continue;
                    }
                    baseTablesByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                }
                Iterator viewsIter = viewsByName.values().iterator();
                while (viewsIter.hasNext()) {
                    ViewImpl view = (ViewImpl)viewsIter.next();
                    if (this.writer != null) {
                        try {
                            if (view instanceof ClassView) {
                                this.writer.write("-- ClassView " + view.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassView)view).getManagedClasses()) + "\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    ((ViewImpl)viewsIter.next()).drop(this.getCurrentConnection());
                }
                for (TableImpl tbl : baseTablesByName.values()) {
                    if (this.writer != null) {
                        try {
                            if (tbl instanceof ClassTable) {
                                this.writer.write("-- Constraints for ClassTable " + tbl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tbl).getManagedClasses()) + "\n");
                            } else if (tbl instanceof JoinTable) {
                                this.writer.write("-- Constraints for JoinTable " + tbl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    tbl.dropConstraints(this.getCurrentConnection());
                }
                for (TableImpl tbl : baseTablesByName.values()) {
                    if (this.writer != null) {
                        try {
                            if (tbl instanceof ClassTable) {
                                this.writer.write("-- ClassTable " + tbl.toString() + " for classes " + StringUtils.objectArrayToString((Object[])((ClassTable)tbl).getManagedClasses()) + "\n");
                            } else if (tbl instanceof JoinTable) {
                                this.writer.write("-- JoinTable " + tbl.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)"error writing DDL into file", (Throwable)ioe);
                        }
                    }
                    tbl.drop(this.getCurrentConnection());
                }
            }
            catch (Exception e) {
                success = false;
                String errorMsg = LOCALISER.msg("050047", (Object)e);
                NucleusLogger.DATASTORE_SCHEMA.error((Object)errorMsg);
                throw new NucleusUserException(errorMsg, (Throwable)e);
            }
            if (!success) {
                throw new NucleusException("DeleteTables operation failed");
            }
        }
    }

    public String toString() {
        return LOCALISER.msg("050045", (Object)this.rdbmsMgr.getCatalogName(), (Object)this.rdbmsMgr.getSchemaName());
    }
}

