/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLExpressionFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    RDBMSStoreManager storeMgr;
    ClassLoaderResolver clr;
    private final Class[] EXPR_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, SQLTable.class, JavaTypeMapping.class};
    private final Class[] LIT_CREATION_ARG_TYPES = new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, String.class};
    Map<String, Class> expressionClassByMappingName = new HashMap<String, Class>();
    Map<String, Class> literalClassByMappingName = new HashMap<String, Class>();
    Map<String, String> methodClassByDatastoreMethodName = new HashMap<String, String>();
    Map<String, String> operationClassByDatastoreOperationName = new HashMap<String, String>();
    Map<String, SQLMethod> methodByClassMethodName = new HashMap<String, SQLMethod>();
    Map<String, SQLOperation> operationByOperationName = new HashMap<String, SQLOperation>();
    Map<Class, JavaTypeMapping> mappingByClass = new HashMap<Class, JavaTypeMapping>();

    public SQLExpressionFactory(RDBMSStoreManager storeMgr) {
        ConfigurationElement[] operationElems;
        String key;
        this.storeMgr = storeMgr;
        this.clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        PluginManager pluginMgr = storeMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] methodElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_method", null, null);
        if (methodElems != null) {
            for (int i = 0; i < methodElems.length; ++i) {
                String datastoreName = methodElems[i].getAttribute("datastore");
                String className = methodElems[i].getAttribute("class");
                String methodName = methodElems[i].getAttribute("method").trim();
                String sqlMethodName = methodElems[i].getAttribute("evaluator").trim();
                key = this.getSQLMethodKey(datastoreName, className, methodName);
                this.methodClassByDatastoreMethodName.put(key, sqlMethodName);
            }
        }
        if ((operationElems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.store.rdbms.sql_operation", null, null)) != null) {
            for (int i = 0; i < operationElems.length; ++i) {
                String datastoreName = operationElems[i].getAttribute("datastore");
                String name = operationElems[i].getAttribute("name").trim();
                String sqlOperationName = operationElems[i].getAttribute("evaluator").trim();
                key = this.getSQLOperationKey(datastoreName, name);
                this.operationClassByDatastoreOperationName.put(key, sqlOperationName);
            }
        }
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        return this.newExpression(stmt, sqlTbl, mapping, null);
    }

    public SQLExpression newExpression(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping, JavaTypeMapping parentMapping) {
        SQLTable exprSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sqlTbl, parentMapping == null ? mapping : parentMapping);
        Object[] args = new Object[]{stmt, exprSqlTbl, mapping};
        Class expressionClass = this.expressionClassByMappingName.get(mapping.getClass().getName());
        if (expressionClass != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)expressionClass, (Class[])this.EXPR_CREATION_ARG_TYPES, (Object[])new Object[]{stmt, exprSqlTbl, mapping});
        }
        try {
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "expression-class", this.EXPR_CREATION_ARG_TYPES, args);
            if (sqlExpr == null) {
                throw new NucleusException(LOCALISER.msg("060004", (Object)mapping.getClass().getName()));
            }
            this.expressionClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
            return sqlExpr;
        }
        catch (Exception e) {
            String msg = LOCALISER.msg("060005", (Object)mapping.getClass().getName());
            NucleusLogger.QUERY.error((Object)msg, (Throwable)e);
            throw new NucleusException(msg, (Throwable)e);
        }
    }

    public SQLExpression newLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value) {
        Class literalClass;
        Object[] args = new Object[]{stmt, mapping, value, null};
        if (mapping != null && (literalClass = this.literalClassByMappingName.get(mapping.getClass().getName())) != null) {
            return (SQLExpression)ClassUtils.newInstance((Class)literalClass, (Class[])this.LIT_CREATION_ARG_TYPES, (Object[])args);
        }
        try {
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(NullLiteral.class, (Class[])this.LIT_CREATION_ARG_TYPES, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", this.LIT_CREATION_ARG_TYPES, args);
            if (sqlExpr == null) {
                throw new NucleusException(LOCALISER.msg("060006", (Object)mapping.getClass().getName()));
            }
            this.literalClassByMappingName.put(mapping.getClass().getName(), sqlExpr.getClass());
            return sqlExpr;
        }
        catch (Exception e) {
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mapping.getClass().getName()), (Throwable)e);
            throw new NucleusException(LOCALISER.msg("060007", (Object)mapping.getClass().getName()));
        }
    }

    public SQLExpression newLiteralParameter(SQLStatement stmt, JavaTypeMapping mapping, Object value, String paramName) {
        try {
            Class[] argTypes = new Class[]{SQLStatement.class, JavaTypeMapping.class, Object.class, String.class};
            Object[] args = new Object[]{stmt, mapping, value, paramName};
            if (mapping == null) {
                return (SQLExpression)ClassUtils.newInstance(ParameterLiteral.class, (Class[])argTypes, (Object[])args);
            }
            SQLExpression sqlExpr = (SQLExpression)this.storeMgr.getNucleusContext().getPluginManager().createExecutableExtension("org.datanucleus.store.rdbms.sql_expression", "mapping-class", mapping.getClass().getName(), "literal-class", argTypes, args);
            if (sqlExpr == null) {
                throw new NucleusException(LOCALISER.msg("060006", (Object)mapping.getClass().getName()));
            }
            return sqlExpr;
        }
        catch (Exception e) {
            NucleusLogger.QUERY.error((Object)("Exception creating SQLLiteral for mapping " + mapping.getClass().getName()), (Throwable)e);
            throw new NucleusException(LOCALISER.msg("060007", (Object)mapping.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExpression invokeMethod(SQLStatement stmt, String className, String methodName, SQLExpression expr, List args) {
        String classMethodKey = className != null ? className + "_" + methodName : methodName;
        SQLMethod method = this.methodByClassMethodName.get(classMethodKey);
        if (method != null) {
            SQLMethod sQLMethod = method;
            synchronized (sQLMethod) {
                method.setStatement(stmt);
                return method.getExpression(expr, args);
            }
        }
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLMethodKey(datastoreId, className, methodName);
        String sqlMethodClassName = this.methodClassByDatastoreMethodName.get(key);
        if (sqlMethodClassName == null && (sqlMethodClassName = this.methodClassByDatastoreMethodName.get(key = this.getSQLMethodKey(null, className, methodName))) == null) {
            if (className != null) {
                throw new NucleusUserException(LOCALISER.msg("060008", (Object)methodName, (Object)className));
            }
            throw new NucleusUserException(LOCALISER.msg("060009", (Object)methodName));
        }
        try {
            SQLMethod sQLMethod = method = (SQLMethod)stmt.getClassLoaderResolver().classForName(sqlMethodClassName).newInstance();
            synchronized (sQLMethod) {
                method.setStatement(stmt);
                this.methodByClassMethodName.put(classMethodKey, method);
                return method.getExpression(expr, args);
            }
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(LOCALISER.msg("060010", (Object)sqlMethodClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusUserException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusUserException(LOCALISER.msg("060011", (Object)sqlMethodClassName), (Throwable)e);
        }
    }

    public SQLExpression invokeOperation(String name, SQLExpression expr, SQLExpression expr2) {
        SQLOperation operation = this.operationByOperationName.get(name);
        if (operation != null) {
            return operation.getExpression(expr, expr2);
        }
        String datastoreId = this.storeMgr.getDatastoreAdapter().getVendorID();
        String key = this.getSQLOperationKey(datastoreId, name);
        String sqlOperationClassName = this.operationClassByDatastoreOperationName.get(key);
        if (sqlOperationClassName == null && (sqlOperationClassName = this.operationClassByDatastoreOperationName.get(key = this.getSQLOperationKey(null, name))) == null) {
            throw new UnsupportedOperationException();
        }
        SQLStatement stmt = expr.getSQLStatement();
        try {
            operation = (SQLOperation)stmt.getClassLoaderResolver().classForName(sqlOperationClassName).newInstance();
            operation.setExpressionFactory(this);
            this.operationByOperationName.put(name, operation);
            return operation.getExpression(expr, expr2);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusException(LOCALISER.msg("060013", (Object)sqlOperationClassName));
        }
        catch (InstantiationException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusException(LOCALISER.msg("060014", (Object)sqlOperationClassName), (Throwable)e);
        }
    }

    private String getSQLMethodKey(String datastoreName, String className, String methodName) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + (className != null ? className.trim() + "." : "") + methodName;
    }

    private String getSQLOperationKey(String datastoreName, String name) {
        return (datastoreName != null ? datastoreName.trim() : "ALL") + "#" + name;
    }

    public JavaTypeMapping getMappingForType(Class cls, boolean useCached) {
        JavaTypeMapping mapping = null;
        if (useCached && (mapping = this.mappingByClass.get(cls)) != null) {
            return mapping;
        }
        mapping = this.storeMgr.getMappingManager().getMappingWithDatastoreMapping(cls, false, false, this.clr);
        this.mappingByClass.put(cls, mapping);
        return mapping;
    }
}

