/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.DatastoreDriverNotFoundException;

public abstract class AbstractDataSourceFactory {
    protected void loadDriver(String dbDriver, ClassLoaderResolver clr) {
        try {
            clr.classForName(dbDriver).newInstance();
        }
        catch (Exception e) {
            try {
                Class.forName(dbDriver).newInstance();
            }
            catch (Exception e2) {
                throw new DatastoreDriverNotFoundException(dbDriver);
            }
        }
    }

    public static Properties getPropertiesForDriver(StoreManager storeMgr) {
        Properties dbProps = new Properties();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        dbProps.setProperty("user", dbUser);
        String dbPassword = storeMgr.getConnectionPassword();
        if (dbPassword == null) {
            dbPassword = "";
        }
        dbProps.setProperty("password", dbPassword);
        PersistenceConfiguration conf = storeMgr.getNucleusContext().getPersistenceConfiguration();
        Set propNamesWithDatastore = conf.getPropertyNamesWithPrefix("datanucleus.connectionPool.driver.");
        if (propNamesWithDatastore != null) {
            for (String propName : propNamesWithDatastore) {
                String connectionPropName = propName.substring("datanucleus.connectionPool.driver.".length());
                dbProps.setProperty(connectionPropName, conf.getStringProperty(propName));
            }
        }
        return dbProps;
    }
}

