/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.datatype.ClobImpl;
import org.datanucleus.store.rdbms.mapping.LongVarcharRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;

public class ClobRDBMSMapping
extends LongVarcharRDBMSMapping {
    public ClobRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public ClobRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(2005);
    }

    public void setString(Object ps, int param, String value) {
        if (this.getDatabaseAdapter().supportsOption("ClobSetUsingSetString")) {
            super.setString(ps, param, value);
        } else {
            this.setObject(ps, param, value);
        }
    }

    public void setObject(Object ps, int param, Object value) {
        if (this.getDatabaseAdapter().supportsOption("ClobSetUsingSetString")) {
            super.setObject(ps, param, value);
        } else {
            try {
                if (value == null) {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                } else {
                    ((PreparedStatement)ps).setClob(param, new ClobImpl((String)value));
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getString(Object rs, int param) {
        if (this.getDatabaseAdapter().supportsOption("ClobSetUsingSetString")) {
            return super.getString(rs, param);
        }
        return (String)this.getObject(rs, param);
    }

    public Object getObject(Object rs, int param) {
        String value;
        if (this.getDatabaseAdapter().supportsOption("ClobSetUsingSetString")) {
            return super.getObject(rs, param);
        }
        try {
            Clob clob = ((ResultSet)rs).getClob(param);
            if (!((ResultSet)rs).wasNull()) {
                int c;
                BufferedReader br = new BufferedReader(clob.getCharacterStream());
                StringBuffer sb = new StringBuffer();
                while ((c = br.read()) != -1) {
                    sb.append((char)c);
                }
                value = sb.toString();
            } else {
                value = null;
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

