/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLStatementParameter;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLText {
    private String sql;
    private List<SQLStatementParameter> parameters = null;
    private boolean encloseInParentheses = false;
    private String postpend;
    private List appended = new ArrayList();

    public SQLText() {
    }

    public SQLText(String initialSQLText) {
        this();
        this.append(initialSQLText);
    }

    public void clearStatement() {
        this.sql = null;
        this.appended.clear();
    }

    public void encloseInParentheses() {
        this.sql = null;
        this.encloseInParentheses = true;
    }

    public SQLText postpend(String s) {
        this.sql = null;
        this.postpend = s;
        return this;
    }

    public SQLText prepend(String s) {
        this.sql = null;
        this.appended.add(0, s);
        return this;
    }

    public SQLText append(char c) {
        this.sql = null;
        this.appended.add(new Character(c));
        return this;
    }

    public SQLText append(String s) {
        this.sql = null;
        this.appended.add(s);
        return this;
    }

    public SQLText append(SQLStatement stmt) {
        this.sql = null;
        this.appended.add(stmt);
        return this;
    }

    public SQLText append(SQLText st) {
        this.sql = null;
        this.appended.add(st.toSQL());
        if (st.parameters != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList<SQLStatementParameter>();
            }
            this.parameters.addAll(st.parameters);
        }
        return this;
    }

    public SQLText append(SQLExpression expr) {
        this.sql = null;
        this.appended.add(expr);
        return this;
    }

    public SQLText appendParameter(String name, JavaTypeMapping mapping, Object value) {
        return this.appendParameter(name, mapping, value, -1);
    }

    public SQLText appendParameter(String name, JavaTypeMapping mapping, Object value, int columnNumber) {
        this.sql = null;
        this.appended.add(new SQLStatementParameter(name, mapping, value, columnNumber));
        return this;
    }

    public void changeMappingForParameter(String parameterName, JavaTypeMapping mapping) {
        for (Object obj : this.appended) {
            SQLStatementParameter param;
            if (!(obj instanceof SQLStatementParameter) || !(param = (SQLStatementParameter)obj).getName().equalsIgnoreCase(parameterName)) continue;
            param.setMapping(mapping);
        }
    }

    public void applyParametersToStatement(ExecutionContext ec, PreparedStatement ps) {
        if (this.parameters != null) {
            int num = 1;
            for (SQLStatementParameter param : this.parameters) {
                JavaTypeMapping mapping = param.getMapping();
                if (mapping == null) continue;
                Object value = param.getValue();
                if (param.getColumnNumber() >= 0) {
                    Object colValue = null;
                    if (value == null) {
                        colValue = null;
                    } else {
                        ClassLoaderResolver clr = ec.getClassLoaderResolver();
                        AbstractClassMetaData cmd = ec.getMetaDataManager().getMetaDataForClass(mapping.getType(), clr);
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            colValue = mapping.getValueForDatastoreMapping(ec.getNucleusContext(), param.getColumnNumber(), value);
                        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            colValue = SQLStatementHelper.getValueForPrimaryKeyIndexOfObjectUsingReflection(value, param.getColumnNumber(), cmd, ec.getNucleusContext(), clr);
                        }
                    }
                    mapping.getDatastoreMapping(param.getColumnNumber()).setObject((Object)ps, num, colValue);
                    ++num;
                    continue;
                }
                mapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)num, (JavaTypeMapping)mapping), value);
                if (mapping.getNumberOfDatastoreMappings() > 0) {
                    num += mapping.getNumberOfDatastoreMappings();
                    continue;
                }
                ++num;
            }
        }
    }

    public List<SQLStatementParameter> getParametersForStatement() {
        return this.parameters;
    }

    public String toSQL() {
        if (this.sql != null) {
            return this.sql;
        }
        StringBuffer sql = new StringBuffer();
        if (this.encloseInParentheses) {
            sql.append("(");
        }
        for (int i = 0; i < this.appended.size(); ++i) {
            SQLText st;
            Object item = this.appended.get(i);
            if (item instanceof SQLExpression) {
                SQLExpression expr = (SQLExpression)item;
                st = expr.toSQLText();
                sql.append(st.toSQL());
                if (st.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<SQLStatementParameter>();
                }
                this.parameters.addAll(st.parameters);
                continue;
            }
            if (item instanceof SQLStatementParameter) {
                SQLStatementParameter param = (SQLStatementParameter)item;
                sql.append('?');
                if (this.parameters == null) {
                    this.parameters = new ArrayList<SQLStatementParameter>();
                }
                this.parameters.add(param);
                continue;
            }
            if (item instanceof SQLStatement) {
                SQLStatement stmt = (SQLStatement)item;
                st = stmt.getSelectStatement();
                sql.append(st.toSQL());
                if (st.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<SQLStatementParameter>();
                }
                this.parameters.addAll(st.parameters);
                continue;
            }
            if (item instanceof SQLText) {
                SQLText st2 = (SQLText)item;
                sql.append(st2.toSQL());
                if (st2.parameters == null) continue;
                if (this.parameters == null) {
                    this.parameters = new ArrayList<SQLStatementParameter>();
                }
                this.parameters.addAll(st2.parameters);
                continue;
            }
            sql.append(item);
        }
        if (this.encloseInParentheses) {
            sql.append(")");
        }
        sql.append(this.postpend == null ? "" : this.postpend);
        this.sql = sql.toString();
        return this.sql;
    }

    public String toString() {
        return this.toSQL();
    }
}

