/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastorePoolException;
import org.datanucleus.util.ClassUtils;

public class DBCPDataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(StoreManager storeMgr) {
        int value;
        int value2;
        String dbPassword;
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        if (dbUser == null) {
            dbUser = "";
        }
        if ((dbPassword = storeMgr.getConnectionPassword()) == null) {
            dbPassword = "";
        }
        ClassLoaderResolver clr = storeMgr.getNucleusContext().getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.pool.ObjectPool", (String)"commons-pool.jar");
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"org.apache.commons.dbcp.ConnectionFactory", (String)"commons-dbcp.jar");
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
            connectionPool.setMaxIdle(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) > 0) {
            connectionPool.setMinIdle(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxActive") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxActive")) > 0) {
            connectionPool.setMaxActive(value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxWait") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.maxWait")) > 0) {
            connectionPool.setMaxWait((long)value2);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis")) > 0) {
            connectionPool.setTimeBetweenEvictionRunsMillis((long)value2);
            int maxIdle = connectionPool.getMaxIdle();
            int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
            connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
        if (storeMgr.hasProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis") && (value2 = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis")) > 0) {
            connectionPool.setMinEvictableIdleTimeMillis((long)value2);
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbUser, dbPassword);
        StackKeyedObjectPoolFactory kpf = null;
        if (storeMgr.hasProperty("datanucleus.connectionPool.maxStatements") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxStatements")) > 0) {
            kpf = new StackKeyedObjectPoolFactory(null, value);
        }
        try {
            String testSQL = null;
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                testSQL = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
            }
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, (KeyedObjectPoolFactory)kpf, testSQL, false, false);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP", dbDriver, dbURL, e);
        }
        PoolingDataSource ds = new PoolingDataSource((ObjectPool)connectionPool);
        return ds;
    }
}

