/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.datasource;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import javax.sql.DataSource;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.datasource.AbstractDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.store.rdbms.datasource.DatastorePoolException;
import org.datanucleus.util.ClassUtils;

public class C3P0DataSourceFactory
extends AbstractDataSourceFactory
implements DataNucleusDataSourceFactory {
    public DataSource makePooledDataSource(OMFContext omfCtx) {
        int size;
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        StoreManager storeMgr = omfCtx.getStoreManager();
        String dbDriver = storeMgr.getConnectionDriverName();
        String dbURL = storeMgr.getConnectionURL();
        String dbUser = storeMgr.getConnectionUserName();
        String dbPassword = storeMgr.getConnectionPassword();
        ClassLoaderResolver clr = omfCtx.getClassLoaderResolver(null);
        this.loadDriver(dbDriver, clr);
        ClassUtils.assertClassForJarExistsInClasspath((ClassLoaderResolver)clr, (String)"com.mchange.v2.c3p0.ComboPooledDataSource", (String)"c3p0.jar");
        ComboPooledDataSource ds = new ComboPooledDataSource();
        if (conf.hasProperty("datanucleus.connectionPool.maxStatements") && (size = conf.getIntProperty("datanucleus.connectionPool.maxStatements")) >= 0) {
            ds.setMaxStatements(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
            ds.setMaxPoolSize(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.minPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.minPoolSize")) >= 0) {
            ds.setMinPoolSize(size);
        }
        if (conf.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
            ds.setInitialPoolSize(size);
        }
        try {
            ds.setDriverClass(dbDriver);
        }
        catch (PropertyVetoException pve) {
            throw new DatastorePoolException("C3P0", dbDriver, dbURL, pve);
        }
        ds.setJdbcUrl(dbURL);
        ds.setUser(dbUser);
        ds.setPassword(dbPassword);
        return ds;
    }
}

