/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.DerbyTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;

public class DerbyAdapter
extends DatabaseAdapter {
    private static final String CLOUDSCAPE_RESERVED_WORDS = "ADD,ALL,ALLOCATE,ALTER,AND,ANY,ARE,AS,ASC,ASSERTION,AT,AUTHORIZATION,AVG,BEGIN,BETWEEN,BIT,BIT_LENGTH,BOOLEAN,BOTH,BY,CALL,CASCADE,CASCADED,CASE,CAST,CHAR,CHARACTER,CHARACTER_LENGTH,CHAR_LENGTH,CHECK,CLOSE,COLLATE,COLLATION,COLUMN,COMMIT,CONNECT,CONNECTION,CONSTRAINT,CONSTRAINTS,CONTINUE,CONVERT,CORRESPONDING,COUNT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DEALLOCATE,DEC,DECIMAL,DECLARE,DEFERRABLE,DEFERRED,DELETE,DESC,DESCRIBE,DIAGNOSTICS,DISCONNECT,DISTINCT,DOUBLE,DROP,ELSE,END,ENDEXEC,ESCAPE,EXCEPT,EXCEPTION,EXEC,EXECUTE,EXISTS,EXPLAIN,EXTERNAL,EXTRACT,FALSE,FETCH,FIRST,FLOAT,FOR,FOREIGN,FOUND,FROM,FULL,FUNCTION,GET,GET_CURRENT_CONNECTION,GLOBAL,GO,GOTO,GRANT,GROUP,HAVING,HOUR,IDENTITY,IMMEDIATE,IN,INDICATOR,INITIALLY,INNER,INOUT,INPUT,INSENSITIVE,INSERT,INT,INTEGER,INTERSECT,INTO,IS,ISOLATION,JOIN,KEY,LAST,LEADING,LEFT,LIKE,LOCAL,LONGINT,LOWER,LTRIM,MATCH,MAX,MIN,MINUTE,NATIONAL,NATURAL,NCHAR,NVARCHAR,NEXT,NO,NOT,NULL,NULLIF,NUMERIC,OCTET_LENGTH,OF,ON,ONLY,OPEN,OPTION,OR,ORDER,OUT,OUTER,OUTPUT,OVERLAPS,PAD,PARTIAL,PREPARE,PRESERVE,PRIMARY,PRIOR,PRIVILEGES,PROCEDURE,PUBLIC,READ,REAL,REFERENCES,RELATIVE,RESTRICT,REVOKE,RIGHT,ROLLBACK,ROWS,RTRIM,RUNTIMESTATISTICS,SCHEMA,SCROLL,SECOND,SELECT,SESSION_USER,SET,SMALLINT,SOME,SPACE,SQL,SQLCODE,SQLERROR,SQLSTATE,SUBSTR,SUBSTRING,SUM,SYSTEM_USER,TABLE,TEMPORARY,TIMEZONE_HOUR,TIMEZONE_MINUTE,TINYINT,TO,TRAILING,TRANSACTION,TRANSLATE,TRANSLATION,TRIM,TRUE,UNION,UNIQUE,UNKNOWN,UPDATE,UPPER,USER,USING,VALUES,VARCHAR,VARYING,VIEW,WHENEVER,WHERE,WITH,WORK,WRITE,YEAR";

    public DerbyAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(CLOUDSCAPE_RESERVED_WORDS));
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("NullsInCandidateKeys");
        this.supportedOptions.remove("ColumnOptions_DefaultWithNotNull");
        if (this.datastoreMajorVersion >= 10) {
            this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        } else {
            this.supportedOptions.add("ColumnOptions_NullsKeyword");
        }
        if (this.datastoreMajorVersion < 10 || this.datastoreMajorVersion == 10 && this.datastoreMinorVersion < 6) {
            this.supportedOptions.remove("ANSI_CrossJoin_Syntax");
            this.supportedOptions.add("ANSI_CrossJoinAsInner11_Syntax");
        }
    }

    public void initialiseDatastore(Object conn) {
        try {
            Statement st = ((Connection)conn).createStatement();
            try {
                st.execute("DROP FUNCTION NUCLEUS_ASCII");
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                st.execute("CREATE FUNCTION NUCLEUS_ASCII(C CHAR(1)) RETURNS INTEGER EXTERNAL NAME 'org.datanucleus.store.rdbms.adapter.DerbySQLFunction.ascii' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051027", (Object)sqle));
            }
            try {
                st.execute("DROP FUNCTION NUCLEUS_MATCHES");
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            try {
                st.execute("CREATE FUNCTION NUCLEUS_MATCHES(TEXT VARCHAR(8000), PATTERN VARCHAR(8000)) RETURNS INTEGER EXTERNAL NAME 'org.datanucleus.store.rdbms.adapter.DerbySQLFunction.matches' CALLED ON NULL INPUT LANGUAGE JAVA PARAMETER STYLE JAVA");
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051027", (Object)sqle));
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return conn.getMetaData().getUserName().toUpperCase();
    }

    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    public String getVendorID() {
        return "derby";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new DerbyTypeInfo(rs);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    public String getAutoIncrementKeyword() {
        return "generated always as identity (start with 1)";
    }

    public boolean isIdentityFieldDataType(String columnDef) {
        return columnDef != null && columnDef.toUpperCase().indexOf("AUTOINCREMENT") >= 0;
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    public String getDatastoreDateStatement() {
        return "VALUES CURRENT_TIMESTAMP";
    }

    public String getSelectForUpdateText() {
        return "WITH RR";
    }

    public boolean validToSelectMappingInStatement(SQLStatement stmt, JavaTypeMapping m) {
        if (m.getNumberOfDatastoreMappings() <= 0) {
            return true;
        }
        for (int i = 0; i < m.getNumberOfDatastoreMappings(); ++i) {
            Column col = (Column)m.getDatastoreMapping(i).getDatastoreField();
            if (col.getJdbcType() != 2005 && col.getJdbcType() != 2004) continue;
            if (stmt.isDistinct()) {
                NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using DISTINCT"));
                return false;
            }
            if (stmt.getNumberOfUnions() <= 0) continue;
            NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using UNION"));
            return false;
        }
        return true;
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public String getNumericConversionFunction() {
        return "NUCLEUS_ASCII";
    }

    public NumericExpression toNumericExpression(CharacterExpression expr) {
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            JavaTypeMapping m = this.getMapping(value.getClass(), (ScalarExpression)expr);
            return (NumericExpression)m.newLiteral(expr.getQueryExpression(), (Object)value);
        }
        if (expr instanceof Literal) {
            BigInteger value = new BigInteger((String)((Literal)expr).getValue());
            JavaTypeMapping m = this.getMapping(value.getClass(), (ScalarExpression)expr);
            return (NumericExpression)m.newLiteral(expr.getQueryExpression(), (Object)value);
        }
        ArrayList<CharacterExpression> args = new ArrayList<CharacterExpression>();
        args.add(expr);
        return new NumericExpression("NUCLEUS_ASCII", args);
    }

    public StringExpression toStringExpression(NumericExpression expr) {
        if (expr instanceof Literal) {
            JavaTypeMapping m = this.getMapping(String.class, (ScalarExpression)expr);
            return new StringLiteral(expr.getQueryExpression(), m, ((Literal)expr).getValue().toString());
        }
        ArrayList<NumericExpression> args = new ArrayList<NumericExpression>();
        args.add(expr);
        ArrayList<StringExpression> argsRTRIM = new ArrayList<StringExpression>();
        argsRTRIM.add(new StringExpression("CHAR", args));
        return new StringExpression("RTRIM", argsRTRIM);
    }

    public ScalarExpression concatOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        ArrayList<ScalarExpression> argsOp1 = new ArrayList<ScalarExpression>();
        argsOp1.add(operand1);
        ArrayList<ScalarExpression> argsOp2 = new ArrayList<ScalarExpression>();
        argsOp2.add(operand2);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(super.concatOperator((ScalarExpression)new StringExpression("CAST", argsOp1, types), (ScalarExpression)new StringExpression("CAST", argsOp2, types)));
        return new StringExpression("CAST", args, types);
    }

    public BooleanExpression matchesMethod(StringExpression text, StringExpression pattern) {
        JavaTypeMapping m = this.getMapping(BigInteger.class, (ScalarExpression)text);
        ScalarExpression integerLiteral = m.newLiteral(text.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(text);
        args.add(pattern);
        return new NumericExpression("NUCLEUS_MATCHES", args).eq(integerLiteral);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        JavaTypeMapping m = this.getMapping(BigInteger.class, source);
        ScalarExpression integerLiteral = m.newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression((ScalarExpression)new StringExpression("LOCATE", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        args.add(end.sub((ScalarExpression)begin));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression trimMethod(StringExpression str, boolean leading, boolean trailing) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        if (leading && trailing) {
            StringExpression strExpr = new StringExpression("RTRIM", args);
            args.clear();
            args.add(strExpr);
            return new StringExpression("LTRIM", args);
        }
        if (leading) {
            return new StringExpression("LTRIM", args);
        }
        if (trailing) {
            return new StringExpression("RTRIM", args);
        }
        return str;
    }
}

