/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStore;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractCollectionStoreSpecialization;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

class RDBMSAbstractSetStoreSpecialization
extends RDBMSAbstractCollectionStoreSpecialization
implements AbstractSetStoreSpecialization {
    RDBMSAbstractSetStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] internalAdd(ObjectProvider ownerSM, ManagedConnection conn, boolean batched, Object element, boolean processNow, AbstractSetStore setStore) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String addStmt = this.getAddStmt((ElementContainerStore)setStore);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, addStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)setStore);
            jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, setStore.getElementMapping());
            if (setStore.getRelationDiscriminatorMapping() != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, (ElementContainerStore)setStore);
            }
            nArray = sqlControl.executeStatementUpdate(conn, addStmt, ps, processNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException(this.getAddStmt((ElementContainerStore)setStore), (Throwable)e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ObjectProvider sm, Object element, int size, AbstractSetStore setStore) {
        boolean modified = false;
        ExecutionContext ec = sm.getExecutionContext();
        String removeStmt = this.getRemoveStmt((ElementContainerStore)setStore);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, removeStmt, false);
                try {
                    int[] rowsDeleted;
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, (BaseContainerStore)setStore);
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, setStore.getElementMapping());
                    if (setStore.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, (ElementContainerStore)setStore);
                    }
                    modified = (rowsDeleted = sqlControl.executeStatementUpdate(mconn, removeStmt, ps, true))[0] == 1;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            NucleusLogger.DATASTORE.error((Object)e);
            String msg = this.localiser.msg("056012", (Object)removeStmt);
            NucleusLogger.DATASTORE.error((Object)msg);
            throw new NucleusDataStoreException(msg, (Throwable)e);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] internalRemove(ObjectProvider ownerSM, ManagedConnection conn, boolean batched, Object element, boolean executeNow, AbstractCollectionStore acs) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = ownerSM.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt((ElementContainerStore)acs);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)acs);
            jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, acs.getElementMapping());
            if (acs.getRelationDiscriminatorMapping() != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, (ElementContainerStore)acs);
            }
            nArray = sqlControl.executeStatementUpdate(conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException e) {
                throw new MappedDatastoreException("SQLException", (Throwable)e);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    public void preInternalRemove(ManagedConnection mconn) throws MappedDatastoreException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        try {
            sqlControl.processStatementsForConnection(mconn);
        }
        catch (SQLException e) {
            throw new MappedDatastoreException("SQLException", (Throwable)e);
        }
    }
}

