/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.datanucleus.store.types.sco.SCOUtils;

public class OracleCollectionMapping
extends CollectionMapping {
    public void postInsert(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            Collection value = (Collection)sm.provideField(this.mmd.getAbsoluteFieldNumber());
            SCOUtils.validateObjectsForWriting((ExecutionContext)sm.getExecutionContext(), (Object)value);
            byte[] bytes = new byte[]{};
            if (value != null) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(value);
                    bytes = baos.toByteArray();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDatastoreMapping(0), bytes);
        } else {
            super.postInsert(sm);
        }
    }

    public void postUpdate(ObjectProvider sm) {
        if (this.containerIsStoredInSingleColumn()) {
            Collection value = (Collection)sm.provideField(this.mmd.getAbsoluteFieldNumber());
            SCOUtils.validateObjectsForWriting((ExecutionContext)sm.getExecutionContext(), (Object)value);
            this.postInsert(sm);
        } else {
            super.postUpdate(sm);
        }
    }
}

