/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.MapTable;

public class MapGetMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"get", (Object)"MapExpression", (Object)1));
        }
        MapExpression mapExpr = (MapExpression)expr;
        SQLExpression keyValExpr = (SQLExpression)args.get(0);
        if (keyValExpr instanceof UnboundExpression) {
            throw new NucleusException("Dont currently support binding of unbound variables using Map.get");
        }
        if (mapExpr instanceof MapLiteral && keyValExpr instanceof SQLLiteral) {
            MapLiteral lit = (MapLiteral)expr;
            if (lit.getValue() == null) {
                return new NullLiteral(this.stmt, null, null, null);
            }
            return lit.getKeyLiteral().invoke("get", args);
        }
        if (mapExpr instanceof MapLiteral) {
            throw new NucleusUserException("We do not support MapLiteral.get(SQLExpression) since SQL doesnt allow such constructs");
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER || this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.ORDERING) {
            return this.getAsInnerJoin(mapExpr, keyValExpr);
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT) {
            return this.getAsSubquery(mapExpr, keyValExpr);
        }
        throw new NucleusException("Map.get() is not supported for " + mapExpr + " with argument " + keyValExpr + " for query component " + this.stmt.getQueryGenerator().getCompilationComponent());
    }

    protected SQLExpression getAsSubquery(MapExpression mapExpr, SQLExpression keyValExpr) {
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        MapMetaData mapmd = mmd.getMap();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        JavaTypeMapping ownerMapping = null;
        JavaTypeMapping keyMapping = null;
        JavaTypeMapping valMapping = null;
        DatastoreContainerObject mapTbl = null;
        if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            mapTbl = storeMgr.getDatastoreContainerObject(mmd);
            ownerMapping = ((MapTable)mapTbl).getOwnerMapping();
            keyMapping = ((MapTable)mapTbl).getKeyMapping();
            valMapping = ((MapTable)mapTbl).getValueMapping();
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(this.clr, mmgr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), this.clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, 5);
            String keyFieldName = mmd.getKeyMetaData().getMappedBy();
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(keyFieldName);
            keyMapping = mapTbl.getMemberMapping(valKeyMmd);
            valMapping = mapTbl.getIdMapping();
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(this.clr, mmgr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), this.clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, 5);
            keyMapping = mapTbl.getIdMapping();
            String valFieldName = mmd.getValueMetaData().getMappedBy();
            AbstractMemberMetaData keyValMmd = keyCmd.getMetaDataForMember(valFieldName);
            valMapping = mapTbl.getMemberMapping(keyValMmd);
        } else {
            throw new NucleusException("Invalid map for " + mapExpr + " in get() call");
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, mapTbl, null, null);
        subStmt.setClassLoaderResolver(this.clr);
        SQLExpression valExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), valMapping);
        subStmt.select(valExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        SQLExpression keyExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
        subStmt.whereAnd(keyExpr.eq(keyValExpr), true);
        return new SubqueryExpression(this.stmt, subStmt);
    }

    protected SQLExpression getAsInnerJoin(MapExpression mapExpr, SQLExpression keyValExpr) {
        JavaTypeMapping m = mapExpr.getJavaTypeMapping();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        MetaDataManager mmgr = storeMgr.getMetaDataManager();
        AbstractMemberMetaData mmd = m.getMemberMetaData();
        if (mmd != null) {
            MapMetaData mapmd = mmd.getMap();
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                MapTable joinTbl = (MapTable)this.stmt.getRDBMSManager().getDatastoreContainerObject(mmd);
                SQLTable joinSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                SQLExpression keyExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getKeyMapping());
                this.stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                if (mapmd.getValueClassMetaData(this.clr, mmgr) != null) {
                    DatastoreClass valTable = this.stmt.getRDBMSManager().getDatastoreClass(mapmd.getValueType(), this.clr);
                    SQLTable valueSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getValueMapping(), (DatastoreContainerObject)valTable, null, valTable.getIdMapping(), null, null);
                    return this.exprFactory.newExpression(this.stmt, valueSqlTbl, valTable.getIdMapping());
                }
                SQLExpression valueExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getValueMapping());
                return valueExpr;
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                DatastoreClass valTable = this.stmt.getRDBMSManager().getDatastoreClass(mapmd.getValueType(), this.clr);
                AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(this.clr, mmgr);
                SQLTable valSqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)valTable, null, valTable.getIdMapping(), null, null);
                String keyFieldName = mmd.getKeyMetaData().getMappedBy();
                AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(keyFieldName);
                JavaTypeMapping keyMapping = valTable.getMemberMapping(valKeyMmd);
                SQLExpression keyExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, keyMapping);
                this.stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                SQLExpression valueExpr = this.exprFactory.newExpression(this.stmt, valSqlTbl, valTable.getIdMapping());
                return valueExpr;
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
                DatastoreClass keyTable = this.stmt.getRDBMSManager().getDatastoreClass(mapmd.getKeyType(), this.clr);
                AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(this.clr, mmgr);
                SQLTable keySqlTbl = this.stmt.innerJoin(mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)keyTable, null, keyTable.getIdMapping(), null, null);
                SQLExpression keyExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, keyTable.getIdMapping());
                this.stmt.whereAnd(keyExpr.eq(keyValExpr), true);
                String valueFieldName = mmd.getValueMetaData().getMappedBy();
                AbstractMemberMetaData valKeyMmd = keyCmd.getMetaDataForMember(valueFieldName);
                JavaTypeMapping valueMapping = keyTable.getMemberMapping(valKeyMmd);
                SQLExpression valueExpr = this.exprFactory.newExpression(this.stmt, keySqlTbl, valueMapping);
                return valueExpr;
            }
        }
        throw new NucleusException("Map.get() for the filter is not supported for " + mapExpr + " with an argument of " + keyValExpr + ". Why not contribute support for it?");
    }
}

