/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.CastExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.CollectionMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MapMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.mapped.mapping.TemporalMapping;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.NewObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpressionComponent;
import org.datanucleus.store.rdbms.sql.expression.TemporalSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToSQLMapper
extends AbstractExpressionEvaluator
implements QueryGenerator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    final SQLStatement stmt;
    final StatementClassMapping resultDefinitionForClass;
    final StatementResultMapping resultDefinition;
    Map<Object, SQLExpression> expressionForParameter;
    final RDBMSStoreManager storeMgr;
    final FetchPlan fetchPlan;
    final SQLExpressionFactory exprFactory;
    ObjectManager om;
    ClassLoaderResolver clr;
    Map<String, Object> compileProperties = new HashMap<String, Object>();
    CompilationComponent compileComponent;
    int paramNumber = 1;
    Stack<SQLExpression> stack = new Stack();
    Map<String, SQLTableMapping> sqlTableByPrimary = new HashMap<String, SQLTableMapping>();
    Map<String, JavaTypeMapping> paramMappingForName = new HashMap<String, JavaTypeMapping>();
    boolean caseInsensitive = false;
    public QueryToSQLMapper parentMapper = null;
    SQLJoin.JoinType defaultJoinType = null;
    boolean precompilable = true;

    public QueryToSQLMapper(SQLStatement stmt, QueryCompilation compilation, Map parameters, StatementClassMapping resultDefForClass, StatementResultMapping resultDef, AbstractClassMetaData cmd, FetchPlan fetchPlan, ObjectManager om) {
        this.parameters = parameters;
        this.compilation = compilation;
        this.stmt = stmt;
        this.resultDefinitionForClass = resultDefForClass;
        this.resultDefinition = resultDef;
        this.candidateAlias = compilation.getCandidateAlias();
        this.fetchPlan = fetchPlan;
        this.storeMgr = stmt.getRDBMSManager();
        this.exprFactory = stmt.getRDBMSManager().getSQLExpressionFactory();
        this.candidateCmd = cmd;
        this.om = om;
        this.clr = om.getClassLoaderResolver();
        if (compilation.getQueryLanguage().equalsIgnoreCase("JPQL")) {
            this.caseInsensitive = true;
        }
        this.stmt.setQueryGenerator(this);
        SQLTableMapping tblMapping = new SQLTableMapping(stmt.getPrimaryTable(), this.candidateCmd, stmt.getPrimaryTable().getTable().getIdMapping());
        this.setSQLTableMappingForAlias(this.candidateAlias, tblMapping);
    }

    void setDefaultJoinType(SQLJoin.JoinType joinType) {
        this.defaultJoinType = joinType;
    }

    void setParentMapper(QueryToSQLMapper parent) {
        this.parentMapper = parent;
    }

    @Override
    public String getQueryLanguage() {
        return this.compilation.getQueryLanguage();
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public CompilationComponent getCompilationComponent() {
        return this.compileComponent;
    }

    @Override
    public ObjectManager getObjectManager() {
        return this.om;
    }

    @Override
    public Object getProperty(String name) {
        return this.compileProperties.get(name);
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public void compile() {
        this.compileFrom();
        this.compileFilter();
        this.compileResult();
        this.compileGrouping();
        this.compileHaving();
        this.compileOrdering();
        if (this.compilation.getExprResult() == null) {
            if (this.candidateCmd.getIdentityType() == IdentityType.NONDURABLE) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("052520", (Object)this.candidateCmd.getFullClassName()));
                }
                this.fetchPlan.setGroup("all");
            }
            if (this.stmt.allUnionsForSamePrimaryTable()) {
                SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.candidateCmd, this.fetchPlan, this.parentMapper == null ? 1 : 0);
            } else {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.candidateCmd);
            }
        }
        Collection symbols = this.compilation.getSymbolTable().getSymbolNames();
        Iterator symIter = symbols.iterator();
        while (symIter.hasNext()) {
            Symbol sym = this.compilation.getSymbolTable().getSymbol((String)symIter.next());
            if (sym.getType() != 2 || this.compilation.getCompilationForSubquery(sym.getQualifiedName()) != null || this.hasSQLTableMappingForAlias(sym.getQualifiedName())) continue;
            throw new QueryCompilerSyntaxException("Query has variable \"" + sym.getQualifiedName() + "\" which is not bound to the query");
        }
    }

    protected void compileFrom() {
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (int i = 0; i < fromExprs.length; ++i) {
                ClassExpression clsExpr = (ClassExpression)fromExprs[i];
                this.compileFromClassExpression(clsExpr);
            }
            this.compileComponent = null;
        }
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            if (QueryUtils.expressionHasOrOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.OR", true);
            }
            if (QueryUtils.expressionHasNotOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.NOT", true);
            }
            BooleanExpression filterExpr = (BooleanExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
            this.stmt.whereAnd(filterExpr, true);
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprUpdate() != null) {
            this.compileComponent = CompilationComponent.UPDATE;
            Expression[] updateExprs = this.compilation.getExprUpdate();
            SQLExpression[] updateSqlExprs = new SQLExpression[updateExprs.length];
            for (int i = 0; i < updateExprs.length; ++i) {
                DyadicExpression updateExpr = (DyadicExpression)updateExprs[i];
                SQLExpression leftSqlExpr = null;
                if (!(updateExpr.getLeft() instanceof PrimaryExpression)) {
                    throw new NucleusException("Dont currently support update clause containing left expression of type " + updateExpr.getLeft());
                }
                this.processPrimaryExpression((PrimaryExpression)updateExpr.getLeft());
                leftSqlExpr = this.stack.pop();
                SQLExpression rightSqlExpr = null;
                if (updateExpr.getRight() instanceof Literal) {
                    this.processLiteral((Literal)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof DyadicExpression) {
                    updateExpr.getRight().evaluate((ExpressionEvaluator)this);
                    rightSqlExpr = this.stack.pop();
                } else {
                    throw new NucleusException("Dont currently support update clause containing right expression of type " + updateExpr.getRight());
                }
                if (leftSqlExpr == null || rightSqlExpr == null) continue;
                updateSqlExprs[i] = leftSqlExpr.eq(rightSqlExpr);
            }
            this.stmt.setUpdates(updateSqlExprs);
            this.compileComponent = null;
        } else if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            Expression[] resultExprs = this.compilation.getExprResult();
            for (int i = 0; i < resultExprs.length; ++i) {
                SQLExpression sqlExpr;
                String alias = resultExprs[i].getAlias();
                if (resultExprs[i] instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    int col = this.stmt.select(sqlExpr, alias);
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof PrimaryExpression) {
                    PrimaryExpression primExpr = (PrimaryExpression)resultExprs[i];
                    if (primExpr.getId().equals(this.candidateAlias)) {
                        StatementClassMapping map = new StatementClassMapping(this.candidateCmd.getFullClassName(), null);
                        SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, map, this.candidateCmd, this.fetchPlan, 1);
                        this.resultDefinition.addMappingForResultExpression(i, map);
                        continue;
                    }
                    this.processPrimaryExpression(primExpr);
                    SQLExpression sqlExpr2 = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr2);
                    if (sqlExpr2 instanceof SQLLiteral) {
                        int col = this.stmt.select(sqlExpr2, alias);
                        StatementMappingIndex idx = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                        idx.setColumnPositions(new int[]{col});
                        if (alias != null) {
                            idx.setColumnAlias(alias);
                        }
                        this.resultDefinition.addMappingForResultExpression(i, idx);
                        continue;
                    }
                    int[] cols = this.stmt.select(sqlExpr2.getSQLTable(), sqlExpr2.getJavaTypeMapping(), alias);
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                    idx.setColumnPositions(cols);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)resultExprs[i], true);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    int col = this.stmt.select(sqlExpr, alias);
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    if (sqlExpr instanceof UnboundExpression) {
                        this.processUnboundExpression((UnboundExpression)sqlExpr);
                        sqlExpr = this.stack.pop();
                        NucleusLogger.QUERY.debug((Object)">> QueryToSQL.exprResult variable was still unbound, so binding via cross-join");
                    }
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    if (sqlExpr.getNumberOfSubExpressions() == 1) {
                        int col = this.stmt.select(sqlExpr, alias);
                        idx.setColumnPositions(new int[]{col});
                    } else {
                        int[] cols = new int[sqlExpr.getNumberOfSubExpressions()];
                        for (int j = 0; j < sqlExpr.getNumberOfSubExpressions(); ++j) {
                            int col;
                            String colAlias = alias != null ? alias + "_" + j : null;
                            cols[j] = col = this.stmt.select(sqlExpr.getSubExpression(j), colAlias);
                        }
                        idx.setColumnPositions(cols);
                    }
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof Literal) {
                    this.processLiteral((Literal)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    int col = this.stmt.select(sqlExpr, alias);
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof CreatorExpression) {
                    this.processCreatorExpression((CreatorExpression)resultExprs[i]);
                    sqlExpr = (NewObjectExpression)this.stack.pop();
                    StatementNewObjectMapping stmtMap = this.getStatementMappingForNewObjectExpression((NewObjectExpression)sqlExpr);
                    this.resultDefinition.addMappingForResultExpression(i, stmtMap);
                    continue;
                }
                if (resultExprs[i] instanceof DyadicExpression) {
                    resultExprs[i].evaluate((ExpressionEvaluator)this);
                    sqlExpr = this.stack.pop();
                    int col = this.stmt.select(sqlExpr, alias);
                    StatementMappingIndex idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(new int[]{col});
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                throw new NucleusException("Dont currently support result clause containing expression of type " + resultExprs[i]);
            }
            if (this.stmt.getNumberOfSelects() == 0) {
                this.stmt.select(this.exprFactory.newLiteral(this.stmt, this.storeMgr.getMappingManager().getMapping(Integer.class), 1), null);
            }
            this.compileComponent = null;
        }
    }

    protected void validateExpressionForResult(SQLExpression sqlExpr) {
        JavaTypeMapping m = sqlExpr.getJavaTypeMapping();
        if (m != null && (m instanceof CollectionMapping || m instanceof MapMapping)) {
            throw new NucleusUserException("Cannot select multi-valued objects in a result clause of a query");
        }
    }

    protected void compileGrouping() {
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (int i = 0; i < groupExprs.length; ++i) {
                Expression groupExpr = groupExprs[i];
                SQLExpression sqlGroupExpr = (SQLExpression)groupExpr.evaluate((ExpressionEvaluator)this);
                this.stmt.addGroupingExpression(sqlGroupExpr);
            }
            this.compileComponent = null;
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            Expression havingExpr = this.compilation.getExprHaving();
            Object havingEval = havingExpr.evaluate((ExpressionEvaluator)this);
            if (!(havingEval instanceof BooleanExpression)) {
                throw new NucleusUserException(LOCALISER.msg("021051", (Object)havingExpr));
            }
            this.stmt.setHaving((BooleanExpression)havingEval);
            this.compileComponent = null;
        }
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            SQLExpression[] orderSqlExprs = new SQLExpression[orderingExpr.length];
            boolean[] directions = new boolean[orderingExpr.length];
            for (int i = 0; i < orderingExpr.length; ++i) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                orderSqlExprs[i] = (SQLExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                String orderDir = orderExpr.getSortOrder();
                directions[i] = orderDir != null && !orderDir.equals("ascending");
            }
            this.stmt.setOrdering(orderSqlExprs, directions);
            this.compileComponent = null;
        }
    }

    protected void compileFromClassExpression(ClassExpression clsExpr) {
        Symbol clsExprSym = clsExpr.getSymbol();
        Class baseCls = clsExprSym.getValueType();
        SQLTable candSqlTbl = this.stmt.getPrimaryTable();
        MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
        AbstractClassMetaData cmd = mmgr.getMetaDataForClass(baseCls, this.clr);
        if (baseCls != null && baseCls != this.compilation.getCandidateClass()) {
            DatastoreClass candTbl = this.storeMgr.getDatastoreClass(baseCls.getName(), this.clr);
            candSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)candTbl, clsExpr.getAlias(), null);
            SQLTableMapping tblMapping = new SQLTableMapping(candSqlTbl, cmd, candTbl.getIdMapping());
            this.setSQLTableMappingForAlias(clsExpr.getAlias(), tblMapping);
        }
        if (clsExpr.getCandidateExpression() != null && this.parentMapper != null) {
            StringTokenizer tokeniser = new StringTokenizer(clsExpr.getCandidateExpression(), ".");
            String outerAlias = tokeniser.nextToken();
            String joinedField = tokeniser.nextToken();
            SQLTableMapping outerSqlTblMapping = this.parentMapper.getSQLTableMappingForAlias(outerAlias);
            SQLTable outerSqlTbl = outerSqlTblMapping.table;
            AbstractClassMetaData outerCmd = outerSqlTblMapping.cmd;
            AbstractMemberMetaData mmd = outerCmd.getMetaDataForMember(joinedField);
            int relationType = mmd.getRelationType(this.clr);
            switch (relationType) {
                case 1: {
                    SQLExpression outerExpr2 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(mmd));
                    SQLExpression innerExpr2 = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr2.eq(innerExpr2), false);
                    break;
                }
                case 2: {
                    SQLExpression innerExpr;
                    SQLExpression outerExpr3;
                    AbstractMemberMetaData relMmd;
                    if (mmd.getMappedBy() != null) {
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        outerExpr3 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        innerExpr = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getMemberMapping(relMmd));
                        this.stmt.whereAnd(outerExpr3.eq(innerExpr), false);
                        break;
                    }
                    SQLExpression outerExpr2 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(mmd));
                    SQLExpression innerExpr2 = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr2.eq(innerExpr2), false);
                    break;
                }
                case 3: {
                    SQLExpression joinExpr;
                    SQLExpression outerExpr;
                    SQLTable joinSqlTbl;
                    ElementContainerTable joinTbl;
                    AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                    if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                        joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                        joinSqlTbl = this.stmt.innerJoin(candSqlTbl, candSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                        outerExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                        this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                        break;
                    }
                    SQLExpression outerExpr3 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                    SQLExpression innerExpr = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getMemberMapping(relMmd));
                    this.stmt.whereAnd(outerExpr3.eq(innerExpr), false);
                    break;
                }
                case 4: {
                    SQLExpression joinExpr;
                    SQLExpression outerExpr;
                    SQLTable joinSqlTbl;
                    ElementContainerTable joinTbl;
                    AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                    if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                        joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                        joinSqlTbl = this.stmt.innerJoin(candSqlTbl, candSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                        outerExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                        this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                        break;
                    }
                    SQLExpression outerExpr3 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                    SQLExpression innerExpr = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getMemberMapping(relMmd));
                    this.stmt.whereAnd(outerExpr3.eq(innerExpr), false);
                    break;
                }
                case 6: {
                    SQLExpression joinExpr;
                    SQLExpression outerExpr;
                    SQLTable joinSqlTbl;
                    ElementContainerTable joinTbl;
                    AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                    if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                        joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(relMmd);
                        joinSqlTbl = this.stmt.innerJoin(candSqlTbl, candSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                        outerExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                        joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                        this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                        break;
                    }
                    SQLExpression outerExpr3 = this.exprFactory.newExpression(this.stmt.getParentStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(mmd));
                    SQLExpression innerExpr = this.exprFactory.newExpression(this.stmt, candSqlTbl, candSqlTbl.getTable().getIdMapping());
                    this.stmt.whereAnd(outerExpr3.eq(innerExpr), false);
                }
            }
        }
        SQLTable sqlTbl = candSqlTbl;
        for (Expression rightExpr = clsExpr.getRight(); rightExpr != null; rightExpr = rightExpr.getRight()) {
            if (!(rightExpr instanceof JoinExpression)) continue;
            JoinExpression joinExpr = (JoinExpression)rightExpr;
            JoinExpression.JoinType joinType = joinExpr.getType();
            String joinAlias = joinExpr.getAlias();
            PrimaryExpression joinPrimExpr = joinExpr.getPrimaryExpression();
            String joinPrimExprId = joinPrimExpr.getId();
            String joinTableGroupName = null;
            if (joinPrimExprId.toUpperCase().startsWith(this.candidateAlias.toUpperCase())) {
                joinTableGroupName = joinPrimExprId;
            }
            List joinPrimTuples = joinPrimExpr.getTuples();
            Iterator iter = joinPrimTuples.iterator();
            iter.next();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(id);
                int relationType = mmd.getRelationType(this.clr);
                DatastoreClass relTable = null;
                AbstractMemberMetaData relMmd = null;
                switch (relationType) {
                    case 1: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = mmgr.getMetaDataForClass(mmd.getType(), this.clr);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 2: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        if (mmd.getMappedBy() != null) {
                            relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                                break;
                            }
                            sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 4: {
                        SQLTable joinSqlTbl;
                        ElementContainerTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                        break;
                    }
                    case 3: {
                        SQLTable joinSqlTbl;
                        ElementContainerTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        if (mmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        JavaTypeMapping relMapping = relTable.getExternalMapping(mmd, 5);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, joinTableGroupName);
                        break;
                    }
                    case 5: {
                        SQLTable joinSqlTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        ElementContainerTable joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                        sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 6: {
                        SQLTable joinSqlTbl;
                        ElementContainerTable joinTbl;
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(relMmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        JavaTypeMapping fkMapping = sqlTbl.getTable().getMemberMapping(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                }
            }
            SQLTableMapping tblMapping = new SQLTableMapping(sqlTbl, cmd, sqlTbl.getTable().getIdMapping());
            this.setSQLTableMappingForAlias(joinAlias, tblMapping);
        }
    }

    protected StatementNewObjectMapping getStatementMappingForNewObjectExpression(NewObjectExpression expr) {
        List<SQLExpression> argExprs = expr.getConstructorArgExpressions();
        StatementNewObjectMapping stmtMap = new StatementNewObjectMapping(expr.getNewClass());
        if (argExprs != null) {
            Iterator<SQLExpression> argIter = argExprs.iterator();
            int j = 0;
            while (argIter.hasNext()) {
                SQLExpression argExpr = argIter.next();
                if (argExpr instanceof SQLLiteral) {
                    stmtMap.addConstructorArgMapping(j, ((SQLLiteral)((Object)argExpr)).getValue());
                } else if (argExpr instanceof NewObjectExpression) {
                    stmtMap.addConstructorArgMapping(j, (Object)this.getStatementMappingForNewObjectExpression((NewObjectExpression)argExpr));
                } else {
                    StatementMappingIndex idx = new StatementMappingIndex(argExpr.getJavaTypeMapping());
                    if (argExpr.getNumberOfSubExpressions() == 1) {
                        int col = this.stmt.select(argExpr, null);
                        idx.setColumnPositions(new int[]{col});
                        stmtMap.addConstructorArgMapping(j, (Object)idx);
                    } else {
                        int[] cols = new int[argExpr.getNumberOfSubExpressions()];
                        for (int i = 0; i < argExpr.getNumberOfSubExpressions(); ++i) {
                            int col;
                            cols[i] = col = this.stmt.select(argExpr.getSubExpression(i), null);
                        }
                        idx.setColumnPositions(cols);
                        stmtMap.addConstructorArgMapping(j, (Object)idx);
                    }
                }
                ++j;
            }
        }
        return stmtMap;
    }

    protected Object processAndExpression(Expression expr) {
        BooleanExpression right = (BooleanExpression)this.stack.pop();
        BooleanExpression left = (BooleanExpression)this.stack.pop();
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        BooleanExpression opExpr = left.and(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processOrExpression(Expression expr) {
        BooleanExpression right = (BooleanExpression)this.stack.pop();
        BooleanExpression left = (BooleanExpression)this.stack.pop();
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        BooleanExpression opExpr = left.ior(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processEqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.eq(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ne(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ge(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.gt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.le(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter()) {
            this.updateParameterMapping(left, right.getJavaTypeMapping());
        } else if (right.isParameter()) {
            this.updateParameterMapping(right, left.getJavaTypeMapping());
        }
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.lt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Class) {
            litValue = ((Class)litValue).getName();
        }
        JavaTypeMapping m = null;
        if (litValue != null) {
            m = this.exprFactory.getMappingForType(litValue.getClass(), false);
        }
        SQLExpression sqlExpr = this.exprFactory.newLiteral(this.stmt, m, litValue);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        SQLExpression sqlExpr = null;
        if (expr.getLeft() != null) {
            if (expr.getLeft() instanceof ParameterExpression) {
                String fieldName;
                this.precompilable = false;
                ParameterExpression paramExpr = (ParameterExpression)expr.getLeft();
                Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramExpr.getId());
                if (paramSym.getValueType().isArray()) {
                    String first = (String)expr.getTuples().get(0);
                    this.processParameterExpression(paramExpr, true);
                    SQLExpression paramSqlExpr = this.stack.pop();
                    sqlExpr = this.exprFactory.invokeMethod(this.stmt, "ARRAY", first, paramSqlExpr, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                this.processParameterExpression(paramExpr, true);
                SQLExpression paramSqlExpr = this.stack.pop();
                SQLLiteral lit = (SQLLiteral)((Object)paramSqlExpr);
                Object paramValue = lit.getValue();
                List tuples = expr.getTuples();
                Iterator tuplesIter = tuples.iterator();
                Object objValue = paramValue;
                while (tuplesIter.hasNext() && (objValue = this.getValueForObjectField(objValue, fieldName = (String)tuplesIter.next())) != null) {
                }
                if (objValue == null) {
                    sqlExpr = this.exprFactory.newLiteral(this.stmt, null, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(objValue.getClass(), false);
                sqlExpr = this.exprFactory.newLiteral(this.stmt, m, objValue);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof VariableExpression) {
                VariableExpression varExpr = (VariableExpression)expr.getLeft();
                this.processVariableExpression(varExpr);
                SQLExpression varSqlExpr = this.stack.pop();
                NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processPrimary left(var)=" + expr.getLeft() + " id=" + expr.getId() + " varSqlExpr=" + varSqlExpr));
                if (varSqlExpr instanceof UnboundExpression) {
                    this.processUnboundExpression((UnboundExpression)varSqlExpr);
                    varSqlExpr = this.stack.pop();
                    NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processPrimary variable is still unbound, so binding via cross-join varSqlExpr=" + varSqlExpr));
                }
                NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processPrimary varType=" + varSqlExpr.getJavaTypeMapping().getType() + " varExpr.tbl=" + varSqlExpr.getSQLTable() + " stmt=" + this.stmt + " varExpr.stmt=" + varSqlExpr.getSQLStatement()));
                Class varType = this.clr.classForName(varSqlExpr.getJavaTypeMapping().getType());
                if (varSqlExpr.getSQLStatement() == this.stmt.getParentStatement()) {
                    SQLTableMapping sqlMapping = this.parentMapper.getSQLTableMappingForPrimaryExpression(this.stmt, null, expr.getTuples(), false);
                    if (sqlMapping == null) {
                        throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
                    }
                    sqlExpr = this.exprFactory.newExpression(varSqlExpr.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                SQLTableMapping varTblMapping = this.getSQLTableMappingForAlias(varExpr.getId());
                if (varTblMapping == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " is not yet bound, so cannot get field " + expr.getId());
                }
                if (varTblMapping.cmd == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " of type " + varType.getName() + " cannot evaluate " + expr.getId());
                }
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(varSqlExpr.getSQLStatement(), varExpr.getId(), expr.getTuples(), false);
                NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processPrimary var=" + varExpr.getId() + " tuples=" + StringUtils.collectionToString((Collection)expr.getTuples()) + " sqlMapping=" + sqlMapping));
                sqlExpr = this.exprFactory.newExpression(sqlMapping.table.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof CastExpression) {
                CastExpression castExpr = (CastExpression)expr.getLeft();
                PrimaryExpression castLeftExpr = (PrimaryExpression)castExpr.getLeft();
                this.processPrimaryExpressionInternal(castLeftExpr, true);
                SQLExpression castLeftSqlExpr = this.stack.pop();
                String castClassName = castExpr.getClassName();
                SQLExpression castClassNameExpr = this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(String.class, false), castClassName);
                sqlExpr = castLeftSqlExpr.cast(castClassNameExpr);
                String exprPrimName = "CAST_" + castLeftExpr.getId();
                AbstractClassMetaData castCmd = this.om.getMetaDataManager().getMetaDataForClass(castClassName, this.clr);
                SQLTableMapping tblMapping = new SQLTableMapping(sqlExpr.getSQLTable(), castCmd, sqlExpr.getJavaTypeMapping());
                this.setSQLTableMappingForAlias(exprPrimName, tblMapping);
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, exprPrimName, expr.getTuples(), false);
                if (sqlMapping == null) {
                    throw new NucleusException("PrimaryExpression " + expr + " is not yet supported");
                }
                sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)expr.getLeft());
                SQLExpression invokeSqlExpr = this.stack.pop();
                DatastoreContainerObject tbl = invokeSqlExpr.getSQLTable().getTable();
                if (tbl instanceof DatastoreClass) {
                    if (expr.getTuples().size() > 1) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr);
                    }
                    JavaTypeMapping mapping = ((DatastoreClass)tbl).getMemberMapping(expr.getId());
                    if (mapping == null) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + ". The field " + expr.getId() + " doesnt exist in table " + tbl);
                    }
                    sqlExpr = this.exprFactory.newExpression(this.stmt, invokeSqlExpr.getSQLTable(), mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + " with invoke having table of " + tbl);
            }
            throw new NucleusUserException("Dont currently support PrimaryExpression with 'left' of " + expr.getLeft());
        }
        return this.processPrimaryExpressionInternal(expr, false);
    }

    private SQLExpression processPrimaryExpressionInternal(PrimaryExpression primExpr, boolean forceJoin) {
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, null, primExpr.getTuples(), forceJoin);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + primExpr.getId() + " is not yet supported");
        }
        SQLExpression sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    private SQLTableMapping getSQLTableMappingForPrimaryExpression(SQLStatement theStmt, String exprName, List<String> tuples, boolean forceJoin) {
        SQLTableMapping sqlMapping = null;
        Iterator<String> iter = tuples.iterator();
        String first = tuples.get(0);
        String primaryName = null;
        if (exprName != null) {
            sqlMapping = this.getSQLTableMappingForAlias(exprName);
            primaryName = exprName;
        } else {
            if (this.hasSQLTableMappingForAlias(first)) {
                sqlMapping = this.getSQLTableMappingForAlias(first);
                primaryName = first;
                iter.next();
            }
            if (sqlMapping == null && this.parentMapper != null && this.parentMapper.hasSQLTableMappingForAlias(first)) {
                sqlMapping = this.parentMapper.getSQLTableMappingForAlias(first);
                primaryName = first;
                iter.next();
            }
            if (sqlMapping == null) {
                sqlMapping = this.getSQLTableMappingForAlias(this.candidateAlias);
                primaryName = this.candidateAlias;
            }
        }
        AbstractClassMetaData cmd = sqlMapping.cmd;
        JavaTypeMapping mapping = null;
        if (sqlMapping != null) {
            mapping = sqlMapping.mapping;
        }
        while (iter.hasNext()) {
            String component = iter.next();
            SQLTableMapping sqlMappingNew = this.getSQLTableMappingForAlias(primaryName = primaryName + "." + component);
            if (sqlMappingNew == null) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(component);
                if (mmd == null) {
                    throw new NucleusUserException("Query contains access of " + primaryName + " yet this field/property doesnt exist");
                }
                SQLTable sqlTbl = null;
                if (mapping instanceof EmbeddedMapping) {
                    sqlTbl = sqlMapping.table;
                    mapping = ((EmbeddedMapping)mapping).getJavaTypeMapping(component);
                } else {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                    mapping = table.getMemberMapping(mmd);
                    sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(theStmt, sqlMapping.table, mapping);
                }
                int relationType = mmd.getRelationType(this.clr);
                switch (relationType) {
                    case 0: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        if (mmd.getMappedBy() != null) {
                            AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            if (relMmd.getAbstractClassMetaData().isEmbeddedOnly()) {
                                sqlMappingNew = sqlMapping;
                                cmd = relMmd.getAbstractClassMetaData();
                                break;
                            }
                            DatastoreClass relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                            JavaTypeMapping relMapping = relTable.getMemberMapping(relMmd);
                            sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, sqlMapping.table.getTable().getIdMapping(), sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, primaryName, this.defaultJoinType);
                            }
                            if (iter.hasNext()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                                cmd = sqlMappingNew.cmd;
                                break;
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, relTable.getIdMapping());
                            cmd = sqlMappingNew.cmd;
                            break;
                        }
                        if (iter.hasNext() || forceJoin) {
                            AbstractClassMetaData relCmd = null;
                            JavaTypeMapping relMapping = null;
                            DatastoreClass relTable = null;
                            if (relationType == 2) {
                                AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                                relCmd = relMmd.getAbstractClassMetaData();
                            } else {
                                relCmd = this.om.getMetaDataManager().getMetaDataForClass(mmd.getTypeName(), this.clr);
                            }
                            if (relCmd.isEmbeddedOnly()) {
                                sqlMappingNew = sqlMapping;
                                cmd = relCmd;
                                break;
                            }
                            relTable = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                            relMapping = relTable.getIdMapping();
                            sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, mapping, sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, primaryName, this.defaultJoinType);
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, relMapping);
                            cmd = sqlMappingNew.cmd;
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            break;
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                }
            } else {
                cmd = sqlMappingNew.cmd;
            }
            sqlMapping = sqlMappingNew;
        }
        return sqlMapping;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return this.processParameterExpression(expr, false);
    }

    protected Object processParameterExpression(ParameterExpression expr, boolean asLiteral) {
        JavaTypeMapping m;
        Object paramValue = null;
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(new Integer(position))) {
                    paramValue = this.parameters.get(new Integer(position));
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if ((m = this.paramMappingForName.get(expr.getId())) == null) {
            if (paramValue != null) {
                m = this.exprFactory.getMappingForType(paramValue.getClass(), false);
                if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                    if (!QueryUtils.queryParameterTypesAreCompatible((Class)expr.getSymbol().getValueType(), paramValue.getClass())) {
                        throw new QueryCompilerSyntaxException("Supplied parameter " + expr.getId() + " is declared as " + expr.getSymbol().getValueType().getName() + " yet a value of type " + paramValue.getClass().getName() + " was supplied");
                    }
                    if (expr.getSymbol().getValueType() != paramValue.getClass()) {
                        this.precompilable = false;
                    }
                }
            } else if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                m = this.exprFactory.getMappingForType(expr.getSymbol().getValueType(), false);
            }
        }
        if (paramValue == null && expr.getSymbol() != null) {
            this.precompilable = false;
        }
        SQLExpression sqlExpr = null;
        if (asLiteral && paramValue != null) {
            sqlExpr = this.exprFactory.newLiteral(this.stmt, m, paramValue);
        } else {
            sqlExpr = this.exprFactory.newLiteralParameter(this.stmt, m, paramValue, expr.getId());
            if (sqlExpr instanceof ParameterLiteral) {
                ((ParameterLiteral)sqlExpr).setName(expr.getId());
            }
            if (this.expressionForParameter == null) {
                this.expressionForParameter = new HashMap<Object, SQLExpression>();
            }
            this.expressionForParameter.put(expr.getId(), sqlExpr);
            this.paramMappingForName.put(expr.getId(), m);
        }
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        SQLExpression invokedSqlExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof Literal) {
                this.processLiteral((Literal)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.precompilable = false;
                this.processParameterExpression((ParameterExpression)invokedExpr, true);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof VariableExpression) {
                this.processVariableExpression((VariableExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else {
                throw new NucleusException("Dont currently support invoke expression " + invokedExpr);
            }
        }
        String operation = expr.getOperation();
        List args = expr.getArguments();
        ArrayList<SQLExpression> sqlExprArgs = null;
        if (args != null) {
            sqlExprArgs = new ArrayList<SQLExpression>();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof DyadicExpression) {
                    argExpr.evaluate((ExpressionEvaluator)this);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                throw new NucleusException("Dont currently support invoke expression argument " + argExpr);
            }
        }
        SQLExpression sqlExpr = null;
        sqlExpr = invokedSqlExpr != null ? invokedSqlExpr.invoke(operation, sqlExprArgs) : this.exprFactory.invokeMethod(this.stmt, null, operation, null, sqlExprArgs);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processSubqueryExpression(org.datanucleus.query.expression.SubqueryExpression expr) {
        String keyword = expr.getKeyword();
        Expression subqueryExpr = expr.getRight();
        if (subqueryExpr instanceof VariableExpression) {
            this.processVariableExpression((VariableExpression)subqueryExpr);
            SQLExpression subquerySqlExpr = this.stack.pop();
            NucleusLogger.GENERAL.info((Object)(">> QueryToSQL.processSubquery " + expr + " sql=" + subquerySqlExpr + " keyword=" + keyword));
            if (keyword != null && keyword.equals("EXISTS")) {
                if (subquerySqlExpr instanceof SubqueryExpression) {
                    SQLStatement subStmt = ((SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                } else {
                    SQLStatement subStmt = ((SubqueryExpressionComponent)((Object)subquerySqlExpr)).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                }
            } else if (subquerySqlExpr instanceof SubqueryExpression) {
                SQLStatement subStmt = ((SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
            } else if (subquerySqlExpr instanceof NumericSubqueryExpression) {
                ((NumericSubqueryExpression)subquerySqlExpr).setKeyword(keyword);
            }
            this.stack.push(subquerySqlExpr);
            return subquerySqlExpr;
        }
        throw new NucleusException("Dont currently support SubqueryExpression " + keyword + " for type " + subqueryExpr);
    }

    protected Object processAddExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.add(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDivExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.div(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processMulExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mul(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processSubExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.sub(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDistinctExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        sqlExpr.distinct();
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processComExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.com();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processModExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mod(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNegExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.neg();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNotExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        BooleanExpression resultExpr = sqlExpr.not();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processCastExpression(CastExpression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression instanceofExpr = left.cast(right);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processIsExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, false);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processIsnotExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, true);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processInExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.in(right);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        String className = expr.getId();
        Class cls = this.clr.classForName(className);
        ArrayList<SQLExpression> ctrArgExprs = null;
        List args = expr.getArguments();
        if (args != null) {
            ctrArgExprs = new ArrayList<SQLExpression>(args.size());
            for (Expression argExpr : args) {
                SQLExpression sqlExpr = (SQLExpression)this.evaluate(argExpr);
                ctrArgExprs.add(sqlExpr);
            }
        }
        NewObjectExpression newExpr = new NewObjectExpression(this.stmt, cls, ctrArgExprs);
        this.stack.push(newExpr);
        return newExpr;
    }

    protected Object processLikeExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(right);
        SQLExpression likeExpr = this.exprFactory.invokeMethod(this.stmt, String.class.getName(), "like", left, args);
        this.stack.push(likeExpr);
        return likeExpr;
    }

    protected Object processVariableExpression(VariableExpression expr) {
        Symbol varSym = expr.getSymbol();
        String varName = varSym.getQualifiedName();
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable expr=" + expr + " var=" + varName));
        if (this.hasSQLTableMappingForAlias(varName)) {
            SQLTableMapping tblMapping = this.getSQLTableMappingForAlias(varName);
            NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable (existing) var=" + varName + " tableMapping=" + tblMapping + " stmt=" + tblMapping.table.getSQLStatement()));
            SQLExpression sqlExpr = this.exprFactory.newExpression(tblMapping.table.getSQLStatement(), tblMapping.table, tblMapping.mapping);
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (this.compilation.getCompilationForSubquery(varName) != null) {
            JavaTypeMapping subMapping;
            QueryCompilation subCompilation = this.compilation.getCompilationForSubquery(varName);
            AbstractClassMetaData subCmd = this.om.getMetaDataManager().getMetaDataForClass(subCompilation.getCandidateClass(), this.om.getClassLoaderResolver());
            String subAlias = null;
            if (subCompilation.getCandidateAlias() != null && !subCompilation.getCandidateAlias().equals(this.candidateAlias)) {
                subAlias = subCompilation.getCandidateAlias();
            }
            StatementResultMapping subqueryResultMapping = new StatementResultMapping();
            SQLStatement subStmt = RDBMSQueryUtils.getStatementForCandidates(this.stmt, subCmd, null, this.om, subCompilation.getCandidateClass(), false, "avg(something)", subAlias, null);
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(subStmt, subCompilation, this.parameters, null, subqueryResultMapping, subCmd, this.fetchPlan, this.om);
            sqlMapper.setParentMapper(this);
            sqlMapper.compile();
            if (subqueryResultMapping.getNumberOfResultExpressions() > 1) {
                throw new NucleusUserException("Number of result expressions in subquery should be 1");
            }
            SQLExpression subExpr = null;
            NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable (subquery) variable=" + varName + " subqueryResult=" + subqueryResultMapping));
            subExpr = subqueryResultMapping.getNumberOfResultExpressions() == 0 ? new SubqueryExpression(this.stmt, subStmt) : ((subMapping = ((StatementMappingIndex)subqueryResultMapping.getMappingForResultExpression(0)).getMapping()) instanceof TemporalMapping ? new TemporalSubqueryExpression(this.stmt, subStmt) : (subMapping instanceof StringMapping ? new StringSubqueryExpression(this.stmt, subStmt) : new NumericSubqueryExpression(this.stmt, subStmt)));
            this.stack.push(subExpr);
            return subExpr;
        }
        if (this.stmt.getParentStatement() != null && this.parentMapper != null && this.parentMapper.candidateAlias != null && this.parentMapper.candidateAlias.equals(varName)) {
            SQLExpression varExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), this.stmt.getParentStatement().getPrimaryTable(), this.stmt.getParentStatement().getPrimaryTable().getTable().getIdMapping());
            this.stack.push(varExpr);
            return varExpr;
        }
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable (unbound) variable=" + varName + " is not yet bound so returning UnboundExpression"));
        UnboundExpression unbExpr = new UnboundExpression(this.stmt, varName);
        this.stack.push(unbExpr);
        return unbExpr;
    }

    protected SQLExpression processUnboundExpression(UnboundExpression expr) {
        String varName = expr.getVariableName();
        Symbol varSym = this.compilation.getSymbolTable().getSymbol(varName);
        AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(varSym.getValueType(), this.clr);
        if (cmd != null) {
            NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable var=" + varName + " yet unbound, so adding as cross-join"));
            DatastoreClass varTable = this.storeMgr.getDatastoreClass(varSym.getValueType().getName(), this.clr);
            SQLTable varSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)varTable, "VAR_" + varName, null);
            SQLTableMapping varSqlTblMapping = new SQLTableMapping(varSqlTbl, cmd, varTable.getIdMapping());
            this.setSQLTableMappingForAlias(varName, varSqlTblMapping);
            SQLExpression sqlExpr = this.exprFactory.newExpression(this.stmt, varSqlTbl, varTable.getIdMapping());
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        throw new NucleusUserException("Variable " + varName + " is unbound and cannot be determined");
    }

    protected void updateParameterMapping(SQLExpression paramExpr, JavaTypeMapping mapping) {
        if (mapping == null) {
            return;
        }
        boolean needsUpdating = false;
        JavaTypeMapping paramMapping = paramExpr.getJavaTypeMapping();
        if (paramMapping != null && paramMapping.getNumberOfDatastoreMappings() != mapping.getNumberOfDatastoreMappings()) {
            needsUpdating = true;
        } else {
            for (int i = 0; i < paramMapping.getNumberOfDatastoreMappings(); ++i) {
                DatastoreMapping colMapping = paramMapping.getDatastoreMapping(i);
                if (colMapping != null && colMapping.getClass() == mapping.getDatastoreMapping(i).getClass()) continue;
                needsUpdating = true;
                break;
            }
        }
        if (needsUpdating) {
            paramExpr.setJavaTypeMapping(mapping);
        }
    }

    protected SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, JavaTypeMapping mapping) {
        return this.exprFactory.newLiteralParameter(this.stmt, mapping, paramLit.getValue(), paramLit.getParameterName());
    }

    @Override
    public void useParameterExpressionAsLiteral(SQLLiteral paramLiteral) {
        paramLiteral.setNotParameter();
        this.precompilable = false;
    }

    protected Object getValueForObjectField(Object obj, String fieldName) {
        if (obj != null) {
            Object paramFieldValue = null;
            if (this.om.getApiAdapter().isPersistable(obj)) {
                StateManager paramSM = this.om.findStateManager(obj);
                AbstractClassMetaData paramCmd = this.om.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                AbstractMemberMetaData paramFieldMmd = paramCmd.getMetaDataForMember(fieldName);
                if (paramSM != null) {
                    this.om.getApiAdapter().isLoaded(paramSM, paramFieldMmd.getAbsoluteFieldNumber());
                    paramFieldValue = paramSM.provideField(paramFieldMmd.getAbsoluteFieldNumber());
                } else {
                    paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
                }
            } else {
                paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
            }
            return paramFieldValue;
        }
        return null;
    }

    protected SQLTableMapping getSQLTableMappingForAlias(String alias) {
        if (this.caseInsensitive) {
            return this.sqlTableByPrimary.get(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.get(alias);
    }

    protected void setSQLTableMappingForAlias(String alias, SQLTableMapping mapping) {
        if (alias == null) {
            return;
        }
        if (this.caseInsensitive) {
            this.sqlTableByPrimary.put(alias.toUpperCase(), mapping);
        } else {
            this.sqlTableByPrimary.put(alias, mapping);
        }
    }

    protected boolean hasSQLTableMappingForAlias(String alias) {
        if (this.caseInsensitive) {
            return this.sqlTableByPrimary.containsKey(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.containsKey(alias);
    }

    @Override
    public void bindVariable(String varName, AbstractClassMetaData cmd, SQLTable sqlTbl, JavaTypeMapping mapping) {
        SQLTableMapping m = this.getSQLTableMappingForAlias(varName);
        if (m != null) {
            throw new NucleusException("Variable " + varName + " is already bound to " + m.table + " yet attempting to bind to " + sqlTbl);
        }
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.bindVariable variable " + varName + " being bound to table=" + sqlTbl + " mapping=" + mapping));
        m = new SQLTableMapping(sqlTbl, cmd, mapping);
        this.setSQLTableMappingForAlias(varName, m);
    }

    @Override
    public void bindParameter(String paramName, Class type) {
        Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramName);
        if (paramSym != null && paramSym.getValueType() == null) {
            NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.bindParameter parameter=" + paramName + " has had its type set to " + type));
            paramSym.setValueType(type);
        }
    }

    @Override
    public Class getTypeOfVariable(String varName) {
        Symbol sym = this.compilation.getSymbolTable().getSymbol(varName);
        if (sym != null && sym.getValueType() != null) {
            return sym.getValueType();
        }
        return null;
    }

    class SQLTableMapping {
        SQLTable table;
        AbstractClassMetaData cmd;
        JavaTypeMapping mapping;

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mapping = m;
        }

        public String toString() {
            return "SQLTableMapping: tbl=" + this.table + " class=" + (this.cmd != null ? this.cmd.getFullClassName() : "null") + " mapping=" + this.mapping;
        }
    }
}

