/**********************************************************************
Copyright (c) 2002 Kelly Grizzle (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
2002 Mike Martin (TJDO)
2003 Erik Bengtson - removed getObject
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/

package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.query.ResultObjectFactory;

/**
 * ResultObjectFactory that generates an instance of a "nondurable" class for each ResultSet row.
 * This is used by views though better off using a ResultClassROF.
 * @deprecated
 */
public final class TransientIDROF implements ResultObjectFactory
{
    private final Class candidateClass;
    protected final int[] fieldNumbers;
	protected final StatementMappingIndex[] stmtMappings;

	/**
     * Constructor 
     * @param candidateClass the candidate class
     * @param fieldNumbers the absolute field numbers with the retrieved fields
     * @param stmtMappings the mappings of fields in the statement
	 */
    public TransientIDROF(Class candidateClass, int[] fieldNumbers, StatementMappingIndex[] stmtMappings)
    {
        this.candidateClass = candidateClass;
        this.fieldNumbers = fieldNumbers;
        this.stmtMappings = stmtMappings;
    }

	/**
     * Method to return an object for the row of the ResultSet.
     * @param om ObjectManager
     * @param rs ResultSet
     * @return The Object for this row of the ResultSet.
	 */
	public Object getObject(final ObjectManager om, final Object rs)
    {
        final StatementClassMapping resultMappings = new StatementClassMapping();
        for (int i=0;i<fieldNumbers.length;i++)
        {
            resultMappings.addMappingForMember(fieldNumbers[i], stmtMappings[fieldNumbers[i]]);
        }

        return om.findObject(om.newObjectId(candidateClass.getName(), null),
            new FieldValues()
            {
                public void fetchFields(StateManager sm)
                {
                    FieldManager fm = 
                        ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, rs, resultMappings);
                    sm.replaceFields(fieldNumbers, fm, false);
                }
                public void fetchNonLoadedFields(StateManager sm)
                {
                    FieldManager fm = 
                        ((MappedStoreManager)om.getStoreManager()).getFieldManagerForResultProcessing(sm, rs, resultMappings);
                    sm.replaceNonLoadedFields(fieldNumbers, fm);
                }
                public FetchPlan getFetchPlanForLoading()
                {
                    return null;
                }
            }, null, false);
	}
}