/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
2003 Erik Bengtson - removed toStatement and toString methods enherited
                    from QueryStatement. setOrdering now goes thought
                    union queries.                  
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanCharColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;

/**
 * Representation of a Query Statement in Oracle 8.
 * Oracle has an NLSSortOrder control for order clauses.
 * Default value is "LATIN", but a value of "BINARY" disables native language sorting
 */ 
public class OracleQueryStatement extends QueryStatement
{
    /**
     * QueryStatement constructor 
     * @param initialTable The main table for this statement.
     * @param alias The alias for the main table
     * @param clr ClassLoader resolver
     */
    public OracleQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier alias, ClassLoaderResolver clr)
    {
        super(initialTable, alias, clr);
    }

    /**
     * Convenience method to generate the ordering statement to add to the overall query statement.
     * @return The ordering statement
     */
    protected StatementText generateOrderingStatement()
    {
        String nlsSortOrder = "LATIN";
        String sortOrder = storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.oracleNlsSortOrder");
        if (sortOrder != null)
        {
            nlsSortOrder = sortOrder.toUpperCase();
        }

        StatementText orderByStmt = null;
        if (orderingExpressions != null && orderingExpressions.length > 0)
        {
            RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
            orderByStmt = new StatementText();
            boolean needsSelect = dba.supportsOption(RDBMSAdapter.INCLUDE_ORDERBY_COLS_IN_SELECT);
            for (int i=0; i<orderingExpressions.length; ++i)
            {
                if (i > 0)
                {
                    orderByStmt.append(',');
                }

                String orderingString = null;
                if (needsSelect && !hasAggregateExpression)
                {
                    // Order by the "NUCORDER?" if we need them to be selected and it isn't an aggregate
                    orderingString = "NUCORDER" + i;
                }
                else
                {
                    // Order by the "THIS.COLUMN" otherwise
                    orderingString = 
                        orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION)
                            .toStatementString(ScalarExpression.PROJECTION);
                }

                if (orderingExpressions[i] instanceof CharacterExpression && !nlsSortOrder.equals("BINARY"))
                {
                    // Wrap with NLSSORT function
                    orderByStmt.append("NLSSORT(").append(orderingString).append(", 'NLS_SORT = ").append(nlsSortOrder).append("')");
                }
                else if (orderingExpressions[i] instanceof BooleanExpression && 
                        !(orderingExpressions[i] instanceof BooleanCharColumnExpression))
                {
                    throw new NucleusException(LOCALISER.msg("052505")).setFatal();
                }
                else
                {
                    orderByStmt.append(orderingString);
                }

                if (orderingDirections[i])
                {
                    orderByStmt.append(" DESC");
                }
            }
        }
        return orderByStmt;
    }
}