/**********************************************************************
Copyright (c) 2004 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.rdbms.query.legacy;

import java.util.HashMap;
import java.util.Iterator;

import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractExtent;
import org.datanucleus.store.query.QueryResult;

/**
 * Abstract representation of an Extent for RDBMS datastores.
 * @deprecated
 */
public abstract class AbstractRDBMSExtent extends AbstractExtent
{
    /** Query executed for returning the Extent. */
    protected final org.datanucleus.store.query.Query query;

    /** Map of the iterators of the Extents accessed. */
    protected HashMap<Iterator, QueryResult> queryResultsByIterator = new HashMap();

    /**
     * Constructor.
     * @param om Object Manager
     * @param cls candidate class
     * @param subclasses Whether to include subclasses
     * @param cmd MetaData for the candidate class
     */
    public AbstractRDBMSExtent(ObjectManager om, Class cls, boolean subclasses, AbstractClassMetaData cmd)
    {
        super(om, cls, subclasses, cmd);

        query = om.newQuery();
        query.setClass(candidateClass);
        query.setCandidates(this);
    }

    /**
     * Returns an iterator over all the instances in the Extent.
     * @return an iterator over all the instances in the Extent.
     */
    public Iterator iterator()
    {
        QueryResult qr = (QueryResult)query.execute();
        Iterator iter = qr.iterator();

        queryResultsByIterator.put(iter, qr);

        return iter;
    }

    /**
     * Close an Iterator associated with this Extent instance. Iterators closed
     * by this method will return false to hasNext() and will throw
     * NoSuchElementException on next().  The Extent instance can still be used
     * as a parameter of Query.setCandidates, and to get an Iterator.
     *
     * @param iter an iterator obtained by the method iterator() on this Extent
     * instance.
     */
    public void close(Iterator iter)
    {
        QueryResult qr = queryResultsByIterator.remove(iter);
        if (qr != null)
        {
            qr.close();
        }
    }

    /**
     * Close all Iterators associated with this Extent instance.  Iterators
     * closed by this method will return false to hasNext() and will throw
     * NoSuchElementException on next().  The Extent instance can still be used
     * as a parameter of Query.setCandidates, and to get an Iterator.
     */
    public void closeAll()
    {
        Iterator<QueryResult> iter = queryResultsByIterator.values().iterator();
        while (iter.hasNext())
        {
            QueryResult qr = iter.next();
            qr.close();
            iter.remove();
        }
    }

    /**
     * This method retrieves the fetch plan associated with the Extent. It
     * always returns the identical instance for the same Extent instance. Any
     * change made to the fetch plan affects subsequent instance retrievals via
     * next(). Only instances not already in memory are affected by the fetch
     * plan. Fetch plan is described in Section 12.7.
     * @return the FetchPlan
     */
    public FetchPlan getFetchPlan()
    {
        return query.getFetchPlan();
    }
}