/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.CandidateIdsQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.QueryToSQLMapper;
import org.datanucleus.store.rdbms.query.RDBMSQueryCompilation;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOQLQuery
extends AbstractJDOQLQuery {
    RDBMSQueryCompilation datastoreCompilation;

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.candidateCollection != null) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(forExecute, parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null) {
            return;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = storeMgr.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (RDBMSQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), this.toString());
            if (this.datastoreCompilation != null) {
                return;
            }
        }
        if (this.type == 1) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryUpdate(parameterValues, acmd);
        } else if (this.type == 2) {
            this.datastoreCompilation = new RDBMSQueryCompilation();
            this.compileQueryDelete(parameterValues, acmd);
        } else {
            RDBMSQueryCompilation rDBMSQueryCompilation = this.datastoreCompilation = new RDBMSQueryCompilation();
            synchronized (rDBMSQueryCompilation) {
                if (inMemory) {
                    this.compileQueryToRetrieveCandidates(parameterValues, acmd);
                } else {
                    this.compileQueryFull(parameterValues, acmd);
                    if (this.result != null) {
                        StatementResultMapping resultMapping = this.datastoreCompilation.getResultDefinition();
                        for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                            StatementMappingIndex idx;
                            AbstractMemberMetaData mmd;
                            Object stmtMap = resultMapping.getMappingForResultExpression(i);
                            if (!(stmtMap instanceof StatementMappingIndex) || (mmd = (idx = (StatementMappingIndex)stmtMap).getMapping().getMemberMetaData()) == null || !mmd.hasCollection() && !mmd.hasMap()) continue;
                            throw new NucleusUserException(LOCALISER.msg("021213", (Object)mmd.getFullFieldName()));
                        }
                    }
                }
                if (this.resultClass != null && this.result != null) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            StatementResultMapping resultMapping = JDOQLQuery.this.datastoreCompilation.getResultDefinition();
                            if (QueryUtils.resultClassIsSimple((String)JDOQLQuery.this.resultClass.getName())) {
                                Class resultClassPrimitive;
                                if (resultMapping.getNumberOfResultExpressions() > 1) {
                                    throw new NucleusUserException(LOCALISER.msg("021201", (Object)JDOQLQuery.this.resultClass.getName()));
                                }
                                Object stmtMap = resultMapping.getMappingForResultExpression(0);
                                StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                                Class exprType = idx.getMapping().getJavaType();
                                boolean typeConsistent = false;
                                if (exprType == JDOQLQuery.this.resultClass) {
                                    typeConsistent = true;
                                } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType((Class)JDOQLQuery.this.resultClass)) == exprType) {
                                    typeConsistent = true;
                                }
                                if (!typeConsistent) {
                                    throw new NucleusUserException(LOCALISER.msg("021202", (Object)JDOQLQuery.this.resultClass.getName(), (Object)exprType));
                                }
                            } else if (QueryUtils.resultClassIsUserType((String)JDOQLQuery.this.resultClass.getName())) {
                                Class[] ctrTypes = new Class[resultMapping.getNumberOfResultExpressions()];
                                for (int i = 0; i < ctrTypes.length; ++i) {
                                    Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                    if (stmtMap instanceof StatementMappingIndex) {
                                        ctrTypes[i] = ((StatementMappingIndex)stmtMap).getMapping().getJavaType();
                                        continue;
                                    }
                                    if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                                }
                                Constructor ctr = ClassUtils.getConstructorWithArguments((Class)JDOQLQuery.this.resultClass, (Class[])ctrTypes);
                                if (ctr == null && !ClassUtils.hasDefaultConstructor((Class)JDOQLQuery.this.resultClass)) {
                                    throw new NucleusUserException(LOCALISER.msg("021205", (Object)JDOQLQuery.this.resultClass.getName()));
                                }
                                if (ctr == null) {
                                    for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                                        Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                        if (stmtMap instanceof StatementMappingIndex) {
                                            Method putMethod;
                                            Method setMethod;
                                            StatementMappingIndex mapIdx = (StatementMappingIndex)stmtMap;
                                            AbstractMemberMetaData mmd = mapIdx.getMapping().getMemberMetaData();
                                            String fieldName = mapIdx.getColumnAlias();
                                            Class fieldType = mapIdx.getMapping().getJavaType();
                                            if (fieldName == null && mmd != null) {
                                                fieldName = mmd.getName();
                                            }
                                            if (fieldName == null) continue;
                                            Class<?> resultFieldType = null;
                                            boolean publicField = true;
                                            try {
                                                Field fld = JDOQLQuery.this.resultClass.getDeclaredField(fieldName);
                                                resultFieldType = fld.getType();
                                                if (!ClassUtils.typesAreCompatible((Class)fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, (Class)fieldType)) {
                                                    throw new NucleusUserException(LOCALISER.msg("021211", (Object)fieldName, (Object)fieldType.getName(), (Object)resultFieldType.getName()));
                                                }
                                                if (!Modifier.isPublic(fld.getModifiers())) {
                                                    publicField = false;
                                                }
                                            }
                                            catch (NoSuchFieldException nsfe) {
                                                publicField = false;
                                            }
                                            if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass((Class)JDOQLQuery.this.resultClass, (String)fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)JDOQLQuery.this.resultClass)) != null) continue;
                                            throw new NucleusUserException(LOCALISER.msg("021212", (Object)JDOQLQuery.this.resultClass.getName(), (Object)fieldName));
                                        }
                                        if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021085", (Object)this, (Object)this.datastoreCompilation.getSQL()));
                }
                boolean hasParams = false;
                if (this.explicitParameters != null) {
                    hasParams = true;
                } else if (parameterValues != null && parameterValues.size() > 0) {
                    hasParams = true;
                }
                if (!this.datastoreCompilation.isPrecompilable() || this.datastoreCompilation.getSQL().indexOf(63) < 0 && hasParams) {
                    NucleusLogger.QUERY.debug((Object)"Not caching the datastore compilation since some parameters are evaluated during the compilation and aren't present in the final SQL");
                } else {
                    qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), this.toString(), (Object)this.datastoreCompilation);
                }
            }
        }
    }

    public String getSQL() {
        if (this.datastoreCompilation != null) {
            return this.datastoreCompilation.getSQL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        List cachedResults;
        if (this.candidateCollection != null) {
            if (this.candidateCollection.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ClassLoaderResolver clr = this.om.getClassLoaderResolver();
            ArrayList candidates = new ArrayList(this.candidateCollection);
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, clr);
            return resultMapper.execute(true, true, true, true, true);
        }
        if (this.type == 0 && (cachedResults = this.getQueryManager().getDatastoreQueryResult((Query)this, parameters)) != null) {
            return new CandidateIdsQueryResult((Query)this, cachedResults);
        }
        Object results = null;
        boolean inMemory = this.evaluateInMemory();
        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
        try {
            long startTime;
            block24: {
                startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)this.getLanguage(), (Object)this.getSingleStringQuery(), null));
                }
                RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.getStoreManager();
                ClassLoaderResolver clr = this.om.getClassLoaderResolver();
                AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                try {
                    SQLController sqlControl = storeMgr.getSQLController();
                    Statement ps = null;
                    try {
                        if (this.type == 0) {
                            ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.datastoreCompilation.getSQL(), (Query)this);
                            SQLStatementHelper.applyParametersToStatement((PreparedStatement)ps, this.om, this.datastoreCompilation.getStatementParameters(), parameters);
                            RDBMSQueryUtils.prepareStatementForExecution((PreparedStatement)ps, (Query)this, false);
                            ResultSet rs = (ResultSet)this.performExecuteTask(new Object[]{sqlControl, mconn, ps});
                            AbstractRDBMSQueryResult qr = null;
                            try {
                                if (inMemory) {
                                    ResultObjectFactory rof = storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), this.getFetchPlan(), this.candidateClass);
                                    ArrayList<Object> candidates = new ArrayList<Object>();
                                    while (rs.next()) {
                                        candidates.add(rof.getObject(this.om, (Object)rs));
                                    }
                                    JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, this.compilation, parameters, clr);
                                    results = resultMapper.execute(true, true, true, true, true);
                                } else {
                                    ResultClassROF rof = null;
                                    rof = this.result != null ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinition()) : (this.resultClass != null ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinitionForClass()) : storeMgr.newResultObjectFactory(acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), this.getFetchPlan(), this.candidateClass));
                                    String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                                    qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection);
                                    ScrollableQueryResult qr1 = qr;
                                    ManagedConnection mconn1 = mconn;
                                    ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener((QueryResult)qr1, mconn1){
                                        final /* synthetic */ QueryResult val$qr1;
                                        final /* synthetic */ ManagedConnection val$mconn1;
                                        {
                                            this.val$qr1 = queryResult;
                                            this.val$mconn1 = managedConnection;
                                        }

                                        public void managedConnectionPreClose() {
                                        }

                                        public void managedConnectionPostClose() {
                                        }

                                        public void managedConnectionFlushed() {
                                            this.val$qr1.disconnect();
                                        }

                                        public void resourcePostClose() {
                                            this.val$mconn1.removeListener((ManagedConnectionResourceListener)this);
                                        }
                                    };
                                    mconn.addListener(listener);
                                    ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                    results = qr;
                                }
                                break block24;
                            }
                            finally {
                                if (qr == null) {
                                    rs.close();
                                }
                            }
                        }
                        if (this.type == 1) {
                            ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                            SQLStatementHelper.applyParametersToStatement((PreparedStatement)ps, this.om, this.datastoreCompilation.getStatementParameters(), parameters);
                            RDBMSQueryUtils.prepareStatementForExecution((PreparedStatement)ps, (Query)this, false);
                            results = this.performExecuteTask(new Object[]{sqlControl, mconn, ps});
                        } else if (this.type == 2) {
                            ps = sqlControl.getStatementForUpdate(mconn, this.datastoreCompilation.getSQL(), false);
                            SQLStatementHelper.applyParametersToStatement((PreparedStatement)ps, this.om, this.datastoreCompilation.getStatementParameters(), parameters);
                            RDBMSQueryUtils.prepareStatementForExecution((PreparedStatement)ps, (Query)this, false);
                            results = this.performExecuteTask(new Object[]{sqlControl, mconn, ps});
                        }
                    }
                    catch (QueryInterruptedException qie) {
                        ps.cancel();
                        throw qie;
                    }
                    catch (SQLException sqle) {
                        throw new NucleusException(LOCALISER.msg("021042"), (Throwable)sqle);
                    }
                }
                catch (SQLException sqle) {
                    throw new NucleusException(LOCALISER.msg("021042"), (Throwable)sqle);
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)this.getLanguage(), (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Object object = results;
            return object;
        }
        finally {
            mconn.release();
        }
    }

    protected void assertSupportsCancel() {
    }

    protected boolean supportsTimeout() {
        return true;
    }

    protected Object performExecuteInternal(Object ... args) {
        SQLController sqlControl = (SQLController)args[0];
        ManagedConnection mconn = (ManagedConnection)args[1];
        PreparedStatement ps = (PreparedStatement)args[2];
        try {
            return sqlControl.executeStatementQuery(mconn, this.toString(), ps);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException(LOCALISER.msg("021042"), (Throwable)sqle);
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        if (this.candidateCollection != null) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        if (this.result != null) {
            this.datastoreCompilation.setResultDefinition(new StatementResultMapping());
        } else {
            this.datastoreCompilation.setResultDefinitionForClass(new StatementClassMapping());
        }
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.om, this.candidateClass, this.subclasses, this.result, null, null);
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameters, this.datastoreCompilation.getResultDefinitionForClass(), this.datastoreCompilation.getResultDefinition(), candidateCmd, this.getFetchPlan(), this.om);
        sqlMapper.compile();
        this.datastoreCompilation.setPrecompilable(sqlMapper.isPrecompilable());
        stmt.setDistinct(this.resultDistinct);
        if (this.range != null) {
            long lower = this.fromInclNo;
            long upper = this.toExclNo;
            if (this.fromInclParam != null) {
                lower = ((Number)parameters.get(this.fromInclParam)).longValue();
            }
            if (this.toExclParam != null) {
                upper = ((Number)parameters.get(this.toExclParam)).longValue();
            }
            stmt.setRange(lower, upper - lower);
        }
        boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
        stmt.addExtension("lock-for-update", new Boolean(useUpdateLock));
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }

    private void compileQueryToRetrieveCandidates(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        if (this.candidateCollection != null) {
            return;
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        this.datastoreCompilation.setResultDefinitionForClass(resultsDef);
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, this.datastoreCompilation.getResultDefinitionForClass(), this.om, this.candidateClass, this.subclasses, this.result, null, null);
        if (stmt.allUnionsForSamePrimaryTable()) {
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd, this.getFetchPlan(), 1);
        } else {
            SQLStatementHelper.selectIdentityOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), candidateCmd);
        }
        this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    protected void compileQueryUpdate(Map parameterValues, AbstractClassMetaData candidateCmd) {
        Expression[] updateExprs = this.compilation.getExprUpdate();
        if (updateExprs == null || updateExprs.length == 0) {
            return;
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, resultsDef, this.om, this.candidateClass, this.subclasses, this.result, null, null);
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, resultsDef, null, candidateCmd, this.getFetchPlan(), this.om);
        sqlMapper.compile();
        DatastoreAdapter dba = ((RDBMSStoreManager)this.om.getStoreManager()).getDatastoreAdapter();
        if (stmt.getNumberOfTables() > 0 && !dba.supportsOption("UpdateMultiTable")) {
            throw new NucleusDataStoreException("Bulk update requires use of multiple tables yet datastore doesnt allow multiple table syntax");
        }
        this.datastoreCompilation.setSQL(stmt.getUpdateStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    protected void compileQueryDelete(Map parameterValues, AbstractClassMetaData candidateCmd) {
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        HashSet subclassNames = this.om.getStoreManager().getSubClassesForClass(candidateCmd.getFullClassName(), true, clr);
        if (subclassNames != null && !subclassNames.isEmpty()) {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.om.getStoreManager();
            DatastoreClass candidateTbl = storeMgr.getDatastoreClass(candidateCmd.getFullClassName(), clr);
            for (String subclassName : subclassNames) {
                DatastoreClass subclassTbl = storeMgr.getDatastoreClass(subclassName, clr);
                if (candidateTbl == null || candidateTbl == subclassTbl) continue;
                throw new NucleusException("Bulk delete doesn't currently support deletion where the candidate table also has subclasses in their own tables");
            }
            if (candidateTbl.getSuperDatastoreClass() != null) {
                throw new NucleusException("Bulk delete doesn't currently support deletion where the candidate table also has superclass table(s)");
            }
        }
        StatementClassMapping resultsDef = new StatementClassMapping();
        SQLStatement stmt = RDBMSQueryUtils.getStatementForCandidates(null, candidateCmd, resultsDef, this.om, this.candidateClass, this.subclasses, this.result, null, null);
        QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameterValues, resultsDef, null, candidateCmd, this.getFetchPlan(), this.om);
        sqlMapper.compile();
        this.datastoreCompilation.setSQL(stmt.getDeleteStatement().toString());
        this.datastoreCompilation.setStatementParameters(stmt.getSelectStatement().getParametersForStatement());
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.useUpdateLock");
        return supported;
    }

    protected boolean applyRangeChecks() {
        if (this.range == null) {
            return false;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.om.getStoreManager();
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        boolean using_limit_select_clause = dba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = dba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0;
        return this.range != null && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
    }

    public void addExtension(String key, Object value) {
        if (key != null && key.equals("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.addExtension(key, value);
    }

    public void setExtensions(Map extensions) {
        if (extensions != null && extensions.containsKey("datanucleus.query.evaluateInMemory")) {
            this.datastoreCompilation = null;
            this.getQueryManager().deleteDatastoreQueryCompilation(this.getStoreManager().getQueryCacheKey(), this.getLanguage(), this.toString());
        }
        super.setExtensions(extensions);
    }
}

