/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.schema.MSSQLTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;

public class MSSQLServerAdapter
extends DatabaseAdapter {
    private static final String MSSQL_RESERVED_WORDS = "ADD,ALL,ALTER,AND,ANY,AS,ASC,AUTHORIZATION,BACKUP,BEGIN,BETWEEN,BREAK,BROWSE,BULK,BY,CASCADE,CASE,CHECK,CHECKPOINT,CLOSE,CLUSTERED,COALESCE,COLLATE,COLUMN,COMMIT,COMPUTE,CONSTRAINT,CONTAINS,CONTAINSTABLE,CONTINUE,CONVERT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DBCC,DEALLOCATE,DECLARE,DEFAULT,DELETE,DENY,DESC,DISK,DISTINCT,DISTRIBUTED,DOUBLE,DROP,DUMMY,DUMP,ELSE,END,ERRLVL,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,FETCH,FILE,FILLFACTOR,FOR,FOREIGN,FREETEXT,FREETEXTTABLE,FROM,FULL,FUNCTION,GOTO,GRANT,GROUP,HAVING,HOLDLOCK,IDENTITY,IDENTITY_INSERT,IDENTITYCOL,IF,IN,INDEX,INNER,INSERT,INTERSECT,INTO,IS,JOIN,KEY,KILL,LEFT,LIKE,LINENO,LOAD,NATIONAL,NOCHECK,NONCLUSTERED,NOT,NULL,NULLIF,OF,OFF,OFFSETS,ON,OPEN,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OPTION,OR,ORDER,OUTER,OVER,PERCENT,PLAN,PRECISION,PRIMARY,PRINT,PROC,PROCEDURE,PUBLIC,RAISERROR,READ,READTEXT,RECONFIGURE,REFERENCES,REPLICATION,RESTORE,RESTRICT,RETURN,REVOKE,RIGHT,ROLLBACK,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SCHEMA,SELECT,SESSION_USER,SET,SETUSER,SHUTDOWN,SOME,STATISTICS,SYSTEM_USER,TABLE,TEXTSIZE,THEN,TO,TOP,TRAN,DATABASE,TRANSACTION,TRIGGER,TRUNCATE,TSEQUAL,UNION,UNIQUE,UPDATE,UPDATETEXT,USE,USER,VALUES,VARYING,VIEW,WAITFOR,WHEN,WHERE,WHILE,WITH,WRITETEXT";

    public MSSQLServerAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(this.parseKeywordList(MSSQL_RESERVED_WORDS));
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("LockOptionAfterFromClause");
        this.supportedOptions.add("LockOptionWithinJoinClause");
        this.supportedOptions.add("AnalysisMethods");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkDeleteActionRestrict");
        this.supportedOptions.remove("FkDeleteActionNull");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionRestrict");
        this.supportedOptions.remove("FkUpdateActionNull");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        MSSQLTypeInfo sqlType = new MSSQLTypeInfo("UNIQUEIDENTIFIER", 1, 36, "'", "'", "", 1, false, 2, false, false, false, "UNIQUEIDENTIFIER", 0, 0, 10);
        sqlType.setAllowsPrecisionSpec(false);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-11, sqlType, true);
        sqlType = new MSSQLTypeInfo("IMAGE", 2004, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "BLOB", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        sqlType = new MSSQLTypeInfo("TEXT", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 1, false, false, false, "TEXT", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new MSSQLTypeInfo("float", 8, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 2);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new MSSQLTypeInfo("IMAGE", -4, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "LONGVARBINARY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
    }

    public String getVendorID() {
        return "sqlserver";
    }

    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    public String getSchemaName(Connection conn) throws SQLException {
        return "";
    }

    public String getSelectNewUUIDStmt() {
        return "SELECT NEWID()";
    }

    public String getNewUUIDFunction() {
        return "NEWID()";
    }

    public boolean supportsQueryFetchSize(int size) {
        return size >= 1;
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        MSSQLTypeInfo ti = new MSSQLTypeInfo(rs);
        String typeName = ti.getTypeName();
        if (typeName.toLowerCase().startsWith("tinyint")) {
            return null;
        }
        return ti;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        return "SELECT @@IDENTITY";
    }

    public String getAutoIncrementKeyword() {
        return "IDENTITY";
    }

    public boolean isIdentityFieldDataType(String columnDef) {
        if (columnDef == null) {
            return false;
        }
        return columnDef.equalsIgnoreCase("uniqueidentifier");
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " DEFAULT VALUES";
    }

    public String getOperatorConcat() {
        return "+";
    }

    public String getSelectWithLockOption() {
        return "(UPDLOCK, ROWLOCK)";
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LEN", args);
        }
        if (method.equalsIgnoreCase("hour")) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("hh");
            args.add((String)expr);
            return new NumericExpression("DATEPART", args);
        }
        if (method.equalsIgnoreCase("minute")) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("mi");
            args.add((String)expr);
            return new NumericExpression("DATEPART", args);
        }
        if (method.equalsIgnoreCase("second")) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("ss");
            args.add((String)expr);
            return new NumericExpression("DATEPART", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        args.add(this.getNumericExpressionForMethod("length", (ScalarExpression)str).sub((ScalarExpression)begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        args.add(end.sub((ScalarExpression)begin));
        return new StringExpression("SUBSTRING", args);
    }

    public StringExpression trimMethod(StringExpression str, boolean leading, boolean trailing) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        if (leading && trailing) {
            StringExpression strExpr = new StringExpression("RTRIM", args);
            args.clear();
            args.add(strExpr);
            return new StringExpression("LTRIM", args);
        }
        if (leading) {
            return new StringExpression("LTRIM", args);
        }
        if (trailing) {
            return new StringExpression("RTRIM", args);
        }
        return str;
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        ScalarExpression integerLiteral = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(source);
        return new BooleanExpression((ScalarExpression)new StringExpression("CHARINDEX", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(source);
        if (from != null) {
            args.add(new NumericExpression((ScalarExpression)from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("CHARINDEX", args);
        return new NumericExpression((ScalarExpression)locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }
}

