/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.lang.reflect.Array;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.ArrayLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.JoinTable;

public class ArraySizeMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(LOCALISER.msg("060015", (Object)"size/length", (Object)"ArrayExpression"));
        }
        if (expr instanceof ArrayLiteral) {
            return this.exprFactory.newLiteral(this.stmt, this.exprFactory.getMappingForType(Integer.TYPE, false), new Integer(Array.getLength(((ArrayLiteral)expr).getValue())));
        }
        AbstractMemberMetaData ownerMmd = expr.getJavaTypeMapping().getMemberMetaData();
        String elementType = ownerMmd.getArray().getElementType();
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        JavaTypeMapping ownerMapping = null;
        DatastoreContainerObject arrayTbl = null;
        if (ownerMmd.getMappedBy() != null) {
            AbstractMemberMetaData elementMmd = ownerMmd.getRelatedMemberMetaData(clr)[0];
            if (ownerMmd.getJoinMetaData() != null || elementMmd.getJoinMetaData() != null) {
                arrayTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
                ownerMapping = ((JoinTable)arrayTbl).getOwnerMapping();
            } else {
                arrayTbl = storeMgr.getDatastoreClass(elementType, clr);
                ownerMapping = arrayTbl.getMemberMapping(elementMmd);
            }
        } else if (ownerMmd.getJoinMetaData() != null) {
            arrayTbl = storeMgr.getDatastoreContainerObject(ownerMmd);
            ownerMapping = ((JoinTable)arrayTbl).getOwnerMapping();
        } else {
            arrayTbl = storeMgr.getDatastoreClass(elementType, clr);
            ownerMapping = ((DatastoreClass)arrayTbl).getExternalMapping(ownerMmd, 5);
        }
        SQLStatement subStmt = new SQLStatement(this.stmt, storeMgr, arrayTbl, null, null);
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, clr);
        SQLExpression countExpr = this.exprFactory.newLiteral(subStmt, mapping, "COUNT(*)");
        ((StringLiteral)countExpr).generateStatementWithoutQuotes();
        subStmt.select(countExpr, null);
        SQLExpression elementOwnerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, expr.getSQLTable(), expr.getSQLTable().getTable().getIDMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        return new NumericSubqueryExpression(this.stmt, subStmt);
    }
}

