/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.legacy.AbstractRDBMSExtent;
import org.datanucleus.store.rdbms.query.legacy.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.legacy.UnionIteratorStatement;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class ClassTableExtent
extends AbstractRDBMSExtent
implements Queryable {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    private final DatastoreClass[] tables;
    private final boolean multipleTableCase;
    private final DatastoreIdentifier elmIdentifier;

    public ClassTableExtent(ObjectManager om, DatastoreClass table, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.tables = new DatastoreClass[1];
        this.tables[0] = table;
        this.multipleTableCase = false;
        this.elmIdentifier = ((MappedStoreManager)this.storeMgr).getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "ELEMENT");
    }

    public ClassTableExtent(ObjectManager om, DatastoreClass[] tables, Class cls, boolean subclasses, AbstractClassMetaData cmd) {
        super(om, cls, subclasses, cmd);
        this.tables = tables;
        this.multipleTableCase = true;
        this.elmIdentifier = ((MappedStoreManager)this.storeMgr).getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "ELEMENT");
    }

    public QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.getCandidateClass(), null);
    }

    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias) {
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        QueryExpression query = null;
        if (this.tables == null) {
            return null;
        }
        for (int i = 0; i < this.tables.length; ++i) {
            int tableNo = i;
            Class cls = null;
            try {
                cls = clr.classForName(this.tables[tableNo].getType(), this.candidateClass.getClassLoader());
            }
            catch (ClassNotResolvedException cnfe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("053002", (Object)candidateClass.getName(), (Object)this.tables[tableNo].getType())).setFatal();
            }
            if (this.queryUsingDiscriminator()) {
                Class[] candidates = null;
                if (ClassUtils.isReferenceType((Class)candidateClass)) {
                    String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(candidateClass.getName(), clr);
                    candidates = new Class[clsNames.length];
                    for (int j = 0; j < clsNames.length; ++j) {
                        candidates[j] = clr.classForName(clsNames[j]);
                    }
                } else {
                    candidates = new Class[]{candidateClass};
                }
                query = new DiscriminatorIteratorStatement(clr, candidates, this.subclasses, this.storeMgr, true).getQueryStatement(candidateAlias);
                continue;
            }
            boolean completeTableInheritance = this.cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE;
            boolean useSubclassesInStatement = this.subclasses;
            if (completeTableInheritance) {
                useSubclassesInStatement = false;
            }
            QueryExpression query_table = new UnionIteratorStatement(clr, this.multipleTableCase ? cls : candidateClass, useSubclassesInStatement, this.storeMgr, clr.classForName(this.tables[tableNo].getType()), this.tables[tableNo].getIDMapping(), (DatastoreContainerObject)this.tables[tableNo], false, Boolean.TRUE, !completeTableInheritance, false).getQueryStatement(candidateAlias);
            if (query != null) {
                query.union(query_table);
                continue;
            }
            query = query_table;
        }
        return query;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        int[] prefetchFieldNumbers = null;
        StatementMappingIndex[] stmtMappings = null;
        if (this.multipleTableCase) {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), stmt.getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                stmtMappings = new StatementMappingIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    String fieldName = cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]).getName();
                    JavaTypeMapping m = this.tables[0].getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    stmtMappings[prefetchFieldNumbers[i]] = new StatementMappingIndex(m);
                    stmtMappings[prefetchFieldNumbers[i]].setColumnPositions(stmt.selectField(fieldName, "APP_ID", true));
                }
            }
        } else {
            ClassLoaderResolver clr = stmt.getClassLoaderResolver();
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.getCandidateClass(), clr);
            if (useFetchPlan) {
                this.getFetchPlan().manageFetchPlanForClass(cmd);
                FetchPlan.FetchPlanForClass fpc = this.getFetchPlan().getFetchPlanForClass(cmd);
                int[] fieldNumbers = fpc.getFieldsInActualFetchPlan();
                int prefetchFieldCount = 0;
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                int[] fn = new int[fieldNumbers.length];
                stmtMappings = new StatementMappingIndex[fieldCount];
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    JavaTypeMapping m = this.tables[0].getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    stmtMappings[fieldNumbers[i]] = new StatementMappingIndex(m);
                    ExpressionHelper.selectMapping((StatementMappingIndex)stmtMappings[fieldNumbers[i]], (QueryExpression)stmt, (DatastoreIdentifier)(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : null), (ClassLoaderResolver)clr);
                    fn[prefetchFieldCount++] = fieldNumbers[i];
                }
                prefetchFieldNumbers = new int[prefetchFieldCount];
                System.arraycopy(fn, 0, prefetchFieldNumbers, 0, prefetchFieldCount);
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
                int fieldCount = cmd.getNoOfInheritedManagedMembers() + cmd.getNoOfManagedMembers();
                stmtMappings = new StatementMappingIndex[fieldCount];
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    prefetchFieldNumbers[i] = cmd.getPKMemberPositions()[i];
                    JavaTypeMapping m = this.tables[0].getMemberMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[i]));
                    if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                    stmtMappings[prefetchFieldNumbers[i]] = new StatementMappingIndex(m);
                    ExpressionHelper.selectMapping((StatementMappingIndex)stmtMappings[prefetchFieldNumbers[i]], (QueryExpression)stmt, (DatastoreIdentifier)(stmt.getTableExpression(this.elmIdentifier) != null ? this.elmIdentifier : null), (ClassLoaderResolver)clr);
                }
            }
        }
        if (resultClass == null) {
            JavaTypeMapping discrimMapping;
            JavaTypeMapping versionMapping;
            StatementClassMapping mappingDefinition = new StatementClassMapping(null);
            if (prefetchFieldNumbers != null) {
                for (int i = 0; i < prefetchFieldNumbers.length; ++i) {
                    mappingDefinition.addMappingForMember(prefetchFieldNumbers[i], stmtMappings[prefetchFieldNumbers[i]]);
                }
            }
            if (this.tables[0].getIdentityType() == IdentityType.DATASTORE) {
                int[] datastoreIndex = null;
                datastoreIndex = this.multipleTableCase ? stmt.selectDatastoreIdentity("DATASTORE_ID", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, this.tables[0].getDataStoreObjectIdMapping(), true) : stmt.select(stmt.getMainTableAlias(), this.tables[0].getDataStoreObjectIdMapping(), true));
                StatementMappingIndex datastoreMappingIdx = new StatementMappingIndex(this.tables[0].getDataStoreObjectIdMapping());
                datastoreMappingIdx.setColumnPositions(datastoreIndex);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreMappingIdx);
            }
            if ((versionMapping = this.tables[0].getVersionMapping(true)) != null) {
                int[] versionIndex = null;
                versionIndex = this.multipleTableCase ? stmt.selectVersion("VERSION", true) : (stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, versionMapping, true) : stmt.select(stmt.getMainTableAlias(), versionMapping, true));
                StatementMappingIndex versionMappingIdx = new StatementMappingIndex(versionMapping);
                versionMappingIdx.setColumnPositions(versionIndex);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_VERSION, versionMappingIdx);
            }
            if ((discrimMapping = this.tables[0].getDiscriminatorMapping(true)) != null && this.queryUsingDiscriminator()) {
                int[] discrimIndex = null;
                if (!this.multipleTableCase) {
                    discrimIndex = stmt.getTableExpression(this.elmIdentifier) != null ? stmt.select(this.elmIdentifier, discrimMapping, true) : stmt.select(stmt.getMainTableAlias(), discrimMapping, true);
                }
                if (discrimIndex != null) {
                    StatementMappingIndex discrimMappingIdx = new StatementMappingIndex(discrimMapping);
                    discrimMappingIdx.setColumnPositions(discrimIndex);
                    mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DISCRIMINATOR, discrimMappingIdx);
                }
            }
            if (stmt.hasNucleusTypeExpression()) {
                mappingDefinition.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            return ((MappedStoreManager)this.storeMgr).newResultObjectFactory(this.cmd, mappingDefinition, ignoreCache, this.getFetchPlan(), this.query.getCandidateClass());
        }
        return new ResultClassROF(resultClass, stmtMappings, null);
    }

    private boolean queryUsingDiscriminator() {
        boolean usingDiscriminator = true;
        if (this.tables.length == 1) {
            if (this.tables[0].getDiscriminatorMapping(true) == null) {
                return false;
            }
            return usingDiscriminator;
        }
        return false;
    }

    public boolean isEmpty() {
        return false;
    }
}

