/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.RDBMSQueryCompilation;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

public class RDBMSQueryUtils
extends QueryUtils {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());

    public static String getClassNameFromDiscriminatorResultSetRow(JavaTypeMapping discrimMapping, DiscriminatorMetaData dismd, ResultSet rs, ObjectManager om) {
        String rowClassName = null;
        if (discrimMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
            try {
                String discriminatorColName = discrimMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifierName();
                String discriminatorValue = rs.getString(discriminatorColName);
                rowClassName = MetaDataUtils.getClassNameFromDiscriminatorValue((String)discriminatorValue, (DiscriminatorMetaData)dismd, (ObjectManager)om);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return rowClassName;
    }

    public static String getResultSetTypeForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetType";
        String rsTypeString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsTypeExt = query.getExtension(propName);
        if (rsTypeExt != null) {
            rsTypeString = (String)rsTypeExt;
        }
        return rsTypeString;
    }

    public static String getResultSetConcurrencyForQuery(Query query) {
        String propName = "datanucleus.rdbms.query.resultSetConcurrency";
        String rsConcurrencyString = query.getObjectManager().getOMFContext().getPersistenceConfiguration().getStringProperty(propName);
        Object rsConcurrencyExt = query.getExtension(propName);
        if (rsConcurrencyExt != null) {
            rsConcurrencyString = (String)rsConcurrencyExt;
        }
        return rsConcurrencyString;
    }

    public static boolean useUpdateLockForQuery(Query query) {
        if (query.getSerializeRead() != null) {
            return query.getSerializeRead();
        }
        return query.getObjectManager().getSerializeReadForClass(query.getCandidateClassName());
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, String queryStmt, Query query) throws SQLException {
        ObjectManager om = query.getObjectManager();
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new NucleusUserException(LOCALISER.msg("052510"));
        }
        String rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query);
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new NucleusUserException(LOCALISER.msg("052511"));
        }
        SQLController sqlControl = ((RDBMSStoreManager)om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, queryStmt, rsTypeString, rsConcurrencyString);
        return ps;
    }

    public static PreparedStatement getPreparedStatementForQuery(ManagedConnection conn, StatementText stmtText, Query query) throws SQLException {
        ObjectManager om = query.getObjectManager();
        String rsTypeString = RDBMSQueryUtils.getResultSetTypeForQuery(query);
        if (!(rsTypeString == null || rsTypeString.equals("scroll-sensitive") || rsTypeString.equals("forward-only") || rsTypeString.equals("scroll-insensitive"))) {
            throw new NucleusUserException(LOCALISER.msg("052510"));
        }
        String rsConcurrencyString = RDBMSQueryUtils.getResultSetConcurrencyForQuery(query);
        if (rsConcurrencyString != null && !rsConcurrencyString.equals("read-only") && !rsConcurrencyString.equals("updateable")) {
            throw new NucleusUserException(LOCALISER.msg("052511"));
        }
        SQLController sqlControl = ((RDBMSStoreManager)om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, stmtText.toString(), rsTypeString, rsConcurrencyString);
        if (query.getTimeoutMillis() != null) {
            ps.setQueryTimeout(query.getTimeoutMillis() / 1000);
        }
        stmtText.applyParametersToStatement(om, (Object)ps);
        return ps;
    }

    public static void prepareStatementForExecution(PreparedStatement ps, Query query, boolean applyTimeout) throws SQLException {
        Integer timeout;
        OMFContext omfCtx = query.getObjectManager().getOMFContext();
        MappedStoreManager storeMgr = (MappedStoreManager)omfCtx.getStoreManager();
        PersistenceConfiguration conf = omfCtx.getPersistenceConfiguration();
        if (applyTimeout && (timeout = query.getTimeoutMillis()) != null && timeout > 0) {
            ps.setQueryTimeout(timeout / 1000);
        }
        int fetchSize = 0;
        if (query.getFetchPlan().getFetchSize() > 0) {
            fetchSize = query.getFetchPlan().getFetchSize();
        }
        if (storeMgr.getDatastoreAdapter().supportsQueryFetchSize(fetchSize)) {
            ps.setFetchSize(fetchSize);
        }
        String propName = "datanucleus.rdbms.query.fetchDirection";
        String fetchDir = conf.getStringProperty(propName);
        Object fetchDirExt = query.getExtension(propName);
        if (!(fetchDirExt == null || (fetchDir = (String)fetchDirExt).equals("forward") || fetchDir.equals("reverse") || fetchDir.equals("unknown"))) {
            throw new NucleusUserException(LOCALISER.msg("052512"));
        }
        if (fetchDir.equals("reverse")) {
            ps.setFetchDirection(1001);
        } else if (fetchDir.equals("unknown")) {
            ps.setFetchDirection(1002);
        }
        long toExclNo = query.getRangeToExcl();
        if (toExclNo != 0L && toExclNo != Long.MAX_VALUE) {
            if (toExclNo > Integer.MAX_VALUE) {
                ps.setMaxRows(Integer.MAX_VALUE);
            } else {
                ps.setMaxRows((int)toExclNo);
            }
        }
    }

    public static SQLStatement getStatementForCandidates(AbstractClassMetaData cmd, StatementClassMapping clsMapping, ObjectManager om, Class candidateCls, boolean subclasses, String result) {
        SQLStatement stmt = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)om.getStoreManager();
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        DatastoreClass candidateTable = storeMgr.getDatastoreClass(candidateCls.getName(), clr);
        HashSet<DatastoreClass> candidateTables = new HashSet<DatastoreClass>();
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            HashSet subclassNames;
            if (candidateTable != null) {
                candidateTables.add(candidateTable);
            }
            if (subclasses && (subclassNames = storeMgr.getSubClassesForClass(cmd.getFullClassName(), subclasses, clr)) != null) {
                for (String subclassName : subclassNames) {
                    DatastoreClass tbl = storeMgr.getDatastoreClass(subclassName, clr);
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            Iterator iter = candidateTables.iterator();
            int maxClassNameLength = cmd.getFullClassName().length();
            while (iter.hasNext()) {
                DatastoreClass cls = (DatastoreClass)iter.next();
                String className = cls.getType();
                if (className.length() <= maxClassNameLength) continue;
                maxClassNameLength = className.length();
            }
            for (DatastoreClass cls : candidateTables) {
                SQLStatement tblStmt = new SQLStatement(storeMgr, (DatastoreContainerObject)candidateTable, null, null);
                tblStmt.setCandidateClassName(cls.getType());
                JavaTypeMapping m = storeMgr.getMappingManager().getMapping(String.class);
                String nuctypeName = cls.getType();
                if (maxClassNameLength > nuctypeName.length()) {
                    nuctypeName = StringUtils.leftAlignedPaddedString((String)nuctypeName, (int)maxClassNameLength);
                }
                StringLiteral lit = new StringLiteral(tblStmt, m, nuctypeName, false);
                tblStmt.select(lit, "NUCLEUS_TYPE");
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
            clsMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
        } else {
            if (candidateTable != null) {
                candidateTables.add(candidateTable);
            } else {
                AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(cmd, clr);
                if (cmds != null && cmds.length > 0) {
                    for (int i = 0; i < cmds.length; ++i) {
                        DatastoreClass table = storeMgr.getDatastoreClass(cmds[i].getFullClassName(), clr);
                        candidateTables.add(table);
                    }
                } else {
                    throw new UnsupportedOperationException("No tables for query of " + cmd.getFullClassName());
                }
            }
            for (DatastoreClass tbl : candidateTables) {
                Class cls = null;
                try {
                    cls = clr.classForName(tbl.getType(), candidateCls.getClassLoader());
                }
                catch (ClassNotResolvedException cnfe) {
                    throw new NucleusException("Attempt to find primary class for " + tbl + " as " + tbl.getType() + " but not found");
                }
                AbstractStatementGenerator stmtGen = null;
                if (tbl.getDiscriminatorMapping(true) != null || QueryUtils.resultHasOnlyAggregates((String)result)) {
                    stmtGen = new DiscriminatorStatementGenerator(storeMgr, cls, subclasses, null, "this");
                } else {
                    stmtGen = new UnionStatementGenerator(storeMgr, cls, subclasses, null, "this");
                    if (result == null) {
                        stmtGen.setOption("selectNucleusType");
                        clsMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
                    }
                }
                SQLStatement tblStmt = stmtGen.getStatement();
                if (stmt == null) {
                    stmt = tblStmt;
                    continue;
                }
                stmt.union(tblStmt);
            }
        }
        return stmt;
    }

    public static void applyParametersToStatement(Map parameterValuesByName, PreparedStatement ps, RDBMSQueryCompilation datastoreCompilation, ObjectManager om) throws SQLException {
        if (datastoreCompilation.getParameterDefinition() == null || datastoreCompilation.getParameterDefinition().isEmpty()) {
            return;
        }
        for (Map.Entry entry : parameterValuesByName.entrySet()) {
            Object paramValue = entry.getValue();
            StatementMappingIndex paramIdx = null;
            if (entry.getKey() instanceof String) {
                String paramName = (String)entry.getKey();
                paramIdx = datastoreCompilation.getParameterDefinition().getMappingForParameter(paramName);
            } else {
                Integer paramPos = (Integer)entry.getKey();
                paramIdx = datastoreCompilation.getParameterDefinition().getMappingForParameterPosition(paramPos + 1);
            }
            if (paramIdx != null) {
                for (int i = 0; i < paramIdx.getNumberOfParameterOccurrences(); ++i) {
                    int[] positions = paramIdx.getParameterPositionsForOccurrence(i);
                    JavaTypeMapping mapping = paramIdx.getMapping();
                    if (paramValue == null) {
                        mapping.setObject(om, (Object)ps, positions, null);
                        continue;
                    }
                    if (mapping.getJavaType() == Boolean.class) {
                        mapping.setBoolean(om, (Object)ps, positions, ((Boolean)paramValue).booleanValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Byte.class) {
                        mapping.setByte(om, (Object)ps, positions, ((Byte)paramValue).byteValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Character.class) {
                        mapping.setChar(om, (Object)ps, positions, ((Character)paramValue).charValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Double.class) {
                        mapping.setDouble(om, (Object)ps, positions, ((Double)paramValue).doubleValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Float.class) {
                        mapping.setFloat(om, (Object)ps, positions, ((Float)paramValue).floatValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Integer.class) {
                        mapping.setInt(om, (Object)ps, positions, ((Integer)paramValue).intValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Long.class) {
                        mapping.setLong(om, (Object)ps, positions, ((Long)paramValue).longValue());
                        continue;
                    }
                    if (mapping.getJavaType() == Short.class) {
                        mapping.setShort(om, (Object)ps, positions, ((Short)paramValue).shortValue());
                        continue;
                    }
                    if (mapping.getJavaType() == String.class) {
                        mapping.setString(om, (Object)ps, positions, (String)paramValue);
                        continue;
                    }
                    mapping.setObject(om, (Object)ps, positions, paramValue);
                }
                continue;
            }
            if (entry.getKey() instanceof String) {
                throw new QueryInvalidParametersException("Parameter " + entry.getKey() + " specified but no mapping in statement found for it. Check the name");
            }
            throw new QueryInvalidParametersException("Parameter at position " + entry.getKey() + " specified but no mapping in statement found for it. Check the query");
        }
    }
}

