/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.AbstractAutoStartMechanism;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.exceptions.DatastoreInitialisationException;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.table.SchemaTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SchemaAutoStarter
extends AbstractAutoStartMechanism {
    private static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected SchemaTable schemaTable = null;
    protected RDBMSStoreManager storeMgr = null;
    protected ManagedConnection mconn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaAutoStarter(StoreManager store_mgr, ClassLoaderResolver clr) {
        this.storeMgr = (RDBMSStoreManager)store_mgr;
        PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
        String tableName = conf.getStringProperty("datanucleus.rdbms.schemaTable.tableName");
        this.schemaTable = new SchemaTable(this.storeMgr, tableName);
        this.schemaTable.initialize(clr);
        ManagedConnection mconn = this.storeMgr.getConnection(0);
        Connection conn = (Connection)mconn.getConnection();
        try {
            this.schemaTable.exists(conn, true);
            if (this.storeMgr.getDdlWriter() != null) {
                try {
                    this.schemaTable.validate(conn, true, false, null);
                }
                catch (MissingTableException mte) {}
            } else {
                this.schemaTable.validate(conn, true, false, null);
            }
        }
        catch (Exception e) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("049001", (Object)this.storeMgr.getSchemaName(), (Object)e));
            try {
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER_RDBMS.msg("049002", (Object)this.schemaTable.toString()));
                }
                try {
                    this.schemaTable.drop(conn);
                }
                catch (SQLException sqe) {
                    // empty catch block
                }
                this.schemaTable.exists(conn, true);
                this.schemaTable.validate(conn, true, false, null);
            }
            catch (Exception e2) {
                NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("049001", (Object)this.storeMgr.getSchemaName(), (Object)e2));
            }
        }
        finally {
            mconn.close();
        }
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        try {
            this.assertIsOpen();
            HashSet data = null;
            try {
                data = this.schemaTable.getAllClasses(this.mconn);
            }
            catch (SQLException sqe2) {
                NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("049000", (Object)sqe2));
            }
            return data;
        }
        catch (Exception e) {
            throw new DatastoreInitialisationException(LOCALISER_RDBMS.msg("049010", (Object)e), (Throwable)e);
        }
    }

    private void assertIsOpen() {
        if (this.mconn == null) {
            throw new NucleusException(LOCALISER_RDBMS.msg("049008")).setFatal();
        }
    }

    private void assertIsClosed() {
        if (this.mconn != null) {
            throw new NucleusException(LOCALISER_RDBMS.msg("049009")).setFatal();
        }
    }

    public void open() {
        this.assertIsClosed();
        this.mconn = this.storeMgr.getConnection(0);
    }

    public void close() {
        this.assertIsOpen();
        try {
            this.mconn.close();
            this.mconn = null;
        }
        catch (NucleusException sqe2) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("050005", (Object)sqe2));
        }
    }

    public boolean isOpen() {
        return this.mconn != null;
    }

    public void addClass(StoreData data) {
        MappedStoreData tableData = (MappedStoreData)data;
        this.assertIsOpen();
        try {
            this.schemaTable.addClass(tableData, this.mconn);
        }
        catch (SQLException sqe2) {
            String msg = LOCALISER_RDBMS.msg("049003", (Object)data.getName(), (Object)sqe2);
            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
            throw new NucleusDataStoreException(msg, (Throwable)sqe2);
        }
    }

    public void deleteClass(String class_name) {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteClass(class_name, this.mconn);
        }
        catch (SQLException sqe2) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("049005", (Object)class_name, (Object)sqe2));
        }
    }

    public void deleteAllClasses() {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteAllClasses(this.mconn);
        }
        catch (SQLException sqe2) {
            NucleusLogger.DATASTORE_SCHEMA.error((Object)LOCALISER_RDBMS.msg("049006", (Object)sqe2));
        }
    }

    public String getStorageDescription() {
        return LOCALISER_RDBMS.msg("049007", (Object)this.schemaTable.toString());
    }
}

