/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.datatype.BlobImpl;
import org.datanucleus.store.rdbms.mapping.AbstractLargeBinaryRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;

public class BlobRDBMSMapping
extends AbstractLargeBinaryRDBMSMapping {
    protected BlobRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BlobRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(mapping, storeMgr, field);
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSStoreManager)this.storeMgr).getSQLTypeInfoForJDBCType(2004);
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (this.getDatabaseAdapter().supportsOption("BlobSetUsingSetString")) {
                if (value == null) {
                    if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                        ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                    } else {
                        ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                    }
                } else {
                    ((PreparedStatement)ps).setString(param, value);
                }
            } else if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setBlob(param, new BlobImpl(this.column.getDefaultValue().toString().trim()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else {
                ((PreparedStatement)ps).setBlob(param, new BlobImpl(value));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            if (this.getDatabaseAdapter().supportsOption("BlobSetUsingSetString")) {
                value = ((ResultSet)rs).getString(param);
            } else {
                byte[] bytes = ((ResultSet)rs).getBytes(param);
                if (bytes == null) {
                    value = null;
                } else {
                    BlobImpl blob = new BlobImpl(bytes);
                    value = (String)blob.getObject();
                }
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

